/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.proxy;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.addons.core.PluginCore;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.WailaPlugin;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.config.OverlayConfig;
import mcp.mobius.waila.proxy.IProxy;
import mcp.mobius.waila.utils.ModIdentification;
import mcp.mobius.waila.utils.PluginUtil;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ProxyCommon
implements IProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        Waila.plugins = event.getAsmData().getAll(WailaPlugin.class.getCanonicalName());
        Waila.configDir = new File(event.getModConfigurationDirectory(), "waila");
        Waila.themeDir = new File(Waila.configDir, "theme");
        ConfigHandler.instance().loadDefaultConfig(event);
        OverlayConfig.updateColors();
    }

    @Override
    public void init(FMLInitializationEvent event) {
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        ModIdentification.init();
    }

    @Override
    public void loadComplete(FMLLoadCompleteEvent event) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Waila.LOGGER.info("Starting Waila...");
        HashMap plugins = Maps.newHashMap();
        Waila.LOGGER.info("Gathering annotated plugins...");
        PluginUtil.gatherAnnotatedPlugins(plugins);
        Waila.LOGGER.info("Gathering wrapped IMC plugins...");
        PluginUtil.gatherIMCPlugins(plugins);
        Waila.LOGGER.info("Registering plugins...");
        ((IWailaPlugin)plugins.remove(PluginCore.class)).register(ModuleRegistrar.instance());
        Waila.LOGGER.info("Registering plugin at {}", (Object)PluginCore.class.getCanonicalName());
        ArrayList sortedPlugins = Lists.newArrayList(plugins.entrySet());
        sortedPlugins.sort((o1, o2) -> {
            if (((Class)o1.getKey()).getCanonicalName().startsWith("mcp.mobius.waila")) {
                return -1;
            }
            return ((Class)o1.getKey()).getCanonicalName().compareToIgnoreCase(((Class)o2.getKey()).getCanonicalName());
        });
        for (Map.Entry plugin : sortedPlugins) {
            Waila.LOGGER.info("Registering plugin at {}", (Object)((Class)plugin.getKey()).getCanonicalName());
            ((IWailaPlugin)plugin.getValue()).register(ModuleRegistrar.instance());
        }
        Waila.LOGGER.info("Starting Waila took {}", (Object)stopwatch.stop());
    }
}

