/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.module.proxy;

import com.valkyrieofnight.vlib.core.IGroupModInfo;
import com.valkyrieofnight.vlib.core.IModInfo;
import com.valkyrieofnight.vlib.core.network.PacketDispatcher;
import com.valkyrieofnight.vlib.module.VLModule3;
import com.valkyrieofnight.vlib.module.config.IConfig;
import com.valkyrieofnight.vlib.module.registry.VLGameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

public class VLProxyCommon {
    protected final IModInfo info;
    protected MainModule main;
    protected PacketDispatcher dispatcher;

    public VLProxyCommon(IModInfo info) {
        this.info = info;
        this.dispatcher = new PacketDispatcher(this.info.getModID());
        if (this.info instanceof IGroupModInfo) {
            IGroupModInfo gmi = (IGroupModInfo)this.info;
            this.main = new MainModule(gmi.getMemberID());
        } else {
            this.main = new MainModule(this.info.getModID());
        }
        this.main.setModInfo(info);
        VLGameRegistry.getInstance().registerProxy(this);
    }

    public void commonInitPre(FMLPreInitializationEvent event) {
        this.main.moduleSetup();
        if (this.info instanceof IGroupModInfo) {
            IGroupModInfo gmi = (IGroupModInfo)this.info;
            this.main.loadConfigMain("config/" + gmi.getGroupID() + "/");
        } else {
            this.main.loadConfigMain("config/");
        }
        this.main.moduleInitPre();
        this.main.registerPackets(this.dispatcher);
        this.main.commonInitPre(event);
    }

    public void commonInit(FMLInitializationEvent event) {
        this.main.commonInit(event);
    }

    public void commonInitPost(FMLPostInitializationEvent event) {
        this.main.commonInitPost(event);
        this.main.saveConfigMain();
    }

    public void serverStarting(FMLServerStartingEvent event) {
        this.main.serverStarting(event);
    }

    public final void registerEventBlocks(RegistryEvent.Register<Block> event) {
        this.main.registerEventBlocks(event);
    }

    public final void registerEventItems(RegistryEvent.Register<Item> event) {
        this.main.registerEventItems(event);
    }

    public final IModInfo getInfo() {
        return this.info;
    }

    public final VLModule3 getMainModule() {
        return this.main;
    }

    public final IConfig getGlobalConfig() {
        return this.main.getConfig();
    }

    protected static class MainModule
    extends VLModule3 {
        public static int documentation_version;

        public MainModule(String modid) {
            super(modid);
        }

        @Override
        protected void setup() {
        }

        @Override
        protected void moduleInitPre(IConfig config) {
            this.getGlobalConfig().getBoolean("generate_documentation", true, "valkyrielib.documentation.enabled", "valkyrielib.documentation.");
        }

        @Override
        public boolean isEnabledByDefualt() {
            return true;
        }

        @Override
        public final boolean canDisable() {
            return false;
        }

        public final void loadConfigMain(String baseDirectory) {
            this.loadConfigs(baseDirectory, null);
        }

        public final void saveConfigMain() {
            this.saveConfigs();
        }

        public void saveDocumentationClient() {
            this.saveDocumentation();
        }
    }
}

