/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock_legacy.structure;

import com.valkyrieofnight.vlib.multiblock_legacy.api.structure.IBlockOffset;
import com.valkyrieofnight.vlib.multiblock_legacy.api.structure.IStructureSize;
import com.valkyrieofnight.vlib.multiblock_legacy.structure.BlockOffset;

public class StructureSize
implements IStructureSize {
    protected BlockOffset posStart;
    protected BlockOffset posEnd;
    protected int xSize;
    protected int ySize;
    protected int zSize;

    public StructureSize(BlockOffset start, BlockOffset end) {
        this.posStart = start;
        this.posEnd = end;
        this.expand(new BlockOffset());
    }

    public StructureSize() {
        this.posStart = new BlockOffset();
        this.posEnd = new BlockOffset();
        this.calcSize();
    }

    @Override
    public void expand(IBlockOffset pos) {
        this.posStart = this.min(this.posStart, pos);
        this.posEnd = this.max(this.posEnd, pos);
        this.calcSize();
    }

    private BlockOffset min(IBlockOffset one, IBlockOffset two) {
        return new BlockOffset(Math.min(one.getXOffset(), two.getXOffset()), Math.min(one.getYOffset(), two.getYOffset()), Math.min(one.getZOffset(), two.getZOffset()));
    }

    private BlockOffset max(IBlockOffset one, IBlockOffset two) {
        return new BlockOffset(Math.max(one.getXOffset(), two.getXOffset()), Math.max(one.getYOffset(), two.getYOffset()), Math.max(one.getZOffset(), two.getZOffset()));
    }

    private void calcSize() {
        this.xSize = this.posEnd.getXOffset() - this.posStart.getXOffset() + 1;
        this.ySize = this.posEnd.getYOffset() - this.posStart.getYOffset() + 1;
        this.zSize = this.posEnd.getZOffset() - this.posStart.getZOffset() + 1;
    }

    @Override
    public int getXSize() {
        return this.xSize;
    }

    @Override
    public int getYSize() {
        return this.ySize;
    }

    @Override
    public int getZSize() {
        return this.zSize;
    }
}

