/*
 * Decompiled with CFR 0.152.
 */
package de.whitedraco.portablecraft;

import de.whitedraco.portablecraft.config.EnchantmentConfig;
import de.whitedraco.portablecraft.enchantment.EnchantBrewingStandSpeed;
import de.whitedraco.portablecraft.enchantment.EnchantFurnaceSpeed;
import de.whitedraco.portablecraft.enchantment.EnchantHeatHold;
import de.whitedraco.portablecraft.item.pattern.ItemPatternBrewingStand;
import de.whitedraco.portablecraft.item.pattern.ItemPatternFurnace;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EnchantInit {
    public static final EnumEnchantmentType Furnace = EnumHelper.addEnchantmentType((String)"furnace", item -> item instanceof ItemPatternFurnace);
    public static final EnumEnchantmentType BrewingStand = EnumHelper.addEnchantmentType((String)"brewingstand", item -> item instanceof ItemPatternBrewingStand);
    public static final Enchantment HeadHold = new EnchantHeatHold();
    public static final Enchantment FurnaceSpeed = new EnchantFurnaceSpeed();
    public static final Enchantment BrewingStandSpeed = new EnchantBrewingStandSpeed();
    public static ArrayList<Enchantment> enchantList = new ArrayList();

    public static void prepareEnchant() {
        if (EnchantmentConfig.enchantHeatHoldRegistry.isData()) {
            enchantList.add(HeadHold);
        }
        if (EnchantmentConfig.enchantFurnaceSpeedLevelRegistry.isData()) {
            enchantList.add(FurnaceSpeed);
        }
        if (EnchantmentConfig.enchantBrewingStandSpeedLevelRegistry.isData()) {
            enchantList.add(BrewingStandSpeed);
        }
    }

    public static void registerEnchant(RegistryEvent.Register<Enchantment> event) {
        for (Enchantment enchant : enchantList) {
            MinecraftForge.EVENT_BUS.register((Object)enchant);
            event.getRegistry().register((IForgeRegistryEntry)enchant);
        }
    }
}

