/*
 * Decompiled with CFR 0.152.
 */
package de.whitedraco.portablecraft.config;

import de.whitedraco.portablecraft.config.variable.ConfigSaveBoolean;
import de.whitedraco.portablecraft.config.variable.ConfigSaveInt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class EnchantmentConfig {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static File ConfigPathCraftingConfig = new File("config/PortableCraft/Enchantment_Setting.cfg");
    public static ConfigSaveBoolean enchantHeatHoldRegistry = new ConfigSaveBoolean("<Furnace-Upgrade: 'Hold heat'>", true);
    public static ConfigSaveBoolean enchantFurnaceSpeedLevelRegistry = new ConfigSaveBoolean("<Furnace-Upgrade: 'Speed-Level'>", true);
    public static ConfigSaveInt enchantFurnaceSpeedMaxLevel = new ConfigSaveInt("<Furnace-Upgrade: max. 'Speed-Level'>", 5);
    public static ConfigSaveInt enchantFurnaceSpeedLevelPercent = new ConfigSaveInt("<Furnace-Upgrade: 'Speed-Level' in percent>", 720);
    public static ConfigSaveBoolean enchantBrewingStandSpeedLevelRegistry = new ConfigSaveBoolean("<Brewing-Stand-Upgrade: 'Speed-Level'>", true);
    public static ConfigSaveInt enchantBrewingStandSpeedMaxLevel = new ConfigSaveInt("<Brewing-Stand-Upgrade: max. 'Speed-Level'>", 5);
    public static ConfigSaveInt enchantBrewingStandSpeedLevelPercent = new ConfigSaveInt("<Brewing-Stand-Upgrade: 'Speed-Level' in percent>", 720);

    public static void writeConfigCrafting() throws IOException {
        FileWriter fw = new FileWriter(ConfigPathCraftingConfig);
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write("###Enchantment Settings###" + LINE_SEPARATOR);
        bw.write("#Enable('true') or disable('false') Enchantments (default: true)#" + LINE_SEPARATOR);
        bw.write(LINE_SEPARATOR);
        bw.write("##Furnace-Upgrades##" + LINE_SEPARATOR);
        bw.write("#Furnace-Upgrade: 'Hold heat'#" + LINE_SEPARATOR);
        bw.write(enchantHeatHoldRegistry.getString());
        bw.write(LINE_SEPARATOR);
        bw.write("#Furnace-Upgrade: 'Speed-Level'#" + LINE_SEPARATOR);
        bw.write(enchantFurnaceSpeedLevelRegistry.getString());
        bw.write(enchantFurnaceSpeedMaxLevel.getString());
        bw.write("#How effective a 'Speed-Level' is in percent#");
        bw.write(enchantFurnaceSpeedLevelPercent.getString());
        bw.write(LINE_SEPARATOR);
        bw.write("#Brewing-Stand-Upgrade: 'Speed-Level'#" + LINE_SEPARATOR);
        bw.write(enchantBrewingStandSpeedLevelRegistry.getString());
        bw.write(enchantBrewingStandSpeedMaxLevel.getString());
        bw.write("#How effective a 'Speed-Level' is in percent#");
        bw.write(enchantBrewingStandSpeedLevelPercent.getString());
        bw.write(LINE_SEPARATOR);
        bw.close();
        fw.close();
    }

    public static void readConfigSwitchBow(List<String[]> readData) {
        for (String[] data : readData) {
            if (!enchantHeatHoldRegistry.checkandreplaceData(data) && !enchantFurnaceSpeedLevelRegistry.checkandreplaceData(data) && !enchantFurnaceSpeedMaxLevel.checkandreplaceData(data) && !enchantFurnaceSpeedLevelPercent.checkandreplaceData(data) && !enchantBrewingStandSpeedLevelRegistry.checkandreplaceData(data) && !enchantBrewingStandSpeedMaxLevel.checkandreplaceData(data) && !enchantBrewingStandSpeedLevelPercent.checkandreplaceData(data)) continue;
        }
    }

    public static File getPath() {
        return ConfigPathCraftingConfig;
    }
}

