/*
 * Decompiled with CFR 0.152.
 */
package de.whitedraco.portablecraft.gui.inventory;

import de.whitedraco.portablecraft.WorldSavedInventorys;
import de.whitedraco.portablecraft.config.EnchantmentConfig;
import de.whitedraco.portablecraft.gui.ContainerBrewingStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.ForgeEventFactory;

public class InventoryItemPatternBrewingStand
implements IInventory {
    private String name = "Item BrewingStand";
    private static final int[] SLOTS_FOR_UP = new int[]{3};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0, 1, 2, 3};
    private static final int[] OUTPUT_SLOTS = new int[]{0, 1, 2, 4};
    private NonNullList<ItemStack> brewingItemStacks = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private int brewTime;
    private boolean[] filledSlots;
    private Item ingredientID;
    private int fuel;
    private int inventoryNr;
    private int increaseSpeed = 1;
    private double rest = 0.0;

    public InventoryItemPatternBrewingStand(NBTTagCompound tag) {
        this.readFromNBT(tag);
    }

    public InventoryItemPatternBrewingStand() {
    }

    public int getIncreaseSpeed() {
        return this.increaseSpeed;
    }

    public void setIncreaseSpeed(int increaseSpeed) {
        this.increaseSpeed = increaseSpeed;
        this.func_70296_d();
    }

    public int getInventoryNr() {
        return this.inventoryNr;
    }

    public void setInventoryNr(int inventoryNr) {
        this.inventoryNr = inventoryNr;
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return this.name.length() > 0;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70302_i_() {
        return this.brewingItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.brewingItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.brewingItemStacks.size() ? (ItemStack)this.brewingItemStacks.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.brewingItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.brewingItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index >= 0 && index < this.brewingItemStacks.size()) {
            this.brewingItemStacks.set(index, (Object)stack);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        WorldSavedInventorys.getInstance().func_76185_a();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 3) {
            return BrewingRecipeRegistry.isValidIngredient((ItemStack)stack);
        }
        Item item = stack.func_77973_b();
        if (index == 4) {
            return item == Items.field_151065_br;
        }
        return BrewingRecipeRegistry.isValidInput((ItemStack)stack) && this.func_70301_a(index).func_190926_b();
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.brewTime;
            }
            case 1: {
                return this.fuel;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.brewTime = value;
                break;
            }
            case 1: {
                this.fuel = value;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public void func_174888_l() {
        this.brewingItemStacks.clear();
    }

    public double getrest() {
        return this.rest;
    }

    public void setrest(double newrest) {
        this.rest = newrest;
        this.func_70296_d();
    }

    public void update() {
        double x = (double)(this.increaseSpeed * EnchantmentConfig.enchantBrewingStandSpeedLevelPercent.getData()) * 1.0 / 100.0;
        int durchgang = (int)Math.floor(1.0 + x + this.rest);
        this.setrest(1.0 + x + this.rest - (double)durchgang);
        for (int a = 0; a < durchgang; ++a) {
            ItemStack itemstack = (ItemStack)this.brewingItemStacks.get(4);
            if (this.fuel <= 0 && itemstack.func_77973_b() == Items.field_151065_br) {
                this.fuel = 20;
                itemstack.func_190918_g(1);
                this.func_70296_d();
            }
            boolean flag = this.canBrew();
            boolean flag1 = this.brewTime > 0;
            ItemStack itemstack1 = (ItemStack)this.brewingItemStacks.get(3);
            if (flag1) {
                boolean flag2;
                --this.brewTime;
                boolean bl = flag2 = this.brewTime == 0;
                if (flag2 && flag) {
                    this.brewPotions();
                    this.func_70296_d();
                    continue;
                }
                if (!flag) {
                    this.brewTime = 0;
                    this.func_70296_d();
                    continue;
                }
                if (this.ingredientID == itemstack1.func_77973_b()) continue;
                this.brewTime = 0;
                this.func_70296_d();
                continue;
            }
            if (!flag || this.fuel <= 0) continue;
            --this.fuel;
            this.brewTime = 400;
            this.ingredientID = itemstack1.func_77973_b();
            this.func_70296_d();
        }
    }

    public boolean[] createFilledSlotsArray() {
        boolean[] aboolean = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.brewingItemStacks.get(i)).func_190926_b()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    private boolean canBrew() {
        return BrewingRecipeRegistry.canBrew(this.brewingItemStacks, (ItemStack)((ItemStack)this.brewingItemStacks.get(3)), (int[])OUTPUT_SLOTS);
    }

    private void brewPotions() {
        if (ForgeEventFactory.onPotionAttemptBrew(this.brewingItemStacks)) {
            return;
        }
        ItemStack itemstack = (ItemStack)this.brewingItemStacks.get(3);
        BrewingRecipeRegistry.brewPotions(this.brewingItemStacks, (ItemStack)((ItemStack)this.brewingItemStacks.get(3)), (int[])OUTPUT_SLOTS);
        itemstack.func_190918_g(1);
        if (itemstack.func_77973_b().hasContainerItem(itemstack)) {
            ItemStack itemstack1 = itemstack.func_77973_b().getContainerItem(itemstack);
            if (itemstack.func_190926_b()) {
                itemstack = itemstack1;
            }
        }
        this.brewingItemStacks.set(3, (Object)itemstack);
        ForgeEventFactory.onPotionBrewed(this.brewingItemStacks);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.brewingItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.brewingItemStacks);
        this.brewTime = compound.func_74765_d("BrewTime");
        this.inventoryNr = compound.func_74762_e("InventoryNr");
        this.fuel = compound.func_74771_c("Fuel");
        this.increaseSpeed = compound.func_74762_e("increaseSpeed");
        this.rest = compound.func_74769_h("rest");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74777_a("BrewTime", (short)this.brewTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.brewingItemStacks);
        compound.func_74768_a("InventoryNr", this.inventoryNr);
        compound.func_74774_a("Fuel", (byte)this.fuel);
        compound.func_74768_a("increaseSpeed", this.increaseSpeed);
        compound.func_74780_a("rest", this.rest);
        return compound;
    }

    public Container createContainer(InventoryPlayer playerInventory) {
        return new ContainerBrewingStand(playerInventory, this);
    }

    public void readToNBTClient(NBTTagCompound nbt) {
        this.brewTime = nbt.func_74765_d("BrewTime");
        this.inventoryNr = nbt.func_74762_e("InventoryNr");
        this.fuel = nbt.func_74771_c("Fuel");
        this.increaseSpeed = nbt.func_74762_e("increaseSpeed");
        this.rest = nbt.func_74769_h("rest");
    }

    public void writeToNBTClient(NBTTagCompound nbt) {
        nbt.func_74777_a("BrewTime", (short)this.brewTime);
        nbt.func_74768_a("InventoryNr", this.inventoryNr);
        nbt.func_74774_a("Fuel", (byte)this.fuel);
        nbt.func_74768_a("increaseSpeed", this.increaseSpeed);
        nbt.func_74780_a("rest", this.rest);
    }
}

