/*
 * Decompiled with CFR 0.152.
 */
package de.whitedraco.portablecraft.gui.inventory;

import de.whitedraco.portablecraft.WorldSavedInventorys;
import de.whitedraco.portablecraft.config.EnchantmentConfig;
import de.whitedraco.portablecraft.gui.ContainerFurnace;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InventoryItemPatternFurnace
implements IInventory {
    private String name = "Item Furnace";
    private int slotsCount = 3;
    public NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)this.slotsCount, (Object)ItemStack.field_190927_a);
    private List<IInventoryChangedListener> changeListeners;
    public int furnaceBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;
    private int inventoryNr;
    private boolean holdheat = false;
    private int increaseSpeed = 0;
    private double rest = 0.0;

    public double getrest() {
        return this.rest;
    }

    public void setrest(double newrest) {
        this.rest = newrest;
        this.func_70296_d();
    }

    public int getIncreaseSpeed() {
        return this.increaseSpeed;
    }

    public void setIncreaseSpeed(int increaseSpeed) {
        this.increaseSpeed = increaseSpeed;
        this.func_70296_d();
    }

    public int getInventoryNr() {
        return this.inventoryNr;
    }

    public void setInventoryNr(int inventoryNr) {
        this.inventoryNr = inventoryNr;
        this.func_70296_d();
    }

    public boolean isholdheat() {
        return this.holdheat;
    }

    public void setholdheat(boolean holdheat) {
        this.holdheat = holdheat;
        this.func_70296_d();
    }

    public InventoryItemPatternFurnace(NBTTagCompound tag) {
        this.readFromNBT(tag);
    }

    public InventoryItemPatternFurnace() {
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return this.name.length() > 0;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70302_i_() {
        return this.slotsCount;
    }

    public boolean func_191420_l() {
        return false;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.furnaceItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.furnaceItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.furnaceItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.furnaceItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.totalCookTime = this.getCookTime(stack);
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        if (this.changeListeners != null) {
            for (int i = 0; i < this.changeListeners.size(); ++i) {
                this.changeListeners.get(i).func_76316_a((IInventory)this);
            }
            WorldSavedInventorys.getInstance().func_76185_a();
        }
        WorldSavedInventorys.getInstance().func_76185_a();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_174888_l() {
        this.furnaceItemStacks.clear();
    }

    public void writeToNBTClient(NBTTagCompound tagcompound) {
        tagcompound.func_74768_a("BurnTime", (int)((short)this.furnaceBurnTime));
        tagcompound.func_74768_a("CookTime", (int)((short)this.cookTime));
        tagcompound.func_74768_a("CookTimeTotal", (int)((short)this.totalCookTime));
        tagcompound.func_74768_a("InventoryNr", this.inventoryNr);
        tagcompound.func_74757_a("holdheat", this.holdheat);
        tagcompound.func_74768_a("increaseSpeed", this.increaseSpeed);
        tagcompound.func_74780_a("rest", this.rest);
    }

    public void readToNBTClient(NBTTagCompound tagcompound) {
        this.furnaceBurnTime = tagcompound.func_74762_e("BurnTime");
        this.cookTime = tagcompound.func_74762_e("CookTime");
        this.totalCookTime = tagcompound.func_74762_e("CookTimeTotal");
        this.currentItemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)((ItemStack)this.furnaceItemStacks.get(1)));
        this.inventoryNr = tagcompound.func_74762_e("InventoryNr");
        this.holdheat = tagcompound.func_74767_n("holdheat");
        this.increaseSpeed = tagcompound.func_74762_e("increaseSpeed");
        this.rest = tagcompound.func_74769_h("rest");
    }

    public void writeToNBT(NBTTagCompound tagcompound) {
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == ItemStack.field_190927_a) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74768_a("Slot", i);
            this.func_70301_a(i).func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        tagcompound.func_74782_a("ItemInventory", (NBTBase)items);
        tagcompound.func_74768_a("BurnTime", (int)((short)this.furnaceBurnTime));
        tagcompound.func_74768_a("CookTime", (int)((short)this.cookTime));
        tagcompound.func_74768_a("CookTimeTotal", (int)((short)this.totalCookTime));
        tagcompound.func_74768_a("InventoryNr", this.inventoryNr);
        tagcompound.func_74757_a("holdheat", this.holdheat);
        tagcompound.func_74768_a("increaseSpeed", this.increaseSpeed);
        tagcompound.func_74780_a("rest", this.rest);
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList items = nbtTagCompound.func_150295_c("ItemInventory", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.furnaceItemStacks.set((int)slot, (Object)new ItemStack(item));
        }
        this.furnaceBurnTime = nbtTagCompound.func_74762_e("BurnTime");
        this.cookTime = nbtTagCompound.func_74762_e("CookTime");
        this.totalCookTime = nbtTagCompound.func_74762_e("CookTimeTotal");
        this.currentItemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)((ItemStack)this.furnaceItemStacks.get(1)));
        this.inventoryNr = nbtTagCompound.func_74762_e("InventoryNr");
        this.holdheat = nbtTagCompound.func_74767_n("holdheat");
        this.increaseSpeed = nbtTagCompound.func_74762_e("increaseSpeed");
        this.rest = nbtTagCompound.func_74769_h("rest");
    }

    public Container createContainer(InventoryPlayer playerInventory) {
        return new ContainerFurnace(playerInventory, this);
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public int getCookTime(ItemStack stack) {
        return 200;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public boolean canSmelt() {
        if (((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.furnaceItemStacks.get(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.furnaceItemStacks.get(2);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d()) {
            return true;
        }
        return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(0);
            ItemStack itemstack1 = FurnaceRecipes.func_77602_a().func_151395_a(itemstack);
            ItemStack itemstack2 = (ItemStack)this.furnaceItemStacks.get(2);
            if (itemstack2.func_190926_b()) {
                this.furnaceItemStacks.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && itemstack.func_77960_j() == 1 && !((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b() && ((ItemStack)this.furnaceItemStacks.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.furnaceItemStacks.set(1, (Object)new ItemStack(Items.field_151131_as));
            }
            itemstack.func_190918_g(1);
        }
    }

    public void update() {
        double x = (double)(this.increaseSpeed * EnchantmentConfig.enchantFurnaceSpeedLevelPercent.getData()) * 1.0 / 100.0;
        int durchgang = (int)Math.floor(1.0 + x + this.rest);
        this.setrest(1.0 + x + this.rest - (double)durchgang);
        for (int a = 0; a < durchgang; ++a) {
            boolean flag = this.isBurning();
            boolean flag1 = false;
            if (this.isBurning()) {
                if (this.holdheat) {
                    if (this.cookTime > 0) {
                        --this.furnaceBurnTime;
                    }
                } else {
                    --this.furnaceBurnTime;
                }
            }
            ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(1);
            if (this.isBurning() || !itemstack.func_190926_b() && !((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b()) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)itemstack);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!itemstack.func_190926_b()) {
                            Item item = itemstack.func_77973_b();
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                ItemStack item1 = item.getContainerItem(itemstack);
                                this.furnaceItemStacks.set(1, (Object)item1);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime((ItemStack)this.furnaceItemStacks.get(0));
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
            }
            if (!flag1) continue;
            this.func_70296_d();
        }
    }
}

