/*
 * Decompiled with CFR 0.152.
 */
package de.whitedraco.portablecraft.item.pattern;

import de.whitedraco.portablecraft.WorldSavedInventorys;
import de.whitedraco.portablecraft.help.SpawnDataPlayer;
import de.whitedraco.portablecraft.item.pattern.ItemPattern;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ItemPatternBed
extends ItemPattern {
    private static final String TAG_WILL_SLEEP = "TAG_WILL_SLEEP";
    private static final String TAG_IN_BED = "TAG_IN_BED";
    private static final String TAG_BED_LOCATE = "TAG_BED_LOCATE";

    public ItemPatternBed(String name) {
        super(name);
        this.field_77777_bU = 1;
    }

    @Override
    public void openGUI(EntityPlayer playerIn, ItemStack pattern) {
        if (!playerIn.func_130014_f_().field_72995_K && this.canSleep(playerIn, playerIn.func_130014_f_())) {
            long bedLocation = 0L;
            if (playerIn.func_180470_cg() != null) {
                bedLocation = playerIn.func_180470_cg().func_177986_g();
            }
            if (WorldSavedInventorys.getInstance() != null) {
                WorldSavedInventorys.getInstance().setSleepingPlayer(new SpawnDataPlayer(playerIn, bedLocation));
            }
        }
    }

    private boolean canSleep(EntityPlayer player, World worldIn) {
        if (player.func_70608_bn() || !player.func_70089_S()) {
            return false;
        }
        BlockPos pos = player.func_180425_c();
        EntityPlayer.SleepResult status = this.canSleep(player, worldIn, pos);
        if (!this.isGround(worldIn, pos.func_177977_b())) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("potioncraft.portablebed.isGround", new Object[0]), true);
            return false;
        }
        if (status == EntityPlayer.SleepResult.OK) {
            return true;
        }
        if (status == EntityPlayer.SleepResult.NOT_POSSIBLE_NOW) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.noSleep", new Object[0]), true);
        } else if (status == EntityPlayer.SleepResult.NOT_SAFE) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.notSafe", new Object[0]), true);
        }
        return false;
    }

    private boolean isGround(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        AxisAlignedBB box = state.func_185890_d((IBlockAccess)worldIn, pos);
        if (box == null) {
            return false;
        }
        double dx = box.field_72336_d - box.field_72340_a;
        double dy = box.field_72337_e - box.field_72338_b;
        double dz = box.field_72334_f - box.field_72339_c;
        return dx >= 0.5 && dy >= 0.5 && dz >= 0.5;
    }

    private EntityPlayer.SleepResult canSleep(EntityPlayer player, World worldIn, BlockPos pos) {
        PlayerSleepInBedEvent event = new PlayerSleepInBedEvent(player, pos);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResultStatus() != null) {
            return event.getResultStatus();
        }
        if (!worldIn.field_73011_w.func_76569_d()) {
            return EntityPlayer.SleepResult.NOT_POSSIBLE_HERE;
        }
        if (worldIn.func_72935_r()) {
            return EntityPlayer.SleepResult.NOT_POSSIBLE_NOW;
        }
        Vec3i vec = new Vec3i(8, 5, 8);
        List mobs = worldIn.func_72872_a(EntityMob.class, new AxisAlignedBB(pos.func_177973_b(vec), pos.func_177971_a(vec)));
        if (!mobs.isEmpty()) {
            return EntityPlayer.SleepResult.NOT_SAFE;
        }
        return EntityPlayer.SleepResult.OK;
    }
}

