/*
 * Decompiled with CFR 0.152.
 */
package mca.api;

import com.google.common.base.Charsets;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mca.api.types.APIButton;
import mca.api.types.Gift;
import mca.api.types.SkinsGroup;
import mca.client.gui.component.GuiButtonEx;
import mca.core.MCA;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumConstraint;
import mca.enums.EnumGender;
import mca.util.Util;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.apache.commons.io.IOUtils;

public class API {
    private static Map<String, Gift> giftMap = new HashMap<String, Gift>();
    private static Map<String, APIButton[]> buttonMap = new HashMap<String, APIButton[]>();
    private static List<String> maleNames = new ArrayList<String>();
    private static List<String> femaleNames = new ArrayList<String>();
    private static List<SkinsGroup> skinGroups = new ArrayList<SkinsGroup>();
    private static Random rng;

    public static void init() {
        Gift[] gifts;
        rng = new Random();
        SkinsGroup[] skins = Util.readResourceAsJSON("api/skins.json", SkinsGroup[].class);
        Collections.addAll(skinGroups, skins);
        InputStream namesStream = StringUtils.class.getResourceAsStream("/assets/mca/lang/names.lang");
        try {
            List lines = IOUtils.readLines((InputStream)namesStream, (Charset)Charsets.UTF_8);
            lines.stream().filter(l -> l.contains("name.male")).forEach(l -> maleNames.add(l.split("\\=")[1]));
            lines.stream().filter(l -> l.contains("name.female")).forEach(l -> femaleNames.add(l.split("\\=")[1]));
        }
        catch (Exception e) {
            MCA.getLog().fatal((Object)e);
            throw new RuntimeException("Failed to load all NPC names from file", e);
        }
        buttonMap.put("main", Util.readResourceAsJSON("api/gui/main.json", APIButton[].class));
        buttonMap.put("interact", Util.readResourceAsJSON("api/gui/interact.json", APIButton[].class));
        buttonMap.put("debug", Util.readResourceAsJSON("api/gui/debug.json", APIButton[].class));
        buttonMap.put("editor", Util.readResourceAsJSON("api/gui/editor.json", APIButton[].class));
        buttonMap.put("work", Util.readResourceAsJSON("api/gui/work.json", APIButton[].class));
        for (Gift gift : gifts = Util.readResourceAsJSON("api/gifts.json", Gift[].class)) {
            if (!gift.exists()) {
                MCA.getLog().warn("Could not find gift item or block in registry: " + gift.getName());
                continue;
            }
            giftMap.put(gift.getName(), gift);
        }
    }

    public static String getRandomSkin(EntityVillagerMCA villager) {
        VillagerRegistry.VillagerProfession profession = villager.getProfessionForge();
        EnumGender gender = EnumGender.byId(villager.get(EntityVillagerMCA.GENDER));
        String name = villager.get(EntityVillagerMCA.VILLAGER_NAME);
        if (gender == EnumGender.MALE) {
            switch (name.toLowerCase()) {
                case "pewdiepie": {
                    return "mca:skins/male/special/pewdiepie_boy.png";
                }
                case "sven": {
                    return "mca:skins/male/special/sven.png";
                }
                case "noob": 
                case "noober": 
                case "neeber": {
                    return "mca:skins/male/special/noob.png";
                }
                case "shepard": {
                    return "mca:skins/male/special/shepard.png";
                }
                case "minsc": {
                    return "mca:skins/male/special/minsc.png";
                }
            }
        } else if (gender == EnumGender.FEMALE) {
            switch (name.toLowerCase()) {
                case "pewdiepie": {
                    return "mca:skins/female/special/pewdiepie_girl.png";
                }
            }
        }
        Optional<SkinsGroup> group = skinGroups.stream().filter(g -> g.getGender() == gender && profession.getRegistryName() != null && g.getProfession().equals(profession.getRegistryName().toString())).findFirst();
        return group.map(g -> g.getPaths()[rng.nextInt(g.getPaths().length - 1)]).orElseGet(() -> {
            MCA.getLog().warn("No skin found for profession: `" + profession.getRegistryName() + "`. A random skin will be generated.");
            SkinsGroup randomGroup = null;
            while (randomGroup == null || randomGroup.getGender() != gender) {
                randomGroup = skinGroups.get(rng.nextInt(skinGroups.size() - 1));
            }
            return randomGroup.getPaths()[rng.nextInt(randomGroup.getPaths().length)];
        });
    }

    public static Optional<APIButton> getButtonById(String key, String id) {
        return Arrays.stream((Object[])buttonMap.get(key)).filter(b -> b.getIdentifier().equals(id)).findFirst();
    }

    public static int getGiftValueFromStack(ItemStack stack) {
        if (stack.func_77973_b().getRegistryName() == null) {
            return 0;
        }
        String name = stack.func_77973_b().getRegistryName().toString();
        return giftMap.containsKey(name) ? giftMap.get(name).getValue() : -5;
    }

    public static String getResponseForGift(ItemStack stack) {
        int value = API.getGiftValueFromStack(stack);
        return "gift." + (value <= 0 ? "fail" : (value <= 5 ? "good" : (value <= 10 ? "better" : "best")));
    }

    public static String getRandomName(@Nonnull EnumGender gender) {
        if (gender == EnumGender.MALE) {
            return maleNames.get(rng.nextInt(maleNames.size()));
        }
        if (gender == EnumGender.FEMALE) {
            return femaleNames.get(rng.nextInt(femaleNames.size()));
        }
        return "";
    }

    public static void addButtons(String guiKey, @Nullable EntityVillagerMCA villager, EntityPlayer player, GuiScreen screen) {
        List buttonList = (List)ObfuscationReflectionHelper.getPrivateValue(GuiScreen.class, (Object)screen, (int)7);
        for (APIButton b : buttonMap.get(guiKey)) {
            GuiButtonEx guiButton = new GuiButtonEx(screen, b);
            buttonList.add(guiButton);
            if (villager == null && b.getConstraints().size() > 0) {
                MCA.getLog().error("No villager provided for list of buttons with constraints! Button ID:" + b.getIdentifier());
                continue;
            }
            boolean isValid = b.isValidForConstraint(villager, player);
            if (!isValid && b.getConstraints().contains((Object)EnumConstraint.HIDE_ON_FAIL)) {
                buttonList.remove((Object)guiButton);
                continue;
            }
            if (isValid) continue;
            guiButton.field_146124_l = false;
        }
    }

    public static Optional<GuiButtonEx> getButton(String id, GuiScreen screen) {
        List buttonList = (List)ObfuscationReflectionHelper.getPrivateValue(GuiScreen.class, (Object)screen, (int)7);
        Optional<GuiButton> button = buttonList.stream().filter(b -> b instanceof GuiButtonEx && ((GuiButtonEx)((Object)b)).getApiButton().getIdentifier().equals(id)).findFirst();
        return button.map(guiButton -> (GuiButtonEx)((Object)guiButton));
    }
}

