/*
 * Decompiled with CFR 0.152.
 */
package mca.api.types;

import java.beans.ConstructorProperties;
import java.util.List;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumConstraint;
import net.minecraft.entity.player.EntityPlayer;

public class APIButton {
    private int id;
    private String identifier;
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean notifyServer;
    private boolean targetServer;
    private String constraints;
    private boolean isInteraction;

    public List<EnumConstraint> getConstraints() {
        return EnumConstraint.fromStringList(this.constraints);
    }

    public boolean isValidForConstraint(EntityVillagerMCA villager, EntityPlayer player) {
        List<EnumConstraint> constraints = this.getConstraints();
        if (constraints.contains((Object)EnumConstraint.ADULTS) && !villager.func_70631_g_()) {
            return true;
        }
        if (constraints.contains((Object)EnumConstraint.SPOUSE) && villager.isMarriedTo(player.func_110124_au())) {
            return true;
        }
        if (constraints.contains((Object)EnumConstraint.NOT_SPOUSE) && !villager.isMarriedTo(player.func_110124_au())) {
            return true;
        }
        if (constraints.contains((Object)EnumConstraint.FAMILY) && (villager.playerIsParent(player) || villager.isMarriedTo(player.func_110124_au()))) {
            return true;
        }
        if (constraints.contains((Object)EnumConstraint.NOT_FAMILY) && !villager.playerIsParent(player) && !villager.isMarriedTo(player.func_110124_au())) {
            return true;
        }
        return constraints.isEmpty();
    }

    @ConstructorProperties(value={"id", "identifier", "x", "y", "width", "height", "notifyServer", "targetServer", "constraints", "isInteraction"})
    public APIButton(int id, String identifier, int x, int y, int width, int height, boolean notifyServer, boolean targetServer, String constraints, boolean isInteraction) {
        this.id = id;
        this.identifier = identifier;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.notifyServer = notifyServer;
        this.targetServer = targetServer;
        this.constraints = constraints;
        this.isInteraction = isInteraction;
    }

    public int getId() {
        return this.id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isNotifyServer() {
        return this.notifyServer;
    }

    public boolean isTargetServer() {
        return this.targetServer;
    }

    public boolean isInteraction() {
        return this.isInteraction;
    }
}

