/*
 * Decompiled with CFR 0.152.
 */
package mca.client.gui;

import java.io.IOException;
import java.util.Optional;
import mca.api.API;
import mca.client.gui.component.GuiButtonEx;
import mca.core.Constants;
import mca.core.MCA;
import mca.core.forge.NetMCA;
import mca.entity.EntityVillagerMCA;
import mca.entity.data.ParentData;
import mca.entity.data.PlayerHistory;
import mca.enums.EnumMarriageState;
import mca.enums.EnumMoveState;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiInteract
extends GuiScreen {
    private static final ResourceLocation ICON_TEXTURES = new ResourceLocation("mca:textures/gui.png");
    private static boolean displaySuccessChance;
    private final EntityVillagerMCA villager;
    private final EntityPlayer player;
    private boolean inGiftMode;
    private int timeSinceLastClick;
    private int marriedIconU = 0;
    private int engagedIconU = 64;
    private int notMarriedIconU = 16;
    private int parentsIconU = 32;
    private int giftIconU = 48;
    private int redHeartIconU = 80;
    private int blackHeartIconU = 96;
    private int goldHeartIconU = 112;
    private int mouseX;
    private int mouseY;
    private String activeKey;

    public GuiInteract(EntityVillagerMCA villager, EntityPlayer player) {
        this.villager = villager;
        this.player = player;
        this.activeKey = "main";
    }

    public void func_73866_w_() {
        this.drawMainButtonMenu();
    }

    public void func_146281_b() {
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        if (this.timeSinceLastClick < 100) {
            ++this.timeSinceLastClick;
        }
    }

    public void func_73863_a(int i, int j, float f) {
        super.func_73863_a(i, j, f);
        this.drawIcons();
        this.drawTextPopups();
        this.mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        this.mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (Mouse.getEventDWheel() < 0) {
            this.player.field_71071_by.field_70461_c = this.player.field_71071_by.field_70461_c == 8 ? 0 : this.player.field_71071_by.field_70461_c + 1;
        } else if (Mouse.getEventDWheel() > 0) {
            this.player.field_71071_by.field_70461_c = this.player.field_71071_by.field_70461_c == 0 ? 8 : this.player.field_71071_by.field_70461_c - 1;
        }
    }

    protected void func_73864_a(int posX, int posY, int button) throws IOException {
        super.func_73864_a(posX, posY, button);
        if (this.inGiftMode && button == 1) {
            NetMCA.INSTANCE.sendToServer((IMessage)new NetMCA.ButtonAction(this.activeKey, "gui.button.gift", this.villager.func_110124_au()));
        }
    }

    protected void func_73869_a(char keyChar, int keyCode) {
        if (keyCode == 1) {
            if (this.inGiftMode) {
                this.inGiftMode = false;
                this.enableAllButtons();
            } else {
                this.field_146297_k.func_147108_a(null);
            }
        } else if (keyCode == 29) {
            displaySuccessChance = !displaySuccessChance;
        } else {
            try {
                int intInput = Integer.parseInt(String.valueOf(keyChar));
                if (intInput > 0) {
                    this.player.field_71071_by.field_70461_c = intInput - 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void drawIcons() {
        int marriageIconU;
        PlayerHistory history = this.villager.getPlayerHistoryFor(this.player.func_110124_au());
        EnumMarriageState marriageState = EnumMarriageState.byId(this.villager.get(EntityVillagerMCA.MARRIAGE_STATE));
        int n = marriageState == EnumMarriageState.MARRIED ? this.marriedIconU : (marriageIconU = marriageState == EnumMarriageState.ENGAGED ? this.engagedIconU : this.notMarriedIconU);
        int heartIconU = history.getHearts() < 0 ? this.blackHeartIconU : (history.getHearts() >= 100 ? this.goldHeartIconU : this.redHeartIconU);
        GL11.glPushMatrix();
        GL11.glColor3f((float)255.0f, (float)255.0f, (float)255.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        this.field_146297_k.func_110434_K().func_110577_a(ICON_TEXTURES);
        this.func_73729_b(5, 15, heartIconU, 0, 16, 16);
        this.func_73729_b(5, 30, marriageIconU, 0, 16, 16);
        if (this.canDrawParentsIcon()) {
            this.func_73729_b(5, 45, this.parentsIconU, 0, 16, 16);
        }
        if (this.canDrawGiftIcon()) {
            this.func_73729_b(5, 60, this.giftIconU, 0, 16, 16);
        }
        GL11.glPopMatrix();
    }

    private void drawTextPopups() {
        EnumMarriageState marriageState = EnumMarriageState.byId(this.villager.get(EntityVillagerMCA.MARRIAGE_STATE));
        if (this.hoveringOverHeartsIcon()) {
            int hearts = this.villager.getPlayerHistoryFor(this.player.func_110124_au()).getHearts();
            this.func_146279_a(hearts + " hearts", 35, 55);
        }
        if (this.hoveringOverMarriageIcon()) {
            String spouseName = this.villager.get(EntityVillagerMCA.SPOUSE_NAME);
            String marriageInfo = marriageState == EnumMarriageState.MARRIED ? MCA.getLocalizer().localize("gui.interact.label.married", spouseName) : (marriageState == EnumMarriageState.ENGAGED ? MCA.getLocalizer().localize("gui.interact.label.engaged", spouseName) : MCA.getLocalizer().localize("gui.interact.label.notmarried", new String[0]));
            this.func_146279_a(marriageInfo, 35, 85);
        }
        if (this.canDrawParentsIcon() && this.hoveringOverParentsIcon()) {
            ParentData data = ParentData.fromNBT(this.villager.get(EntityVillagerMCA.PARENTS));
            this.func_146279_a(MCA.getLocalizer().localize("gui.interact.label.parents", data.getParent1Name(), data.getParent2Name()), 35, 115);
        }
        if (this.canDrawGiftIcon() && this.hoveringOverGiftIcon()) {
            this.func_146279_a(MCA.getLocalizer().localize("gui.interact.label.gift", new String[0]), 35, 145);
        }
    }

    private boolean hoveringOverHeartsIcon() {
        return this.mouseX <= 32 && this.mouseX >= 16 && this.mouseY >= 32 && this.mouseY <= 48;
    }

    private boolean hoveringOverMarriageIcon() {
        return this.mouseX <= 32 && this.mouseX >= 16 && this.mouseY >= 66 && this.mouseY <= 81;
    }

    private boolean hoveringOverParentsIcon() {
        return this.mouseX <= 32 && this.mouseX >= 16 && this.mouseY >= 100 && this.mouseY <= 115;
    }

    private boolean hoveringOverGiftIcon() {
        return this.mouseX <= 32 && this.mouseX >= 16 && this.mouseY >= 124 && this.mouseY <= 148;
    }

    private boolean canDrawParentsIcon() {
        ParentData data = ParentData.fromNBT(this.villager.get(EntityVillagerMCA.PARENTS));
        return !data.getParent1UUID().equals(Constants.ZERO_UUID) && !data.getParent2UUID().equals(Constants.ZERO_UUID);
    }

    private boolean canDrawGiftIcon() {
        return this.villager.getPlayerHistoryFor(this.player.func_110124_au()).isGiftPresent();
    }

    protected void func_146284_a(GuiButton button) {
        GuiButtonEx btn = (GuiButtonEx)button;
        String id = btn.getApiButton().getIdentifier();
        if (this.timeSinceLastClick <= 2) {
            return;
        }
        this.timeSinceLastClick = 0;
        if (id.equals("gui.button.interact")) {
            this.activeKey = "interact";
            this.drawInteractButtonMenu();
            return;
        }
        if (id.equals("gui.button.work")) {
            this.activeKey = "work";
            this.drawWorkButtonMenu();
            return;
        }
        if (id.equals("gui.button.backarrow")) {
            this.drawMainButtonMenu();
            this.activeKey = "main";
            return;
        }
        if (btn.getApiButton().isNotifyServer()) {
            NetMCA.INSTANCE.sendToServer((IMessage)new NetMCA.ButtonAction(this.activeKey, id, this.villager.func_110124_au()));
        } else if (id.equals("gui.button.gift")) {
            this.inGiftMode = true;
            this.disableAllButtons();
            return;
        }
        this.field_146297_k.func_147108_a(null);
    }

    private void drawMainButtonMenu() {
        this.field_146292_n.clear();
        API.addButtons("main", this.villager, this.player, this);
        EnumMoveState moveState = EnumMoveState.byId(this.villager.get(EntityVillagerMCA.MOVE_STATE));
        if (moveState == EnumMoveState.FOLLOW) {
            this.disableButton("gui.button.follow");
        } else if (moveState == EnumMoveState.STAY) {
            this.disableButton("gui.button.stay");
        } else if (moveState == EnumMoveState.MOVE) {
            this.disableButton("gui.button.move");
        }
    }

    private void drawInteractButtonMenu() {
        this.field_146292_n.clear();
        API.addButtons("interact", this.villager, this.player, this);
    }

    private void drawWorkButtonMenu() {
        this.field_146292_n.clear();
        API.addButtons("work", this.villager, this.player, this);
    }

    private void disableButton(String id) {
        Optional<GuiButtonEx> b = API.getButton(id, this);
        b.ifPresent(guiButtonEx -> {
            guiButtonEx.field_146124_l = false;
        });
    }

    private void enableAllButtons() {
        this.field_146292_n.forEach(b -> {
            b.field_146124_l = true;
        });
    }

    private void disableAllButtons() {
        this.field_146292_n.forEach(b -> {
            b.field_146124_l = false;
        });
    }
}

