/*
 * Decompiled with CFR 0.152.
 */
package mca.client.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import mca.api.API;
import mca.api.types.APIButton;
import mca.client.gui.component.GuiButtonEx;
import mca.core.MCA;
import mca.core.forge.NetMCA;
import mca.entity.EntityVillagerMCA;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiVillagerEditor
extends GuiScreen {
    private final EntityVillagerMCA villager;
    private final EntityPlayer player;
    private GuiTextField nameTextField;
    private GuiTextField professionTextField;
    private GuiTextField textureTextField;

    public GuiVillagerEditor(EntityVillagerMCA EntityHuman, EntityPlayer player) {
        this.player = player;
        this.villager = EntityHuman;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.nameTextField.func_146178_a();
        this.professionTextField.func_146178_a();
        this.textureTextField.func_146178_a();
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.drawEditorGui();
        this.nameTextField = new GuiTextField(1, this.field_146289_q, this.field_146294_l / 2 - 205, this.field_146295_m / 2 - 95, 150, 20);
        this.nameTextField.func_146203_f(32);
        this.nameTextField.func_146180_a(this.villager.get(EntityVillagerMCA.VILLAGER_NAME));
        this.professionTextField = new GuiTextField(2, this.field_146289_q, this.field_146294_l / 2 - 190, this.field_146295_m / 2 + 10, 250, 20);
        this.professionTextField.func_146203_f(64);
        this.professionTextField.func_146180_a(this.villager.getVanillaCareer().getName());
        this.textureTextField = new GuiTextField(3, this.field_146289_q, this.field_146294_l / 2 - 190, this.field_146295_m / 2 - 15, 250, 20);
        this.textureTextField.func_146203_f(128);
        this.textureTextField.func_146180_a(this.villager.get(EntityVillagerMCA.TEXTURE));
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton guiButton) {
        APIButton btn = ((GuiButtonEx)guiButton).getApiButton();
        if (btn.isNotifyServer()) {
            NetMCA.INSTANCE.sendToServer((IMessage)new NetMCA.ButtonAction("editor", btn.getIdentifier(), this.villager.func_110124_au()));
        } else if (btn.getIdentifier().equals("gui.button.done")) {
            this.field_146297_k.func_147108_a(null);
        } else if (btn.getIdentifier().equals("gui.button.copyuuid")) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.villager.func_110124_au().toString()), null);
            Minecraft.func_71410_x().field_71439_g.func_71165_d("Villager UUID copied to clipboard.");
        } else if (btn.getIdentifier().equals("gui.button.profession.set")) {
            String profession = this.professionTextField.func_146179_b();
            NetMCA.INSTANCE.sendToServer((IMessage)new NetMCA.SetProfession(this.villager.func_110124_au(), profession));
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    NetMCA.INSTANCE.sendToServer((IMessage)new NetMCA.CareerRequest(GuiVillagerEditor.this.villager.func_110124_au()));
                }
            }, 500L);
        } else if (btn.getIdentifier().contains("gui.button.texture")) {
            String texture = btn.getIdentifier().endsWith(".set") ? this.textureTextField.func_146179_b() : API.getRandomSkin(this.villager);
            NetMCA.INSTANCE.sendToServer((IMessage)new NetMCA.SetTexture(this.villager.func_110124_au(), texture));
            this.textureTextField.func_146180_a(texture);
        }
    }

    protected void func_73869_a(char c, int i) {
        if (i == 1) {
            Minecraft.func_71410_x().func_147108_a(null);
        } else {
            if (this.nameTextField.func_146201_a(c, i)) {
                String text = this.nameTextField.func_146179_b().trim();
                NetMCA.INSTANCE.sendToServer((IMessage)new NetMCA.SetName(text, this.villager.func_110124_au()));
            }
            this.textureTextField.func_146201_a(c, i);
            this.professionTextField.func_146201_a(c, i);
            this.drawEditorGui();
        }
    }

    protected void func_73864_a(int clickX, int clickY, int clicked) throws IOException {
        super.func_73864_a(clickX, clickY, clicked);
        this.nameTextField.func_146192_a(clickX, clickY, clicked);
        this.professionTextField.func_146192_a(clickX, clickY, clicked);
        this.textureTextField.func_146192_a(clickX, clickY, clicked);
    }

    public boolean func_73868_f() {
        return false;
    }

    private void drawEditorGui() {
        this.field_146292_n.clear();
        API.addButtons("editor", this.villager, this.player, this);
    }

    public void func_73863_a(int sizeX, int sizeY, float offset) {
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1072689136, -804253680);
        this.func_73731_b(this.field_146289_q, "Name:", this.field_146294_l / 2 - 205, this.field_146295_m / 2 - 110, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, MCA.getLocalizer().localize("gui.title.editor", new String[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 110, 0xFFFFFF);
        this.nameTextField.func_146194_f();
        this.professionTextField.func_146194_f();
        this.textureTextField.func_146194_f();
        super.func_73863_a(sizeX, sizeY, offset);
    }
}

