/*
 * Decompiled with CFR 0.152.
 */
package mca.client.gui;

import java.util.List;
import lombok.NonNull;
import mca.core.MCA;
import mca.core.forge.NetMCA;
import mca.entity.EntityVillagerMCA;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

@SideOnly(value=Side.CLIENT)
public class GuiWhistle
extends GuiScreen {
    private EntityVillagerMCA dummyHuman;
    private List<NBTTagCompound> villagerDataList;
    private GuiButton selectionLeftButton;
    private GuiButton selectionRightButton;
    private GuiButton villagerNameButton;
    private GuiButton callButton;
    private GuiButton exitButton;
    private int loadingAnimationTicks;
    private int selectedIndex;

    public void func_73876_c() {
        super.func_73876_c();
        if (this.loadingAnimationTicks != -1) {
            ++this.loadingAnimationTicks;
        }
        if (this.loadingAnimationTicks >= 20) {
            this.loadingAnimationTicks = 0;
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.selectionLeftButton = new GuiButton(1, this.field_146294_l / 2 - 123, this.field_146295_m / 2 + 65, 20, 20, "<<");
        this.field_146292_n.add(this.selectionLeftButton);
        this.selectionRightButton = new GuiButton(2, this.field_146294_l / 2 + 103, this.field_146295_m / 2 + 65, 20, 20, ">>");
        this.field_146292_n.add(this.selectionRightButton);
        this.villagerNameButton = new GuiButton(3, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 65, 200, 20, "");
        this.field_146292_n.add(this.villagerNameButton);
        this.callButton = new GuiButton(4, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 90, 60, 20, MCA.getLocalizer().localize("gui.button.call", new String[0]));
        this.field_146292_n.add(this.callButton);
        this.exitButton = new GuiButton(6, this.field_146294_l / 2 + 40, this.field_146295_m / 2 + 90, 60, 20, MCA.getLocalizer().localize("gui.button.exit", new String[0]));
        this.field_146292_n.add(this.exitButton);
        NetMCA.INSTANCE.sendToServer((IMessage)new NetMCA.GetFamily());
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton == this.exitButton) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
        if (this.villagerDataList != null && this.villagerDataList.size() > 0) {
            NBTTagCompound data = this.villagerDataList.get(this.selectedIndex - 1);
            if (guibutton == this.selectionLeftButton) {
                this.selectedIndex = this.selectedIndex == 1 ? this.villagerDataList.size() : --this.selectedIndex;
            } else if (guibutton == this.selectionRightButton) {
                this.selectedIndex = this.selectedIndex == this.villagerDataList.size() ? 1 : ++this.selectedIndex;
            } else if (guibutton == this.callButton) {
                NetMCA.INSTANCE.sendToServer((IMessage)new NetMCA.CallToPlayer(data.func_186857_a("uuid")));
                Minecraft.func_71410_x().func_147108_a(null);
            }
            this.villagerNameButton.field_146126_j = data.func_74779_i("name");
            this.updateDummyVillagerWithData(data);
        }
    }

    public void func_73863_a(int sizeX, int sizeY, float offset) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, MCA.getLocalizer().localize("gui.title.whistle", new String[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 110, 0xFFFFFF);
        if (this.loadingAnimationTicks != -1) {
            this.func_73731_b(this.field_146289_q, "Loading" + StringUtils.repeat((String)".", (int)(this.loadingAnimationTicks % 10)), this.field_146294_l / 2 - 20, this.field_146295_m / 2 - 10, 0xFFFFFF);
        } else if (this.villagerDataList.size() == 0) {
            this.func_73732_a(this.field_146289_q, "No family members could be found in the area.", this.field_146294_l / 2, this.field_146295_m / 2 + 50, 0xFFFFFF);
        } else {
            this.func_73732_a(this.field_146289_q, this.selectedIndex + " / " + this.villagerDataList.size(), this.field_146294_l / 2, this.field_146295_m / 2 + 50, 0xFFFFFF);
        }
        if (this.dummyHuman != null) {
            this.drawDummyVillager();
        }
        super.func_73863_a(sizeX, sizeY, offset);
    }

    private void drawDummyVillager() {
        int posX = this.field_146294_l / 2;
        int posY = this.field_146295_m / 2 + 45;
        GuiInventory.func_147046_a((int)posX, (int)posY, (int)75, (float)0.0f, (float)0.0f, (EntityLivingBase)this.dummyHuman);
    }

    public void setVillagerDataList(@NonNull List<NBTTagCompound> dataList) {
        if (dataList == null) {
            throw new NullPointerException("dataList");
        }
        this.villagerDataList = dataList;
        this.loadingAnimationTicks = -1;
        this.selectedIndex = 1;
        try {
            NBTTagCompound firstData = dataList.get(0);
            this.villagerNameButton.field_146126_j = firstData.func_74779_i("name");
            this.dummyHuman = new EntityVillagerMCA((World)Minecraft.func_71410_x().field_71441_e);
            this.updateDummyVillagerWithData(firstData);
        }
        catch (IndexOutOfBoundsException e) {
            this.callButton.field_146124_l = false;
        }
    }

    private void updateDummyVillagerWithData(NBTTagCompound nbt) {
        this.dummyHuman.set(EntityVillagerMCA.VILLAGER_NAME, nbt.func_74779_i("name"));
        this.dummyHuman.set(EntityVillagerMCA.TEXTURE, nbt.func_74779_i("texture"));
        this.dummyHuman.set(EntityVillagerMCA.GIRTH, Float.valueOf(nbt.func_74760_g("girth")));
        this.dummyHuman.set(EntityVillagerMCA.TALLNESS, Float.valueOf(nbt.func_74760_g("tallness")));
        this.dummyHuman.set(EntityVillagerMCA.IS_INFECTED, nbt.func_74767_n("infected"));
        this.dummyHuman.set(EntityVillagerMCA.AGE_STATE, nbt.func_74762_e("ageState"));
    }
}

