/*
 * Decompiled with CFR 0.152.
 */
package mca.client.network;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import mca.core.MCA;
import mca.core.forge.NetMCA;
import mca.entity.EntityVillagerMCA;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ClientMessageQueue {
    private static ConcurrentLinkedQueue<IMessage> scheduledMessages = new ConcurrentLinkedQueue();

    public static void processScheduledMessages() {
        IMessage next = scheduledMessages.poll();
        if (next != null) {
            ClientMessageQueue.handle(next);
        }
    }

    public static void add(IMessage msg) {
        scheduledMessages.add(msg);
    }

    private static void handle(IMessage msg) {
        if (msg instanceof NetMCA.CareerResponse) {
            ClientMessageQueue.handleCareerId((NetMCA.CareerResponse)msg);
        } else if (msg instanceof NetMCA.InventoryResponse) {
            ClientMessageQueue.handleInventory((NetMCA.InventoryResponse)msg);
        } else {
            MCA.getLog().error("Unexpected message in queue:" + msg.getClass().getName());
        }
    }

    private static void handleCareerId(NetMCA.CareerResponse msg) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        try {
            Optional<EntityVillagerMCA> villager = ClientMessageQueue.getVillagerByUUID(player.func_130014_f_(), msg.getEntityUUID());
            if (villager.isPresent()) {
                ObfuscationReflectionHelper.setPrivateValue(EntityVillager.class, (Object)((Object)villager.get()), (Object)msg.getCareerId(), (int)13);
            }
        }
        catch (ClassCastException e) {
            MCA.getLog().error("Failed to cast entity to villager on career ID update.");
        }
        catch (Exception e) {
            MCA.getLog().error("Failed to set career ID on villager!", (Throwable)e);
        }
    }

    private static void handleInventory(NetMCA.InventoryResponse msg) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            Optional<EntityVillagerMCA> villager = ClientMessageQueue.getVillagerByUUID(player.field_70170_p, msg.getEntityUUID());
            villager.ifPresent(entityVillagerMCA -> entityVillagerMCA.inventory.readInventoryFromNBT(msg.getInventoryNBT().func_150295_c("inventory", 10)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<EntityVillagerMCA> getVillagerByUUID(World world, UUID uuid) {
        try {
            List list = world.field_72996_f;
            synchronized (list) {
                return world.field_72996_f.stream().filter(e -> e.func_110124_au().equals(uuid)).map(EntityVillagerMCA.class::cast).findFirst();
            }
        }
        catch (ClassCastException ignored) {
            MCA.getLog().error("Failed to cast entity with UUID " + uuid.toString() + " to a villager!");
            return Optional.empty();
        }
    }
}

