/*
 * Decompiled with CFR 0.152.
 */
package mca.client.render;

import mca.client.model.ModelVillagerMCA;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumAgeState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderVillagerMCA<T extends EntityVillagerMCA>
extends RenderBiped<EntityVillagerMCA> {
    private static final ResourceLocation gui = new ResourceLocation("mca:textures/gui.png");
    private static final float LABEL_SCALE = 0.027f;

    public RenderVillagerMCA(RenderManager manager) {
        super(manager, (ModelBiped)new ModelVillagerMCA(), 0.5f);
        this.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
    }

    protected void preRenderCallback(EntityVillagerMCA villager, float partialTickTime) {
        if (villager.func_70631_g_()) {
            float scaleForAge = EnumAgeState.byId(villager.get(EntityVillagerMCA.AGE_STATE)).getScaleForAge();
            GlStateManager.func_179152_a((float)scaleForAge, (float)scaleForAge, (float)scaleForAge);
        }
        if (villager.func_184218_aH()) {
            GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
        }
    }

    public void renderName(EntityVillagerMCA entity, double x, double y, double z) {
        super.func_177067_a((EntityLivingBase)entity, x, y, z);
        if (this.canRenderName(entity)) {
            if (entity.func_110143_aJ() < entity.func_110138_aP()) {
                this.renderHealth(entity, x, y, z, (int)entity.func_110143_aJ(), (int)entity.func_110138_aP());
            }
            if (entity.getCurrentActivity() != null) {
                float f;
                double d0 = entity.func_70068_e(this.field_76990_c.field_78734_h);
                float f2 = f = entity.func_70093_af() ? NAME_TAG_RANGE_SNEAK : NAME_TAG_RANGE;
                if (d0 < (double)(f * f)) {
                    this.func_188296_a((Entity)entity, x, y - 0.25, z, "(" + entity.getCurrentActivity() + ")", d0);
                }
            }
        }
    }

    private void renderHealth(EntityVillagerMCA villager, double posX, double posY, double posZ, int currentHealth, int maxHealth) {
        int redHeartU = 80;
        int darkHeartU = 96;
        int heartsDrawn = 0;
        float maxHealthF = Math.round((float)maxHealth / 2.0f);
        float currentHealthF = Math.round((float)currentHealth / 2.0f);
        int heartsMax = Math.round(maxHealthF / maxHealthF * 10.0f);
        int heartsToDraw = Math.round(currentHealthF / maxHealthF * 10.0f);
        for (int i = 0; i < heartsMax; ++i) {
            int heartU = i < heartsToDraw ? 80 : 96;
            ++heartsDrawn;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)posX + 0.0f), (float)((float)posY + villager.field_70131_O + 1.0f), (float)((float)posZ));
            GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)-0.027f, (float)-0.027f, (float)0.027f);
            GL11.glDisable((int)2896);
            GL11.glTranslatef((float)-2.0f, (float)2.0f, (float)-2.0f);
            RenderVillagerMCA.drawTexturedRectangle(gui, (int)posX + heartsDrawn * 8 - 45, (int)posY - 4, heartU, 0, 16, 16);
            GL11.glPopMatrix();
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2896);
        }
    }

    protected ResourceLocation getEntityTexture(EntityVillagerMCA villager) {
        return villager.getTextureResourceLocation();
    }

    protected boolean canRenderName(EntityVillagerMCA entity) {
        float distance = Minecraft.func_71410_x().field_71439_g.func_70032_d((Entity)entity);
        return distance < 5.0f;
    }

    public static void drawTexturedRectangle(ResourceLocation texture, int x, int y, int u, int v, int width, int height) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_187315_a((double)((float)(u + 0) * f), (double)((float)(v + height) * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)(u + width) * f), (double)((float)(v + height) * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + 0), 0.0).func_187315_a((double)((float)(u + width) * f), (double)((float)(v + 0) * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_187315_a((double)((float)(u + 0) * f), (double)((float)(v + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }
}

