/*
 * Decompiled with CFR 0.152.
 */
package mca.command;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.UUID;
import mca.core.MCA;
import mca.core.minecraft.ItemsMCA;
import mca.entity.EntityGrimReaper;
import mca.entity.EntityVillagerMCA;
import mca.entity.data.PlayerSaveData;
import mca.items.ItemBaby;
import mca.util.Util;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CommandAdminMCA
extends CommandBase {
    public String func_71517_b() {
        return "mca-admin";
    }

    public String func_71518_a(ICommandSender commandSender) {
        return "/mca-admin <subcommand> <arguments>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] input) throws CommandException {
        try {
            if (!MCA.getConfig().enableAdminCommands) {
                this.sendMessage(commandSender, "MCA admin commands have been disabled by the server administrator.");
                return;
            }
            if (input.length == 0) {
                throw new WrongUsageException("", new Object[0]);
            }
            EntityPlayer player = (EntityPlayer)commandSender;
            String subcommand = input[0].toLowerCase();
            String[] arguments = Arrays.copyOfRange(input, 1, input.length);
            MCA.getLog().info(player.func_70005_c_() + " entered debug command " + Arrays.toString(input));
            switch (subcommand) {
                case "help": {
                    this.displayHelp(commandSender);
                    break;
                }
                case "ffh": {
                    this.forceFullHearts(player);
                    break;
                }
                case "fbg": {
                    this.forceBabyGrow(player);
                    break;
                }
                case "fcg": {
                    this.forceChildGrow(player);
                    break;
                }
                case "clv": {
                    this.clearLoadedVillagers(player);
                    break;
                }
                case "inh": {
                    this.incrementHearts(player);
                    break;
                }
                case "deh": {
                    this.decrementHearts(player);
                    break;
                }
                case "sgr": {
                    this.spawnGrimReaper(player);
                    break;
                }
                case "kgr": {
                    this.killGrimReaper(player);
                    break;
                }
                case "dpd": {
                    this.dumpPlayerData(player);
                    break;
                }
                case "rvd": {
                    this.resetVillagerData(player, arguments);
                    break;
                }
                case "rpd": {
                    this.resetPlayerData(player, arguments);
                    break;
                }
                case "cve": {
                    this.clearVillagerEditors(player);
                    break;
                }
                default: {
                    throw new WrongUsageException("", new Object[0]);
                }
            }
        }
        catch (ClassCastException e) {
            throw new CommandException("MCA commands cannot be used through rcon.", new Object[0]);
        }
        catch (WrongUsageException e) {
            throw new CommandException("Your command was invalid or improperly formatted. Usage: " + this.func_71518_a(commandSender), new Object[0]);
        }
    }

    private void forceFullHearts(EntityPlayer player) {
        for (Entity entity : player.field_70170_p.field_72996_f) {
            if (!(entity instanceof EntityVillagerMCA)) continue;
            EntityVillagerMCA villager = (EntityVillagerMCA)entity;
            villager.getPlayerHistoryFor(player.func_110124_au()).setHearts(100);
        }
        this.sendMessage((ICommandSender)player, "\u00a7AForced full hearts on all villagers.");
    }

    private void forceBabyGrow(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (!(stack.func_77973_b() instanceof ItemBaby)) continue;
            stack.func_77978_p().func_74768_a("age", MCA.getConfig().babyGrowUpTime);
        }
        this.sendMessage((ICommandSender)player, "\u00a7AForced any held babies to grow up age.");
    }

    private void forceChildGrow(EntityPlayer player) {
        player.field_70170_p.field_72996_f.stream().filter(e -> e instanceof EntityVillagerMCA && ((EntityVillagerMCA)((Object)e)).func_70631_g_()).forEach(e -> ((EntityVillagerMCA)((Object)e)).func_110195_a(999999));
        this.sendMessage((ICommandSender)player, "\u00a7AForced any children to grow to adults.");
    }

    private void clearLoadedVillagers(EntityPlayer player) {
        int n = 0;
        for (Entity entity : player.field_70170_p.field_72996_f) {
            if (!(entity instanceof EntityVillagerMCA)) continue;
            entity.func_70106_y();
            ++n;
        }
        this.sendMessage((ICommandSender)player, "\u00a7ACleared " + n + " villagers from the world.");
    }

    private void incrementHearts(EntityPlayer player) {
        for (Entity entity : player.field_70170_p.field_72996_f) {
            if (!(entity instanceof EntityVillagerMCA)) continue;
            EntityVillagerMCA villager = (EntityVillagerMCA)entity;
            villager.getPlayerHistoryFor(player.func_110124_au()).changeHearts(10);
        }
        this.sendMessage((ICommandSender)player, "\u00a7AIncreased hearts for all villagers by 10.");
    }

    private void decrementHearts(EntityPlayer player) {
        for (Entity entity : player.field_70170_p.field_72996_f) {
            if (!(entity instanceof EntityVillagerMCA)) continue;
            EntityVillagerMCA villager = (EntityVillagerMCA)entity;
            villager.getPlayerHistoryFor(player.func_110124_au()).changeHearts(-10);
        }
        this.sendMessage((ICommandSender)player, "\u00a7ADecreased hearts for all villagers by 10.");
    }

    private void spawnGrimReaper(EntityPlayer player) {
        EntityGrimReaper reaper = new EntityGrimReaper(player.field_70170_p);
        reaper.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        player.field_70170_p.func_72838_d((Entity)reaper);
    }

    private void killGrimReaper(EntityPlayer player) {
        player.field_70170_p.field_72996_f.stream().filter(e -> e instanceof EntityGrimReaper).forEach(e -> e.func_70106_y());
    }

    private void dumpPlayerData(EntityPlayer player) {
        PlayerSaveData.get(player).dump(player);
    }

    private void resetVillagerData(EntityPlayer sender, String[] arguments) {
        Optional<EntityVillagerMCA> target = Util.getEntityByUUID(sender.field_70170_p, UUID.fromString(arguments[0]), EntityVillagerMCA.class);
        if (!target.isPresent()) {
            this.sendMessage((ICommandSender)sender, "Target villager was not found.");
        } else {
            ((EntityVillagerMCA)((Object)target.get())).reset();
            this.sendMessage((ICommandSender)sender, ((EntityVillagerMCA)((Object)target.get())).func_145748_c_().func_150260_c() + " has been reset successfully.");
        }
    }

    private void resetPlayerData(EntityPlayer sender, String[] arguments) {
        Optional target = Optional.fromJavaUtil(sender.field_70170_p.field_72996_f.stream().filter(e -> e instanceof EntityPlayer && e.func_70005_c_().equals(arguments[0])).findFirst());
        if (!target.isPresent()) {
            this.sendMessage((ICommandSender)sender, "Player not found on the server.");
        } else {
            PlayerSaveData.get((EntityPlayer)target.get()).reset();
            this.sendMessage((ICommandSender)sender, "Player data for " + ((Entity)target.get()).func_70005_c_() + " has been reset successfully.");
            this.sendMessage((ICommandSender)target.get(), "Your player data has been reset by " + sender.func_70005_c_() + ".");
        }
    }

    private void clearVillagerEditors(EntityPlayer sender) {
        ItemStack editorStack = new ItemStack(ItemsMCA.VILLAGER_EDITOR);
        sender.field_70170_p.field_73010_i.stream().filter(p -> p.field_71071_by.func_70431_c(editorStack)).forEach(p -> {
            for (int i = 0; i < p.field_71071_by.func_70302_i_() - 1; ++i) {
                if (p.field_71071_by.func_70301_a(i).func_77973_b() != ItemsMCA.VILLAGER_EDITOR) continue;
                p.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            }
        });
        this.sendMessage((ICommandSender)sender, "All villager editors cleared from inventories.");
    }

    public int func_82362_a() {
        return 4;
    }

    private void sendMessage(ICommandSender commandSender, String message) {
        commandSender.func_145747_a((ITextComponent)new TextComponentString("\u00a76[MCA] \u00a7r" + message));
    }

    private void sendMessage(ICommandSender commandSender, String message, boolean noPrefix) {
        if (noPrefix) {
            commandSender.func_145747_a((ITextComponent)new TextComponentString(message));
        } else {
            this.sendMessage(commandSender, message);
        }
    }

    private void displayHelp(ICommandSender commandSender) {
        this.sendMessage(commandSender, "\u00a74--- \u00a76OP COMMANDS\u00a74 ---", true);
        this.sendMessage(commandSender, "\u00a7F /mca-admin ffh \u00a76 - Force all hearts on all villagers.", true);
        this.sendMessage(commandSender, "\u00a7F /mca-admin fbg \u00a76 - Force your baby to grow up.", true);
        this.sendMessage(commandSender, "\u00a7F /mca-admin fcg \u00a76 - Force nearby children to grow.", true);
        this.sendMessage(commandSender, "\u00a7F /mca-admin clv \u00a76 - Clear all loaded villagers. \u00a7C(IRREVERSABLE)", true);
        this.sendMessage(commandSender, "\u00a7F /mca-admin inh \u00a76 - Increase hearts by 10.", true);
        this.sendMessage(commandSender, "\u00a7F /mca-admin deh \u00a76 - Decrease hearts by 10.", true);
        this.sendMessage(commandSender, "\u00a7F /mca-admin kgr \u00a76 - Kill all Grim Reapers in the world.", true);
        this.sendMessage(commandSender, "\u00a7F /mca-admin dpd \u00a76 - Dumps player data to chat.", true);
        this.sendMessage(commandSender, "\u00a7F /mca-admin rvd <UUID>\u00a76 - Resets the given villager.", true);
        this.sendMessage(commandSender, "\u00a7F /mca-admin rpd <PlayerName>\u00a76 - Resets the given player's MCA data.", true);
        this.sendMessage(commandSender, "\u00a7F /mca-admin cve\u00a76 - Remove all villager editors from the game.", true);
        this.sendMessage(commandSender, "\u00a74--- \u00a76GLOBAL COMMANDS\u00a74 ---", true);
        this.sendMessage(commandSender, "\u00a7F /mca-admin help \u00a76 - Shows this list of commands.", true);
    }
}

