/*
 * Decompiled with CFR 0.152.
 */
package mca.command;

import java.util.Arrays;
import mca.core.MCA;
import mca.core.MCAServer;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CommandMCA
extends CommandBase {
    public String func_71517_b() {
        return "mca";
    }

    public String func_71518_a(ICommandSender commandSender) {
        return "/mca <subcommand> <arguments>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] input) throws CommandException {
        try {
            if (!MCA.getConfig().allowPlayerMarriage) {
                this.sendMessage(commandSender, "MCA commands have been disabled by the server administrator.");
                return;
            }
            if (input.length == 0) {
                throw new WrongUsageException("", new Object[0]);
            }
            EntityPlayer player = (EntityPlayer)commandSender;
            String subcommand = input[0].toLowerCase();
            String[] arguments = Arrays.copyOfRange(input, 1, input.length);
            MCA.getLog().info(player.func_70005_c_() + " entered command " + Arrays.toString(input));
            switch (subcommand) {
                case "help": {
                    this.displayHelp(commandSender);
                    break;
                }
                case "propose": {
                    EntityPlayer target = player.field_70170_p.func_72924_a(arguments[0]);
                    if (target != null) {
                        MCAServer.get().sendProposal(player, target);
                        break;
                    }
                    player.func_145747_a((ITextComponent)new TextComponentString("Player not found on the server."));
                    break;
                }
                case "accept": {
                    EntityPlayer target = player.field_70170_p.func_72924_a(arguments[0]);
                    if (target != null) {
                        MCAServer.get().acceptProposal(player, target);
                        break;
                    }
                    player.func_145747_a((ITextComponent)new TextComponentString("Player not found on the server."));
                    break;
                }
                case "proposals": {
                    MCAServer.get().listProposals(player);
                    break;
                }
                case "procreate": {
                    MCAServer.get().procreate(player);
                    break;
                }
                case "separate": {
                    MCAServer.get().endMarriage(player);
                    break;
                }
                case "reject": {
                    EntityPlayer target = player.field_70170_p.func_72924_a(arguments[0]);
                    if (target != null) {
                        MCAServer.get().rejectProposal(player, target);
                        break;
                    }
                    player.func_145747_a((ITextComponent)new TextComponentString("Player not found on the server."));
                    break;
                }
                default: {
                    throw new WrongUsageException("", new Object[0]);
                }
            }
        }
        catch (ClassCastException e) {
            throw new CommandException("MCA commands cannot be used through rcon.", new Object[0]);
        }
        catch (WrongUsageException e) {
            throw new CommandException("Your command was invalid or improperly formatted. Usage: " + this.func_71518_a(commandSender), new Object[0]);
        }
    }

    public int func_82362_a() {
        return 0;
    }

    private void sendMessage(ICommandSender commandSender, String message) {
        commandSender.func_145747_a((ITextComponent)new TextComponentString("\u00a76[MCA] \u00a7r" + message));
    }

    private void sendMessage(ICommandSender commandSender, String message, boolean noPrefix) {
        if (noPrefix) {
            commandSender.func_145747_a((ITextComponent)new TextComponentString(message));
        } else {
            this.sendMessage(commandSender, message);
        }
    }

    private void displayHelp(ICommandSender commandSender) {
        this.sendMessage(commandSender, "\u00a74--- \u00a76PLAYER COMMANDS\u00a74 ---", true);
        this.sendMessage(commandSender, "\u00a7F /mca propose <PlayerName>\u00a76 - Proposes marriage to the given player.", true);
        this.sendMessage(commandSender, "\u00a7F /mca proposals \u00a76 - Shows all active proposals.", true);
        this.sendMessage(commandSender, "\u00a7F /mca accept <PlayerName>\u00a76 - Accepts the player's marriage request.", true);
        this.sendMessage(commandSender, "\u00a7F /mca reject <PlayerName>\u00a76 - Rejects the player's marriage request.", true);
        this.sendMessage(commandSender, "\u00a7F /mca procreate \u00a76 - Starts procreation.", true);
        this.sendMessage(commandSender, "\u00a7F /mca separate \u00a76 - Ends your marriage.", true);
        this.sendMessage(commandSender, "\u00a74--- \u00a76GLOBAL COMMANDS\u00a74 ---", true);
        this.sendMessage(commandSender, "\u00a7F /mca help \u00a76 - Shows this list of commands.", true);
    }
}

