/*
 * Decompiled with CFR 0.152.
 */
package mca.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public final class Config
implements Serializable {
    private final transient Configuration config;
    public boolean overwriteOriginalVillagers;
    public boolean enableDiminishingReturns;
    public boolean enableInfection;
    public int infectionChance;
    public boolean allowGrimReaper;
    public int guardSpawnRate;
    public int chanceToHaveTwins;
    public int marriageHeartsRequirement;
    public int roseGoldSpawnWeight;
    public int babyGrowUpTime;
    public int childGrowUpTime;
    public int villagerSpawnerCap;
    public int villagerSpawnerRateMinutes;
    public int villagerMaxHealth;
    public boolean allowTrading;
    public boolean logVillagerDeaths;
    public boolean enableRevivals;
    public String villagerChatPrefix;
    public boolean allowPlayerMarriage;
    public boolean enableAdminCommands;
    public boolean allowCrashReporting;
    public boolean allowUpdateChecking;
    public boolean allowRoseGoldGeneration;

    public Config(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.addConfigValues();
    }

    private void addConfigValues() {
        this.overwriteOriginalVillagers = this.config.get("General", "Overwrite Original Villagers?", true, "Should original villagers be overwritten by MCA villagers?").getBoolean();
        this.enableDiminishingReturns = this.config.get("General", "Enable Interaction Fatigue?", true, "Should interactions yield diminishing returns over time?").getBoolean();
        this.enableInfection = this.config.get("General", "Enable Zombie Infection?", true, "Should zombies be able to infect villagers?").getBoolean();
        this.infectionChance = this.config.get("General", "Chance of Infection", 5, "Chance that a villager will be infected on hit from a zombie. Default is 5 for 5%.").getInt();
        this.allowGrimReaper = this.config.get("General", "Allow Grim Reaper?", true, "Should the Grim Reaper boss be enabled?").getBoolean();
        this.guardSpawnRate = this.config.get("General", "Guard Spawn Rate", 6, "How many villagers that should be in a village before a guard spawns.").getInt();
        this.chanceToHaveTwins = this.config.get("General", "Chance to Have Twins", 2, "Chance that you will have twins. Default is 2 for 2%.").getInt();
        this.marriageHeartsRequirement = this.config.get("General", "Marriage Hearts Requirement", 100, "Number of hearts required to get married.").getInt();
        this.roseGoldSpawnWeight = this.config.get("General", "Rose Gold Spawn Weight", 6, "Spawn weights for Rose Gold").getInt();
        this.babyGrowUpTime = this.config.get("General", "Baby Grow Up Time (Minutes)", 30, "Minutes it takes for a baby to be ready to grow up.").getInt();
        this.childGrowUpTime = this.config.get("General", "Child Grow Up Time (Minutes)", 60, "Minutes it takes for a child to grow into an adult.").getInt();
        this.villagerSpawnerCap = this.config.get("General", "Villager Spawner Cap", 5, "Maximum number of villagers that a spawner will create in the area before it stops.").getInt();
        this.villagerSpawnerRateMinutes = this.config.get("General", "Villager Spawner Rate", 30, "The spawner will spawn 1 villager per this many minutes.").getInt();
        this.allowTrading = this.config.get("General", "Enable Trading?", true, "Is trading with villagers enabled?").getBoolean();
        this.logVillagerDeaths = this.config.get("General", "Log Villager Deaths?", true, "Should villager deaths be logged?").getBoolean();
        this.enableRevivals = this.config.get("General", "Enable Revivals?", true, "Should reviving dead villagers be enabled?").getBoolean();
        this.villagerChatPrefix = this.config.get("General", "Villager Chat Prefix", "", "Formatting prefix used for all chat with villagers.").getString();
        this.allowPlayerMarriage = this.config.get("General", "Allow Player Marriage?", true, "Enables or disables player marriage.").getBoolean();
        this.enableAdminCommands = this.config.get("General", "Enable Admin Commands?", true, "Enables or disables MCA admin commands for ops.").getBoolean();
        this.allowCrashReporting = this.config.get("General", "Allow Crash Reporting?", true, "If enabled, sends crash reports to MCA developers.").getBoolean();
        this.allowUpdateChecking = this.config.get("General", "Allow Update Checking?", true, "If enabled, notifies you when an update to MCA is available.").getBoolean();
        this.allowRoseGoldGeneration = this.config.get("General", "Allow Rose Gold World Generation", true, "If enabled, generates rose gold in your world. If disabled, generates stone instead.").getBoolean();
        this.villagerMaxHealth = this.config.get("General", "Villager Max Health", 20, "Each villager's maximum health. 1 point equals 1 heart.").getInt();
        this.config.save();
    }

    public Configuration getInstance() {
        return this.config;
    }

    public List<IConfigElement> getCategories() {
        ArrayList<IConfigElement> elements = new ArrayList<IConfigElement>();
        for (String s : this.config.getCategoryNames()) {
            if (s.equals("server")) continue;
            ConfigElement element = new ConfigElement(this.config.getCategory(s));
            elements.addAll(element.getChildElements());
        }
        return elements;
    }
}

