/*
 * Decompiled with CFR 0.152.
 */
package mca.core;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import mca.core.MCA;
import net.minecraft.util.StringUtils;
import org.apache.commons.io.IOUtils;

public class Localizer {
    private Map<String, String> localizerMap = new HashMap<String, String>();
    private static final ArrayList<String> EMPTY_LIST = new ArrayList();

    public Localizer() {
        InputStream inStream = StringUtils.class.getResourceAsStream("/assets/mca/lang/en_us.lang");
        try {
            List lines = IOUtils.readLines((InputStream)inStream, (Charset)Charsets.UTF_8);
            for (String line : lines) {
                if (line.startsWith("#") || line.isEmpty()) continue;
                String[] split = line.split("\\=");
                String key = split[0];
                String value = split[1];
                this.localizerMap.put(key, value);
            }
        }
        catch (IOException e) {
            MCA.getLog().error("Error initializing localizer: " + e);
        }
    }

    public String localize(String key, String ... vars) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, vars);
        return this.localize(key, vars != null ? list : EMPTY_LIST);
    }

    public String localize(String key, ArrayList<String> vars) {
        List responses;
        String result = this.localizerMap.getOrDefault(key, key);
        if (result.equals(key) && (responses = this.localizerMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(key)).map(Map.Entry::getValue).collect(Collectors.toList())).size() > 0) {
            result = (String)responses.get(new Random().nextInt(responses.size()));
        }
        return this.parseVars(result, vars).replaceAll("\\\\", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseVars(String str, ArrayList<String> vars) {
        int index = 1;
        str = str.replaceAll("%Supporter%", MCA.getInstance().getRandomSupporter());
        String varString = "%v" + index + "%";
        while (str.contains("%v") && index < 10) {
            try {
                str = str.replaceAll(varString, vars.get(index - 1));
            }
            catch (IndexOutOfBoundsException e) {
                str = str.replaceAll(varString, "");
                MCA.getLog().warn("Failed to replace variable in localized string: " + str);
            }
            finally {
                varString = "%v" + ++index + "%";
            }
        }
        return str;
    }
}

