/*
 * Decompiled with CFR 0.152.
 */
package mca.core;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.Random;
import mca.api.API;
import mca.command.CommandAdminMCA;
import mca.command.CommandMCA;
import mca.core.Config;
import mca.core.Localizer;
import mca.core.forge.EventHooks;
import mca.core.forge.GuiHandler;
import mca.core.forge.NetMCA;
import mca.core.forge.ServerProxy;
import mca.core.minecraft.ItemsMCA;
import mca.core.minecraft.ProfessionsMCA;
import mca.core.minecraft.RoseGoldOreGenerator;
import mca.entity.EntityGrimReaper;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumGender;
import mca.util.Util;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;

@Mod(modid="mca", name="Minecraft Comes Alive", version="6.0.1", guiFactory="mca.client.MCAGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class MCA {
    public static final String MODID = "mca";
    public static final String NAME = "Minecraft Comes Alive";
    public static final String VERSION = "6.0.1";
    @SidedProxy(clientSide="mca.core.forge.ClientProxy", serverSide="mca.core.forge.ServerProxy")
    public static ServerProxy proxy;
    public static CreativeTabs creativeTab;
    @Mod.Instance
    private static MCA instance;
    private static Logger logger;
    private static Localizer localizer;
    private static Config config;
    private static long startupTimestamp;
    public static String latestVersion;
    public static boolean updateAvailable;
    public String[] supporters = new String[0];

    public static Logger getLog() {
        return logger;
    }

    public static MCA getInstance() {
        return instance;
    }

    public static Localizer getLocalizer() {
        return localizer;
    }

    public static Config getConfig() {
        return config;
    }

    public static long getStartupTimestamp() {
        return startupTimestamp;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        startupTimestamp = new Date().getTime();
        instance = this;
        logger = event.getModLog();
        proxy.registerEntityRenderers();
        localizer = new Localizer();
        config = new Config(event);
        creativeTab = new CreativeTabs("MCA"){

            public ItemStack func_78016_d() {
                return new ItemStack(ItemsMCA.ENGAGEMENT_RING);
            }
        };
        MinecraftForge.EVENT_BUS.register((Object)new EventHooks());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        NetMCA.registerMessages();
        if (MCA.getConfig().allowUpdateChecking && !(latestVersion = Util.httpGet("https://minecraftcomesalive.com/api/latest")).equals(VERSION) && !latestVersion.equals("")) {
            updateAvailable = true;
            MCA.getLog().warn("An update for Minecraft Comes Alive is available: v" + latestVersion);
        }
        this.supporters = Util.httpGet("https://minecraftcomesalive.com/api/supporters").split(",");
        MCA.getLog().info("Loaded " + this.supporters.length + " supporters.");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new RoseGoldOreGenerator(), (int)MCA.getConfig().roseGoldSpawnWeight);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "EntityVillagerMCA"), EntityVillagerMCA.class, (String)EntityVillagerMCA.class.getSimpleName(), (int)1120, (Object)this, (int)50, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "GrimReaperMCA"), EntityGrimReaper.class, (String)EntityGrimReaper.class.getSimpleName(), (int)1121, (Object)this, (int)50, (int)2, (boolean)true);
        ProfessionsMCA.registerCareers();
        proxy.registerModelMeshers();
        ItemsMCA.assignCreativeTabs();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        API.init();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandMCA());
        event.registerServerCommand((ICommand)new CommandAdminMCA());
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        this.checkForCrashReports();
    }

    public String getRandomSupporter() {
        if (this.supporters.length > 0) {
            return this.supporters[new Random().nextInt(this.supporters.length)];
        }
        return API.getRandomName(EnumGender.getRandom());
    }

    public void checkForCrashReports() {
        if (MCA.getConfig().allowCrashReporting) {
            File crashReportsFolder = new File(System.getProperty("user.dir") + "/crash-reports/");
            File[] crashReportFiles = crashReportsFolder.listFiles(File::isFile);
            try {
                Optional<File> newestFile;
                if (crashReportFiles != null && (newestFile = Arrays.stream(crashReportFiles).max(Comparator.comparingLong(File::lastModified))).isPresent() && newestFile.get().lastModified() > startupTimestamp) {
                    MCA.getLog().warn("Crash detected! Attempting to upload report...");
                    HashMap<String, String> payload = new HashMap<String, String>();
                    payload.put("minecraft_version", FMLCommonHandler.instance().getMinecraftServerInstance().func_71249_w());
                    payload.put("operating_system", System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version"));
                    payload.put("java_version", System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
                    payload.put("mod_version", VERSION);
                    payload.put("body", FileUtils.readFileToString((File)newestFile.get(), (String)"UTF-8"));
                    byte[] out = new Gson().toJson(payload).getBytes(StandardCharsets.UTF_8);
                    URL url = new URL("http://minecraftcomesalive.com/api/crash-reports");
                    URLConnection con = url.openConnection();
                    HttpURLConnection http = (HttpURLConnection)con;
                    http.setRequestMethod("POST");
                    http.setDoOutput(true);
                    http.setFixedLengthStreamingMode(out.length);
                    http.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                    http.setRequestProperty("User-Agent", "Minecraft Client " + FMLCommonHandler.instance().getMinecraftServerInstance().func_71249_w());
                    http.connect();
                    OutputStream os = http.getOutputStream();
                    os.write(out);
                    os.flush();
                    os.close();
                    if (http.getResponseCode() != 200) {
                        MCA.getLog().error("Failed to submit crash report. Non-OK response code returned: " + http.getResponseCode());
                    } else {
                        MCA.getLog().warn("Crash report submitted successfully.");
                    }
                }
            }
            catch (IOException e) {
                MCA.getLog().error("An unexpected error occurred while attempting to submit the crash report.", (Throwable)e);
            }
        }
    }

    static {
        latestVersion = "";
        updateAvailable = false;
    }
}

