/*
 * Decompiled with CFR 0.152.
 */
package mca.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import mca.core.minecraft.ItemsMCA;
import mca.core.minecraft.VillageHelper;
import mca.entity.EntityGrimReaper;
import mca.entity.EntityVillagerMCA;
import mca.entity.data.PlayerSaveData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class MCAServer {
    private static MCAServer instance;
    private static Map<UUID, List<UUID>> proposals;
    private static Map<UUID, Long> procreateMap;
    private int serverTicks = 0;
    private int reaperSummonTicks = 0;
    private BlockPos reaperSpawnPos = BlockPos.field_177992_a;
    private World reaperSpawnWorld = null;

    private MCAServer() {
        proposals = new HashMap<UUID, List<UUID>>();
        procreateMap = new HashMap<UUID, Long>();
    }

    public static MCAServer get() {
        if (instance == null) {
            instance = new MCAServer();
        }
        return instance;
    }

    public void tick() {
        ++this.serverTicks;
        if (this.serverTicks >= 100) {
            WorldServer overworld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
            VillageHelper.tick((World)overworld);
            this.serverTicks = 0;
        }
        if (this.reaperSummonTicks > 0) {
            --this.reaperSummonTicks;
            if (this.reaperSummonTicks % 20 == 0) {
                EntityLightningBolt lightningBolt = new EntityLightningBolt(this.reaperSpawnWorld, (double)this.reaperSpawnPos.func_177958_n(), (double)this.reaperSpawnPos.func_177956_o(), (double)this.reaperSpawnPos.func_177952_p(), false);
                this.reaperSpawnWorld.func_72942_c((Entity)lightningBolt);
            }
            if (this.reaperSummonTicks == 0) {
                EntityGrimReaper reaper = new EntityGrimReaper(this.reaperSpawnWorld);
                reaper.func_70107_b(this.reaperSpawnPos.func_177958_n(), this.reaperSpawnPos.func_177956_o(), this.reaperSpawnPos.func_177952_p());
                this.reaperSpawnWorld.func_72838_d((Entity)reaper);
            }
        }
        ArrayList removals = new ArrayList();
        procreateMap.keySet().stream().filter(k -> procreateMap.get(k) < System.currentTimeMillis()).forEach(removals::add);
        removals.forEach(procreateMap::remove);
    }

    private boolean hasProposalFrom(EntityPlayer sender, EntityPlayer receiver) {
        return this.getProposalsFor(receiver).contains(sender.func_110124_au());
    }

    private List<UUID> getProposalsFor(EntityPlayer player) {
        return proposals.getOrDefault(player.func_110124_au(), new ArrayList());
    }

    private void removeProposalFor(EntityPlayer target, EntityPlayer proposer) {
        List<UUID> list = this.getProposalsFor(target);
        list.remove(proposer.func_110124_au());
        proposals.put(target.func_110124_au(), list);
    }

    public void listProposals(EntityPlayer sender) {
        List<UUID> proposals = this.getProposalsFor(sender);
        if (proposals.size() == 0) {
            this.infoMessage(sender, "You have no active proposals.");
        } else {
            this.infoMessage(sender, "You have active proposals from: ");
        }
        proposals.forEach(uuid -> {
            EntityPlayer player = sender.field_70170_p.func_152378_a(uuid);
            if (player != null) {
                this.infoMessage(sender, "- " + player.func_70005_c_());
            }
        });
    }

    public void sendProposal(EntityPlayer sender, EntityPlayer receiver) {
        if (PlayerSaveData.get(sender).isMarriedOrEngaged()) {
            this.failMessage(sender, "You cannot send a proposal since you are already married or engaged.");
            return;
        }
        if (sender == receiver) {
            this.failMessage(sender, "You cannot propose to yourself.");
            return;
        }
        if (this.hasProposalFrom(sender, receiver)) {
            this.failMessage(sender, "You have already sent a proposal to " + receiver.func_70005_c_());
        } else {
            this.successMessage(sender, "Your proposal to " + receiver.func_70005_c_() + " has been sent!");
            this.infoMessage(receiver, sender.func_70005_c_() + " has proposed marriage. To accept, type /mca accept " + sender.func_70005_c_());
            List<UUID> list = this.getProposalsFor(receiver);
            list.add(sender.func_110124_au());
            proposals.put(receiver.func_110124_au(), list);
        }
    }

    public void rejectProposal(EntityPlayer sender, EntityPlayer receiver) {
        if (!this.hasProposalFrom(receiver, sender)) {
            this.failMessage(sender, receiver.func_70005_c_() + " hasn't proposed to you.");
        } else {
            this.successMessage(sender, "Your rejection has been sent.");
            this.failMessage(receiver, sender.func_70005_c_() + " rejected your proposal.");
            this.removeProposalFor(sender, receiver);
        }
    }

    public void acceptProposal(EntityPlayer sender, EntityPlayer receiver) {
        if (!this.hasProposalFrom(receiver, sender)) {
            this.failMessage(sender, receiver.func_70005_c_() + " hasn't proposed to you.");
        } else {
            this.successMessage(receiver, sender.func_70005_c_() + " has accepted your proposal!");
            PlayerSaveData senderData = PlayerSaveData.get(sender);
            PlayerSaveData receiverData = PlayerSaveData.get(receiver);
            senderData.marry(receiver.func_110124_au(), receiver.func_70005_c_());
            receiverData.marry(sender.func_110124_au(), sender.func_70005_c_());
            this.successMessage(sender, "You and " + receiver.func_70005_c_() + " are now married.");
            this.successMessage(receiver, "You and " + sender.func_70005_c_() + " are now married.");
            this.removeProposalFor(sender, receiver);
        }
    }

    public void endMarriage(EntityPlayer sender) {
        PlayerSaveData senderData = PlayerSaveData.get(sender);
        if (!senderData.isMarriedOrEngaged()) {
            this.failMessage(sender, "You are not married.");
            return;
        }
        Optional<Entity> spouse = sender.field_70170_p.field_72996_f.stream().filter(e -> e.func_110124_au().equals(senderData.getSpouseUUID())).findFirst();
        if (spouse.isPresent() && spouse.get() instanceof EntityVillagerMCA) {
            this.failMessage(sender, "You cannot use this command when married to a villager.");
            return;
        }
        PlayerSaveData receiverData = PlayerSaveData.getExisting(sender.field_70170_p, senderData.getSpouseUUID());
        this.successMessage(sender, "Your marriage to " + senderData.getSpouseName() + " has ended.");
        senderData.endMarriage();
        receiverData.endMarriage();
        spouse.ifPresent(e -> this.failMessage((EntityPlayer)e, sender.func_70005_c_() + " has ended their marriage with you."));
    }

    public void procreate(EntityPlayer sender) {
        PlayerSaveData senderData = PlayerSaveData.get(sender);
        if (!senderData.isMarriedOrEngaged()) {
            this.failMessage(sender, "You cannot procreate if you are not married.");
            return;
        }
        if (senderData.isBabyPresent()) {
            this.failMessage(sender, "You already have a baby.");
            return;
        }
        EntityPlayer spouse = sender.field_70170_p.func_152378_a(senderData.getSpouseUUID());
        if (spouse != null) {
            if (!procreateMap.containsKey(spouse.func_110124_au())) {
                procreateMap.put(sender.func_110124_au(), System.currentTimeMillis() + 10000L);
                this.infoMessage(spouse, sender.func_70005_c_() + " has requested procreation. To accept, type /mca procreate within 10 seconds.");
            } else {
                this.successMessage(sender, "Procreation successful!");
                this.successMessage(spouse, "Procreation successful!");
                spouse.func_191521_c(new ItemStack(sender.field_70170_p.field_73012_v.nextBoolean() ? ItemsMCA.BABY_BOY : ItemsMCA.BABY_GIRL));
                PlayerSaveData spouseData = PlayerSaveData.get(spouse);
                spouseData.setBabyPresent(true);
                senderData.setBabyPresent(true);
            }
        } else {
            this.failMessage(sender, "Your spouse is not present on the server.");
        }
    }

    private void successMessage(EntityPlayer player, String message) {
        player.func_145747_a((ITextComponent)new TextComponentString("\u00a7A" + message));
    }

    private void failMessage(EntityPlayer player, String message) {
        player.func_145747_a((ITextComponent)new TextComponentString("\u00a7C" + message));
    }

    private void infoMessage(EntityPlayer player, String message) {
        player.func_145747_a((ITextComponent)new TextComponentString("\u00a7E" + message));
    }

    public void setReaperSpawnPos(World world, BlockPos pos) {
        this.reaperSpawnWorld = world;
        this.reaperSpawnPos = pos;
    }

    public void startSpawnReaper() {
        this.reaperSummonTicks = 80;
    }
}

