/*
 * Decompiled with CFR 0.152.
 */
package mca.core.forge;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import mca.client.network.ClientMessageQueue;
import mca.core.MCA;
import mca.core.MCAServer;
import mca.core.minecraft.BlocksMCA;
import mca.core.minecraft.ItemsMCA;
import mca.core.minecraft.ProfessionsMCA;
import mca.core.minecraft.WorldEventListenerMCA;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumGender;
import mca.items.ItemBaby;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class EventHooks {
    public Map<UUID, ItemStack> limbo = new HashMap<UUID, ItemStack>();

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        ItemsMCA.register(event);
        BlocksMCA.registerItemBlocks(event);
        GameRegistry.addSmelting((Block)BlocksMCA.ROSE_GOLD_ORE, (ItemStack)new ItemStack(ItemsMCA.ROSE_GOLD_INGOT), (float)5.0f);
    }

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        BlocksMCA.register(event);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            event.getWorld().func_72954_a((IWorldEventListener)new WorldEventListenerMCA());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        ClientMessageQueue.processScheduledMessages();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        MCAServer.get().tick();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!MCA.updateAvailable) {
            return;
        }
        TextComponentString updateMessage = new TextComponentString("\u00a72An update for Minecraft Comes Alive is available: v" + MCA.latestVersion);
        String updateURLText = "\u00a7EClick \u00a79\u00a7o\u00a7nhere\u00a7r\u00a7E to download the update.";
        TextComponentString chatComponentUpdate = new TextComponentString(updateURLText);
        chatComponentUpdate.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraftcomesalive.com/download"));
        chatComponentUpdate.func_150256_b().func_150228_d(Boolean.valueOf(true));
        event.player.func_145747_a((ITextComponent)updateMessage);
        event.player.func_145747_a((ITextComponent)chatComponentUpdate);
        MCA.updateAvailable = false;
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0) {
            MCA.getInstance().checkForCrashReports();
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        World world = event.getWorld();
        Entity entity = event.getEntity();
        if (world.field_72995_K) {
            return;
        }
        if (!MCA.getConfig().overwriteOriginalVillagers) {
            return;
        }
        if (entity.getClass().equals(EntityVillager.class)) {
            EntityVillager originalVillager = (EntityVillager)entity;
            originalVillager.func_70106_y();
            EntityVillagerMCA newVillager = new EntityVillagerMCA(world, (com.google.common.base.Optional<VillagerRegistry.VillagerProfession>)com.google.common.base.Optional.of((Object)originalVillager.getProfessionForge()), (com.google.common.base.Optional<EnumGender>)com.google.common.base.Optional.absent());
            newVillager.func_70107_b(originalVillager.field_70165_t, originalVillager.field_70163_u, originalVillager.field_70161_v);
            newVillager.func_190672_a(world.func_175649_E(newVillager.func_190671_u_()), null, false);
            newVillager.forcePositionAsHome();
            world.func_72838_d((Entity)newVillager);
        }
    }

    @SubscribeEvent
    public void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        if (event.getTarget() instanceof EntityVillagerMCA && event.getEntityPlayer() != null) {
            EntityPlayer player = event.getEntityPlayer();
            EntityVillagerMCA villager = (EntityVillagerMCA)event.getTarget();
            if (villager.getProfessionForge() == ProfessionsMCA.bandit) {
                event.setResult(Event.Result.DENY);
            } else if (player.func_184614_ca().func_77973_b() == ItemsMCA.VILLAGER_EDITOR) {
                player.openGui((Object)MCA.getInstance(), 5, player.field_70170_p, villager.func_145782_y(), 0, 0);
                event.setResult(Event.Result.ALLOW);
            } else {
                player.func_71029_a(StatList.field_188074_H);
                player.openGui((Object)MCA.getInstance(), 1, player.field_70170_p, villager.func_145782_y(), 0, 0);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDamaged(LivingDamageEvent event) {
        if (event.getEntity() instanceof EntityVillagerMCA) {
            Entity source;
            EntityVillagerMCA villager = (EntityVillagerMCA)event.getEntity();
            Entity entity = source = event.getSource() != null ? event.getSource().func_76346_g() : null;
            if (source instanceof EntityLivingBase) {
                villager.field_70170_p.field_72996_f.stream().filter(e -> e instanceof EntityVillagerMCA && (double)e.func_70032_d((Entity)villager) <= 10.0 && ((EntityVillagerMCA)((Object)e)).getProfessionForge() == ProfessionsMCA.guard).forEach(e -> ((EntityVillagerMCA)((Object)e)).func_70624_b((EntityLivingBase)source));
            }
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        ItemStack stack = event.getEntityItem().func_92059_d();
        if (stack.func_77973_b() instanceof ItemBaby) {
            event.getPlayer().func_191521_c(stack);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlaceEvent(BlockEvent.PlaceEvent event) {
        int x = event.getPos().func_177958_n();
        int y = event.getPos().func_177956_o();
        int z = event.getPos().func_177952_p();
        Block placedBlock = event.getPlacedBlock().func_177230_c();
        if (placedBlock == Blocks.field_150480_ab && event.getWorld().func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c() == Blocks.field_150475_bE) {
            int i;
            int totemsFound = 0;
            for (i = 0; i < 4; ++i) {
                Block block;
                int dX = 0;
                int dZ = 0;
                if (i == 0 || i == 2) {
                    dX = -3;
                } else {
                    dZ = 3;
                }
                for (int j = -1; j < 2 && ((block = event.getWorld().func_180495_p(new BlockPos(x + dX, y + j, z + dZ)).func_177230_c()) == Blocks.field_150343_Z || block == Blocks.field_150480_ab); ++j) {
                    if (j != 1 || block != Blocks.field_150480_ab) continue;
                    ++totemsFound;
                }
            }
            if (totemsFound >= 3 && !event.getWorld().func_72935_r()) {
                MCAServer.get().setReaperSpawnPos(event.getWorld(), new BlockPos(x + 1, y + 10, z + 1));
                MCAServer.get().startSpawnReaper();
                for (i = 0; i < 2; ++i) {
                    event.getWorld().func_175698_g(new BlockPos(x, y - i, z));
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (this.limbo.containsKey(event.player.func_110124_au())) {
            event.player.field_71071_by.func_70441_a(this.limbo.get(event.player.func_110124_au()));
            this.limbo.remove(event.player.func_110124_au());
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            Optional<ItemStack> babyStack = player.field_71071_by.field_70462_a.stream().filter(s -> s.func_77973_b() instanceof ItemBaby).findFirst();
            babyStack.ifPresent(s -> this.limbo.put(player.func_110124_au(), (ItemStack)babyStack.get()));
        }
    }

    @SubscribeEvent
    public void onLivingSetTarget(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof EntityMob && event.getTarget() instanceof EntityVillagerMCA) {
            EntityMob mob = (EntityMob)event.getEntityLiving();
            EntityVillagerMCA target = (EntityVillagerMCA)event.getTarget();
            if (target.get(EntityVillagerMCA.IS_INFECTED).booleanValue()) {
                mob.func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public void onPlaySoundAtEntityEvent(PlaySoundAtEntityEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT) {
            return;
        }
        try {
            event.setCanceled(event.getSound().func_187503_a().toString().contains("villager"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

