/*
 * Decompiled with CFR 0.152.
 */
package mca.core.forge;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import mca.client.gui.GuiStaffOfLife;
import mca.client.gui.GuiWhistle;
import mca.client.network.ClientMessageQueue;
import mca.core.MCA;
import mca.core.minecraft.ProfessionsMCA;
import mca.entity.EntityVillagerMCA;
import mca.entity.data.SavedVillagers;
import mca.entity.inventory.InventoryMCA;
import mca.items.ItemBaby;
import mca.server.ServerMessageHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetMCA {
    public static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("mca");

    public static void registerMessages() {
        INSTANCE.registerMessage(ButtonActionHandler.class, ButtonAction.class, 0, Side.SERVER);
        INSTANCE.registerMessage(SayHandler.class, Say.class, 1, Side.CLIENT);
        INSTANCE.registerMessage(BabyNameHandler.class, BabyName.class, 2, Side.SERVER);
        INSTANCE.registerMessage(CareerResponseHandler.class, CareerResponse.class, 3, Side.CLIENT);
        INSTANCE.registerMessage(CareerRequestHandler.class, CareerRequest.class, 4, Side.SERVER);
        INSTANCE.registerMessage(InventoryRequestHandler.class, InventoryRequest.class, 5, Side.SERVER);
        INSTANCE.registerMessage(InventoryResponseHandler.class, InventoryResponse.class, 6, Side.CLIENT);
        INSTANCE.registerMessage(SavedVillagersRequestHandler.class, SavedVillagersRequest.class, 7, Side.SERVER);
        INSTANCE.registerMessage(SavedVillagersResponseHandler.class, SavedVillagersResponse.class, 8, Side.CLIENT);
        INSTANCE.registerMessage(ReviveVillagerHandler.class, ReviveVillager.class, 9, Side.SERVER);
        INSTANCE.registerMessage(SetNameHandler.class, SetName.class, 10, Side.SERVER);
        INSTANCE.registerMessage(SpawnParticlesHandler.class, SpawnParticles.class, 11, Side.CLIENT);
        INSTANCE.registerMessage(GetFamilyHandler.class, GetFamily.class, 12, Side.SERVER);
        INSTANCE.registerMessage(GetFamilyResponseHandler.class, GetFamilyResponse.class, 13, Side.CLIENT);
        INSTANCE.registerMessage(CallToPlayerHandler.class, CallToPlayer.class, 14, Side.SERVER);
        INSTANCE.registerMessage(SetTextureHandler.class, SetTexture.class, 15, Side.SERVER);
        INSTANCE.registerMessage(SetProfessionHandler.class, SetProfession.class, 16, Side.SERVER);
    }

    @SideOnly(value=Side.CLIENT)
    private static EntityPlayer getPlayerClient() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static class SetTextureHandler
    implements IMessageHandler<SetTexture, IMessage> {
        public IMessage onMessage(SetTexture message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Optional<Entity> entity = player.field_70170_p.field_72996_f.stream().filter(e -> e.func_110124_au().equals(message.targetUUID)).findFirst();
            entity.ifPresent(e -> ((EntityVillagerMCA)((Object)e)).set(EntityVillagerMCA.TEXTURE, message.texture));
            return null;
        }
    }

    public static class SetTexture
    implements IMessage {
        private UUID targetUUID;
        private String texture;

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.targetUUID.toString());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.texture);
        }

        public void fromBytes(ByteBuf buf) {
            this.targetUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.texture = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        @ConstructorProperties(value={"targetUUID", "texture"})
        public SetTexture(UUID targetUUID, String texture) {
            this.targetUUID = targetUUID;
            this.texture = texture;
        }

        public SetTexture() {
        }
    }

    public static class SetProfessionHandler
    implements IMessageHandler<SetProfession, IMessage> {
        public IMessage onMessage(SetProfession message, MessageContext ctx) {
            boolean isCareerSet = false;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Optional<Entity> entity = player.field_70170_p.field_72996_f.stream().filter(e -> e.func_110124_au().equals(message.targetUUID)).findFirst();
            if (entity.isPresent()) {
                block0: for (Map.Entry professionEntry : ProfessionsMCA.registry.getEntries()) {
                    List careers = (List)ObfuscationReflectionHelper.getPrivateValue(VillagerRegistry.VillagerProfession.class, professionEntry.getValue(), (int)3);
                    for (int i = 0; i < careers.size(); ++i) {
                        VillagerRegistry.VillagerCareer career = (VillagerRegistry.VillagerCareer)careers.get(i);
                        if (!career.getName().equals(message.profession)) continue;
                        EntityVillagerMCA villager = (EntityVillagerMCA)entity.get();
                        villager.setProfession((VillagerRegistry.VillagerProfession)professionEntry.getValue());
                        villager.setVanillaCareer(i);
                        player.func_145747_a((ITextComponent)new TextComponentString("Career set to " + message.profession));
                        isCareerSet = true;
                        continue block0;
                    }
                }
            } else {
                MCA.getLog().error("Entity not found on career set!: " + message.targetUUID.toString());
                return null;
            }
            if (!isCareerSet) {
                player.func_145747_a((ITextComponent)new TextComponentString("Career not found: " + message.profession));
            }
            return null;
        }
    }

    public static class SetProfession
    implements IMessage {
        private UUID targetUUID;
        private String profession;

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.targetUUID.toString());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.profession);
        }

        public void fromBytes(ByteBuf buf) {
            this.targetUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.profession = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        @ConstructorProperties(value={"targetUUID", "profession"})
        public SetProfession(UUID targetUUID, String profession) {
            this.targetUUID = targetUUID;
            this.profession = profession;
        }

        public SetProfession() {
        }
    }

    public static class CallToPlayerHandler
    implements IMessageHandler<CallToPlayer, IMessage> {
        public IMessage onMessage(CallToPlayer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Optional<Entity> entity = player.field_70170_p.field_72996_f.stream().filter(e -> e.func_110124_au().equals(message.targetUUID)).findFirst();
            entity.ifPresent(arg_0 -> CallToPlayerHandler.lambda$onMessage$1((EntityPlayer)player, arg_0));
            return null;
        }

        private static /* synthetic */ void lambda$onMessage$1(EntityPlayer player, Entity e) {
            e.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            ((EntityLiving)e).func_70661_as().func_75499_g();
        }
    }

    public static class CallToPlayer
    implements IMessage {
        private UUID targetUUID;

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.targetUUID.toString());
        }

        public void fromBytes(ByteBuf buf) {
            this.targetUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }

        @ConstructorProperties(value={"targetUUID"})
        public CallToPlayer(UUID targetUUID) {
            this.targetUUID = targetUUID;
        }

        public CallToPlayer() {
        }
    }

    public static class GetFamilyResponseHandler
    implements IMessageHandler<GetFamilyResponse, IMessage> {
        public IMessage onMessage(GetFamilyResponse message, MessageContext ctx) {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof GuiWhistle) {
                GuiWhistle whistleScreen = (GuiWhistle)screen;
                whistleScreen.setVillagerDataList(message.familyData);
            }
            return null;
        }
    }

    public static class GetFamilyResponse
    implements IMessage {
        private List<NBTTagCompound> familyData;

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.familyData.size());
            this.familyData.stream().forEach(n -> ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)n));
        }

        public void fromBytes(ByteBuf buf) {
            this.familyData = new ArrayList<NBTTagCompound>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.familyData.add(ByteBufUtils.readTag((ByteBuf)buf));
            }
        }

        @ConstructorProperties(value={"familyData"})
        public GetFamilyResponse(List<NBTTagCompound> familyData) {
            this.familyData = familyData;
        }

        public GetFamilyResponse() {
        }
    }

    public static class GetFamilyHandler
    implements IMessageHandler<GetFamily, IMessage> {
        public IMessage onMessage(GetFamily message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ArrayList villagers = new ArrayList();
            ArrayList<NBTTagCompound> familyData = new ArrayList<NBTTagCompound>();
            player.field_70170_p.field_72996_f.stream().filter(e -> e instanceof EntityVillagerMCA).forEach(e -> villagers.add((EntityVillagerMCA)((Object)e)));
            villagers.stream().filter(arg_0 -> GetFamilyHandler.lambda$onMessage$2((EntityPlayer)player, arg_0)).forEach(e -> {
                NBTTagCompound nbt = new NBTTagCompound();
                e.func_70014_b(nbt);
                familyData.add(nbt);
            });
            return new GetFamilyResponse(familyData);
        }

        private static /* synthetic */ boolean lambda$onMessage$2(EntityPlayer player, EntityVillagerMCA e) {
            return e.isMarriedTo(player.func_110124_au()) || e.playerIsParent(player);
        }
    }

    public static class GetFamily
    implements IMessage {
        public void toBytes(ByteBuf buf) {
        }

        public void fromBytes(ByteBuf buf) {
        }
    }

    public static class SpawnParticlesHandler
    implements IMessageHandler<SpawnParticles, IMessage> {
        public IMessage onMessage(SpawnParticles message, MessageContext ctx) {
            World world = NetMCA.getPlayerClient().field_70170_p;
            Optional<Entity> entity = world.field_72996_f.stream().filter(e -> e.func_110124_au().equals(message.entityUUID)).findFirst();
            if (!entity.isPresent()) {
                return null;
            }
            if (entity.get() instanceof EntityVillagerMCA) {
                EntityVillagerMCA villager = (EntityVillagerMCA)entity.get();
                villager.func_180489_a(message.particleType);
            }
            return null;
        }
    }

    public static class SpawnParticles
    implements IMessage {
        private UUID entityUUID;
        private EnumParticleTypes particleType;

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityUUID.toString());
            buf.writeInt(this.particleType.func_179348_c());
        }

        public void fromBytes(ByteBuf buf) {
            this.entityUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.particleType = EnumParticleTypes.func_179342_a((int)buf.readInt());
        }

        @ConstructorProperties(value={"entityUUID", "particleType"})
        public SpawnParticles(UUID entityUUID, EnumParticleTypes particleType) {
            this.entityUUID = entityUUID;
            this.particleType = particleType;
        }

        public SpawnParticles() {
        }
    }

    public static class SetNameHandler
    implements IMessageHandler<SetName, IMessage> {
        public IMessage onMessage(SetName message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            Optional<Entity> entity = world.field_72996_f.stream().filter(e -> e.func_110124_au().equals(message.entityUUID)).findFirst();
            if (!entity.isPresent()) {
                return null;
            }
            if (entity.get() instanceof EntityVillagerMCA) {
                EntityVillagerMCA villager = (EntityVillagerMCA)entity.get();
                villager.set(EntityVillagerMCA.VILLAGER_NAME, message.name);
            }
            return null;
        }
    }

    public static class SetName
    implements IMessage {
        private String name;
        private UUID entityUUID;

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityUUID.toString());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        }

        public void fromBytes(ByteBuf buf) {
            this.entityUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        @ConstructorProperties(value={"name", "entityUUID"})
        public SetName(String name, UUID entityUUID) {
            this.name = name;
            this.entityUUID = entityUUID;
        }

        public SetName() {
        }
    }

    public static class ReviveVillagerHandler
    implements IMessageHandler<ReviveVillager, IMessage> {
        public IMessage onMessage(ReviveVillager message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            SavedVillagers villagers = SavedVillagers.get(player.field_70170_p);
            NBTTagCompound nbt = SavedVillagers.get(player.field_70170_p).loadByUUID(message.target);
            if (nbt != null) {
                EntityVillagerMCA villager = new EntityVillagerMCA(player.field_70170_p);
                villager.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                player.field_70170_p.func_72838_d((Entity)villager);
                villager.func_70037_a(nbt);
                villager.reset();
                villagers.remove(message.target);
                ((ItemStack)player.field_71071_by.field_70462_a.get(player.field_71071_by.field_70461_c)).func_77972_a(1, (EntityLivingBase)player);
            }
            return null;
        }
    }

    public static class ReviveVillager
    implements IMessage {
        private UUID target;

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.target.toString());
        }

        public void fromBytes(ByteBuf buf) {
            this.target = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }

        @ConstructorProperties(value={"target"})
        public ReviveVillager(UUID target) {
            this.target = target;
        }

        public ReviveVillager() {
        }
    }

    public static class SavedVillagersResponseHandler
    implements IMessageHandler<SavedVillagersResponse, IMessage> {
        public IMessage onMessage(SavedVillagersResponse message, MessageContext ctx) {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof GuiStaffOfLife) {
                ((GuiStaffOfLife)screen).setVillagerData(message.villagers);
            }
            return null;
        }
    }

    public static class SavedVillagersResponse
    implements IMessage {
        private Map<String, NBTTagCompound> villagers = new HashMap<String, NBTTagCompound>();

        public SavedVillagersResponse(EntityPlayer player) {
            this.villagers = SavedVillagers.get(player.field_70170_p).getMap();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.villagers.size());
            this.villagers.forEach((k, v) -> {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)k);
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)v);
            });
        }

        public void fromBytes(ByteBuf buf) {
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                String k = ByteBufUtils.readUTF8String((ByteBuf)buf);
                NBTTagCompound v = ByteBufUtils.readTag((ByteBuf)buf);
                this.villagers.put(k, v);
            }
        }

        public SavedVillagersResponse() {
        }
    }

    public static class SavedVillagersRequestHandler
    implements IMessageHandler<SavedVillagersRequest, IMessage> {
        public IMessage onMessage(SavedVillagersRequest message, MessageContext ctx) {
            return new SavedVillagersResponse((EntityPlayer)ctx.getServerHandler().field_147369_b);
        }
    }

    public static class SavedVillagersRequest
    implements IMessage {
        public void fromBytes(ByteBuf buf) {
        }

        public void toBytes(ByteBuf buf) {
        }
    }

    public static class InventoryResponseHandler
    implements IMessageHandler<InventoryResponse, IMessage> {
        public IMessage onMessage(InventoryResponse message, MessageContext ctx) {
            ClientMessageQueue.add(message);
            return null;
        }
    }

    public static class InventoryResponse
    implements IMessage {
        private UUID entityUUID;
        private NBTTagCompound inventoryNBT;

        public InventoryResponse(UUID entityUUID, InventoryMCA inventory) {
            this.inventoryNBT = new NBTTagCompound();
            this.entityUUID = entityUUID;
            this.inventoryNBT.func_74782_a("inventory", (NBTBase)inventory.writeInventoryToNBT());
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityUUID.toString());
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.inventoryNBT);
        }

        public void fromBytes(ByteBuf buf) {
            this.entityUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.inventoryNBT = ByteBufUtils.readTag((ByteBuf)buf);
        }

        public InventoryResponse() {
        }

        public UUID getEntityUUID() {
            return this.entityUUID;
        }

        public NBTTagCompound getInventoryNBT() {
            return this.inventoryNBT;
        }
    }

    public static class InventoryRequestHandler
    implements IMessageHandler<InventoryRequest, IMessage> {
        public IMessage onMessage(InventoryRequest message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            EntityVillagerMCA villager = (EntityVillagerMCA)player.func_71121_q().func_175733_a(message.entityUUID);
            if (villager != null && villager.inventory != null) {
                return new InventoryResponse(villager.func_110124_au(), villager.inventory);
            }
            return null;
        }
    }

    public static class InventoryRequest
    implements IMessage {
        private UUID entityUUID;

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityUUID.toString());
        }

        public void fromBytes(ByteBuf buf) {
            this.entityUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }

        @ConstructorProperties(value={"entityUUID"})
        public InventoryRequest(UUID entityUUID) {
            this.entityUUID = entityUUID;
        }

        public InventoryRequest() {
        }
    }

    public static class CareerRequestHandler
    implements IMessageHandler<CareerRequest, IMessage> {
        public IMessage onMessage(CareerRequest message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            int careerId = -255;
            try {
                EntityVillagerMCA villager = (EntityVillagerMCA)player.func_71121_q().func_175733_a(message.entityUUID);
                if (villager != null) {
                    careerId = (Integer)ObfuscationReflectionHelper.getPrivateValue(EntityVillager.class, (Object)((Object)villager), (int)13);
                }
            }
            catch (ClassCastException ignored) {
                MCA.getLog().error("UUID provided in career request does not match an MCA villager!: " + message.entityUUID.toString());
                return null;
            }
            catch (NullPointerException ignored) {
                MCA.getLog().error("UUID provided in career request does not match a loaded MCA villager!: " + message.entityUUID.toString());
                return null;
            }
            if (careerId == -255) {
                MCA.getLog().error("Career ID wasn't assigned for UUID: " + message.entityUUID);
                return null;
            }
            return new CareerResponse(careerId, message.entityUUID);
        }
    }

    public static class CareerRequest
    implements IMessage {
        private UUID entityUUID;

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityUUID.toString());
        }

        public void fromBytes(ByteBuf buf) {
            this.entityUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }

        @ConstructorProperties(value={"entityUUID"})
        public CareerRequest(UUID entityUUID) {
            this.entityUUID = entityUUID;
        }

        public CareerRequest() {
        }
    }

    public static class CareerResponseHandler
    implements IMessageHandler<CareerResponse, IMessage> {
        public IMessage onMessage(CareerResponse message, MessageContext ctx) {
            ClientMessageQueue.add(message);
            return null;
        }
    }

    public static class CareerResponse
    implements IMessage {
        private int careerId;
        private UUID entityUUID;

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.careerId, (int)4);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityUUID.toString());
        }

        public void fromBytes(ByteBuf buf) {
            this.careerId = ByteBufUtils.readVarInt((ByteBuf)buf, (int)4);
            this.entityUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }

        @ConstructorProperties(value={"careerId", "entityUUID"})
        public CareerResponse(int careerId, UUID entityUUID) {
            this.careerId = careerId;
            this.entityUUID = entityUUID;
        }

        public CareerResponse() {
        }

        public int getCareerId() {
            return this.careerId;
        }

        public UUID getEntityUUID() {
            return this.entityUUID;
        }
    }

    public static class BabyNameHandler
    implements IMessageHandler<BabyName, IMessage> {
        public IMessage onMessage(BabyName message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack stack = player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c);
            if (stack.func_77973_b() instanceof ItemBaby) {
                stack.func_77978_p().func_74778_a("name", message.babyName);
            }
            return null;
        }
    }

    public static class BabyName
    implements IMessage {
        private String babyName;

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.babyName);
        }

        public void fromBytes(ByteBuf buf) {
            this.babyName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        @ConstructorProperties(value={"babyName"})
        public BabyName(String babyName) {
            this.babyName = babyName;
        }

        public BabyName() {
        }
    }

    public static class SayHandler
    implements IMessageHandler<Say, IMessage> {
        public IMessage onMessage(Say message, MessageContext ctx) {
            EntityPlayer player = NetMCA.getPlayerClient();
            EntityVillagerMCA villager = (EntityVillagerMCA)player.func_130014_f_().func_73045_a(message.speakingEntityId);
            if (villager != null) {
                villager.say((com.google.common.base.Optional<EntityPlayer>)com.google.common.base.Optional.of((Object)player), message.phraseId, new String[0]);
            }
            return null;
        }
    }

    public static class Say
    implements IMessage {
        private String phraseId;
        private int speakingEntityId;

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.phraseId);
            buf.writeInt(this.speakingEntityId);
        }

        public void fromBytes(ByteBuf buf) {
            this.phraseId = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.speakingEntityId = buf.readInt();
        }

        @ConstructorProperties(value={"phraseId", "speakingEntityId"})
        public Say(String phraseId, int speakingEntityId) {
            this.phraseId = phraseId;
            this.speakingEntityId = speakingEntityId;
        }

        public Say() {
        }
    }

    public static class ButtonActionHandler
    implements IMessageHandler<ButtonAction, IMessage> {
        public IMessage onMessage(ButtonAction message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (!message.targetsServer()) {
                EntityVillagerMCA villager = (EntityVillagerMCA)player.func_71121_q().func_175733_a(message.targetUUID);
                if (villager != null) {
                    player.func_71121_q().func_152344_a(() -> villager.handleButtonClick(player, message.guiKey, message.buttonId));
                }
            } else {
                ServerMessageHandler.handleMessage(player, message);
            }
            return null;
        }
    }

    public static class ButtonAction
    implements IMessage {
        private String guiKey;
        private String buttonId;
        private UUID targetUUID;

        public void toBytes(ByteBuf buf) {
            buf.writeBoolean(this.targetUUID != null);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.guiKey);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.buttonId);
            if (this.targetUUID != null) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.targetUUID.toString());
            }
        }

        public void fromBytes(ByteBuf buf) {
            boolean hasTarget = buf.readBoolean();
            this.guiKey = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.buttonId = ByteBufUtils.readUTF8String((ByteBuf)buf);
            if (hasTarget) {
                this.targetUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
        }

        public boolean targetsServer() {
            return this.getTargetUUID() == null;
        }

        @ConstructorProperties(value={"guiKey", "buttonId", "targetUUID"})
        public ButtonAction(String guiKey, String buttonId, UUID targetUUID) {
            this.guiKey = guiKey;
            this.buttonId = buttonId;
            this.targetUUID = targetUUID;
        }

        public ButtonAction() {
        }

        public String getGuiKey() {
            return this.guiKey;
        }

        public String getButtonId() {
            return this.buttonId;
        }

        public UUID getTargetUUID() {
            return this.targetUUID;
        }
    }
}

