/*
 * Decompiled with CFR 0.152.
 */
package mca.core.minecraft;

import java.util.Random;
import mca.util.ItemStackCache;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="mca")
public class ProfessionsMCA {
    public static final VillagerRegistry.VillagerProfession guard = new VillagerRegistry.VillagerProfession("mca:guard", "minecraft:textures/entity/villager/villager.png", "minecraft:textures/entity/zombie_villager/zombie_villager.png");
    public static final VillagerRegistry.VillagerProfession bandit = new VillagerRegistry.VillagerProfession("mca:bandit", "minecraft:textures/entity/villager/villager.png", "minecraft:textures/entity/zombie_villager/zombie_villager.png");
    public static final VillagerRegistry.VillagerProfession child = new VillagerRegistry.VillagerProfession("mca:child", "minecraft:textures/entity/villager/villager.png", "minecraft:textures/entity/zombie_villager/zombie_villager.png");
    public static final VillagerRegistry.VillagerProfession baker = new VillagerRegistry.VillagerProfession("mca:baker", "minecraft:textures/entity/villager/farmer.png", "minecraft:textures/entity/zombie_villager/zombie_farmer.png");
    public static final VillagerRegistry.VillagerProfession miner = new VillagerRegistry.VillagerProfession("mca:miner", "minecraft:textures/entity/villager/smith.png", "minecraft:textures/entity/zombie_villager/zombie_smith.png");
    public static VillagerRegistry.VillagerCareer guard_warrior;
    public static VillagerRegistry.VillagerCareer guard_archer;
    public static VillagerRegistry.VillagerCareer guard_hero;
    public static VillagerRegistry.VillagerCareer bandit_marauder;
    public static VillagerRegistry.VillagerCareer bandit_outlaw;
    public static VillagerRegistry.VillagerCareer bandit_pillager;
    public static VillagerRegistry.VillagerCareer child_child;
    public static VillagerRegistry.VillagerCareer baker_baker;
    public static VillagerRegistry.VillagerCareer miner_miner;
    public static IForgeRegistry<VillagerRegistry.VillagerProfession> registry;
    private static final VillagerRegistry.VillagerProfession[] FORBIDDEN_RANDOM_PROFESSIONS;

    public static void registerCareers() {
        guard_warrior = new VillagerRegistry.VillagerCareer(guard, "warrior");
        guard_archer = new VillagerRegistry.VillagerCareer(guard, "archer");
        guard_hero = new VillagerRegistry.VillagerCareer(guard, "hero");
        bandit_marauder = new VillagerRegistry.VillagerCareer(bandit, "marauder");
        bandit_outlaw = new VillagerRegistry.VillagerCareer(bandit, "outlaw");
        bandit_pillager = new VillagerRegistry.VillagerCareer(bandit, "pillager");
        child_child = new VillagerRegistry.VillagerCareer(child, "child");
        baker_baker = new VillagerRegistry.VillagerCareer(baker, "baker");
        miner_miner = new VillagerRegistry.VillagerCareer(miner, "miner");
        baker_baker.addTrade(1, new EntityVillager.ITradeList[]{new BakerTradesLvl1()});
        baker_baker.addTrade(2, new EntityVillager.ITradeList[]{new BakerTradesLvl2()});
        baker_baker.addTrade(3, new EntityVillager.ITradeList[]{new BakerTradesLvl3()});
        miner_miner.addTrade(1, new EntityVillager.ITradeList[]{new MinerTradesLvl1()});
        miner_miner.addTrade(2, new EntityVillager.ITradeList[]{new MinerTradesLvl2()});
        miner_miner.addTrade(3, new EntityVillager.ITradeList[]{new MinerTradesLvl3()});
    }

    public static ItemStack getDefaultHeldItem(VillagerRegistry.VillagerProfession profession, VillagerRegistry.VillagerCareer career) {
        if (profession == guard) {
            return career == guard_archer ? ItemStackCache.get((Item)Items.field_151031_f) : ItemStackCache.get(Items.field_151040_l);
        }
        if (profession == bandit) {
            return ItemStackCache.get(Items.field_151040_l);
        }
        return ItemStack.field_190927_a;
    }

    public static VillagerRegistry.VillagerProfession randomProfession() {
        ResourceLocation resource = null;
        while (resource == null || resource.func_110623_a().contains("nitwit") || ProfessionsMCA.inForbiddenProfessions((VillagerRegistry.VillagerProfession)registry.getValue(resource))) {
            int i = new Random().nextInt(registry.getKeys().size() - 1);
            resource = (ResourceLocation)registry.getKeys().toArray()[i];
        }
        return (VillagerRegistry.VillagerProfession)registry.getValue(resource);
    }

    private static boolean inForbiddenProfessions(VillagerRegistry.VillagerProfession profIn) {
        for (VillagerRegistry.VillagerProfession profession : FORBIDDEN_RANDOM_PROFESSIONS) {
            if (profession != profIn) continue;
            return true;
        }
        return false;
    }

    static {
        FORBIDDEN_RANDOM_PROFESSIONS = new VillagerRegistry.VillagerProfession[]{bandit, child};
    }

    public static class MinerTradesLvl3
    implements EntityVillager.ITradeList {
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 4), new ItemStack(Items.field_151035_b, 1)));
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Blocks.field_150475_bE, 1), new ItemStack(Items.field_151046_w, 1)));
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151042_j, 8), new ItemStack(Items.field_151045_i, 1)));
        }
    }

    public static class MinerTradesLvl2
    implements EntityVillager.ITradeList {
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151043_k, 3), new ItemStack(Items.field_151166_bC, 2)));
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1), new ItemStack(Items.field_151044_h, 3)));
        }
    }

    public static class MinerTradesLvl1
    implements EntityVillager.ITradeList {
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Blocks.field_150347_e, 8), new ItemStack(Blocks.field_150348_b, 4)));
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1), new ItemStack(Blocks.field_150478_aa, 8)));
        }
    }

    public static class BakerTradesLvl3
    implements EntityVillager.ITradeList {
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151105_aU, 1), new ItemStack(Items.field_151166_bC, 5)));
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 2), new ItemStack(Items.field_151025_P, 4)));
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 3), new ItemStack(Items.field_151106_aX, 6)));
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Blocks.field_150423_aK, 1), new ItemStack(Items.field_151158_bO, 1)));
        }
    }

    public static class BakerTradesLvl2
    implements EntityVillager.ITradeList {
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 2), new ItemStack(Items.field_151110_aK, 12)));
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151102_aT, 2), new ItemStack(Items.field_151105_aU, 1)));
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151018_J, 1), new ItemStack(Items.field_151015_O, 10)));
        }
    }

    public static class BakerTradesLvl1
    implements EntityVillager.ITradeList {
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1), new ItemStack(Items.field_151015_O, 6)));
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151117_aB, 1), new ItemStack(Items.field_151025_P, 2)));
        }
    }

    @Mod.EventBusSubscriber(modid="mca")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void onEvent(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
            registry = event.getRegistry();
            registry.register((IForgeRegistryEntry)guard);
            registry.register((IForgeRegistryEntry)bandit);
            registry.register((IForgeRegistryEntry)child);
            registry.register((IForgeRegistryEntry)baker);
            registry.register((IForgeRegistryEntry)miner);
        }
    }
}

