/*
 * Decompiled with CFR 0.152.
 */
package mca.core.minecraft;

import com.google.common.base.Optional;
import java.util.List;
import mca.core.MCA;
import mca.core.minecraft.ProfessionsMCA;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumGender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class VillageHelper {
    public static void tick(World world) {
        world.func_175714_ae().func_75540_b().forEach(v -> VillageHelper.spawnGuards(world, v));
    }

    public static void forceSpawnGuards(EntityPlayerMP player) {
        Village nearestVillage = player.field_70170_p.func_175714_ae().func_176056_a(player.func_180425_c(), 100);
        VillageHelper.spawnGuards(player.field_70170_p, nearestVillage);
    }

    public static void forceRaid(EntityPlayerMP player) {
        Village nearestVillage = player.field_70170_p.func_175714_ae().func_176056_a(player.func_180425_c(), 100);
        VillageHelper.startRaid(player.field_70170_p, nearestVillage);
    }

    private static void spawnGuards(World world, Village village) {
        Vec3d spawnPos;
        int guardCapacity = village.func_75562_e() / MCA.getConfig().guardSpawnRate;
        int guards = 0;
        List list = world.func_72872_a(EntityVillagerMCA.class, new AxisAlignedBB((double)(village.func_180608_a().func_177958_n() - village.func_75568_b()), (double)(village.func_180608_a().func_177956_o() - 4), (double)(village.func_180608_a().func_177952_p() - village.func_75568_b()), (double)(village.func_180608_a().func_177958_n() + village.func_75568_b()), (double)(village.func_180608_a().func_177956_o() + 4), (double)(village.func_180608_a().func_177952_p() + village.func_75568_b())));
        for (EntityVillagerMCA villager : list) {
            if (!villager.getProfessionForge().getRegistryName().equals((Object)ProfessionsMCA.guard.getRegistryName())) continue;
            ++guards;
        }
        if (guards < guardCapacity && guards < 10 && (spawnPos = VillageHelper.findRandomSpawnPos(world, village, village.func_180608_a(), 2, 4, 2)) != null) {
            EntityVillagerMCA guard = new EntityVillagerMCA(world, (Optional<VillagerRegistry.VillagerProfession>)Optional.of((Object)ProfessionsMCA.guard), (Optional<EnumGender>)Optional.absent());
            guard.func_70107_b(spawnPos.field_72450_a + 0.5, spawnPos.field_72448_b + 1.0, spawnPos.field_72449_c + 0.5);
            guard.func_190672_a(world.func_175649_E(guard.func_190671_u_()), null, false);
            world.func_72838_d((Entity)guard);
        }
    }

    private static void startRaid(World world, Village village) {
        for (int banditsToSpawn = world.field_73012_v.nextInt(5) + 1; banditsToSpawn > 0; --banditsToSpawn) {
            EntityVillagerMCA bandit = new EntityVillagerMCA(world, (Optional<VillagerRegistry.VillagerProfession>)Optional.of((Object)ProfessionsMCA.bandit), (Optional<EnumGender>)Optional.absent());
            BlockPos spawnLocation = village.func_180608_a();
            bandit.func_70107_b(spawnLocation.func_177958_n(), spawnLocation.func_177956_o(), spawnLocation.func_177952_p());
            world.func_72838_d((Entity)bandit);
        }
    }

    private static Vec3d findRandomSpawnPos(World world, Village village, BlockPos pos, int x, int y, int z) {
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos = pos.func_177982_a(world.field_73012_v.nextInt(16) - 8, world.field_73012_v.nextInt(6) - 3, world.field_73012_v.nextInt(16) - 8);
            if (!village.func_179866_a(blockpos) || !VillageHelper.isAreaClearAround(world, new BlockPos(x, y, z), blockpos)) continue;
            return new Vec3d((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
        }
        return null;
    }

    private static boolean isAreaClearAround(World world, BlockPos blockSize, BlockPos blockLocation) {
        if (!world.func_180495_p(blockLocation.func_177977_b()).func_185896_q()) {
            return false;
        }
        int i = blockLocation.func_177958_n() - blockSize.func_177958_n() / 2;
        int j = blockLocation.func_177952_p() - blockSize.func_177952_p() / 2;
        for (int k = i; k < i + blockSize.func_177958_n(); ++k) {
            for (int l = blockLocation.func_177956_o(); l < blockLocation.func_177956_o() + blockSize.func_177956_o(); ++l) {
                for (int i1 = j; i1 < j + blockSize.func_177952_p(); ++i1) {
                    if (!world.func_180495_p(new BlockPos(k, l, i1)).func_185915_l()) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

