/*
 * Decompiled with CFR 0.152.
 */
package mca.entity;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import mca.api.API;
import mca.api.types.APIButton;
import mca.core.Constants;
import mca.core.MCA;
import mca.core.forge.NetMCA;
import mca.core.minecraft.ItemsMCA;
import mca.core.minecraft.ProfessionsMCA;
import mca.entity.ai.EntityAIAgeBaby;
import mca.entity.ai.EntityAIChopping;
import mca.entity.ai.EntityAIFishing;
import mca.entity.ai.EntityAIHarvesting;
import mca.entity.ai.EntityAIHunting;
import mca.entity.ai.EntityAIMoveState;
import mca.entity.ai.EntityAIProcreate;
import mca.entity.ai.EntityAIProspecting;
import mca.entity.ai.EntityAIVerifyBed;
import mca.entity.data.ParentData;
import mca.entity.data.PlayerHistory;
import mca.entity.data.PlayerSaveData;
import mca.entity.data.SavedVillagers;
import mca.entity.inventory.InventoryMCA;
import mca.enums.EnumAgeState;
import mca.enums.EnumChore;
import mca.enums.EnumConstraint;
import mca.enums.EnumDialogueType;
import mca.enums.EnumGender;
import mca.enums.EnumMarriageState;
import mca.enums.EnumMoveState;
import mca.items.ItemSpecialCaseGift;
import mca.util.ItemStackCache;
import mca.util.ResourceLocationCache;
import mca.util.Util;
import net.minecraft.block.BlockBed;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class EntityVillagerMCA
extends EntityVillager {
    public static final int VANILLA_CAREER_ID_FIELD_INDEX = 13;
    public static final int VANILLA_CAREER_LEVEL_FIELD_INDEX = 14;
    public static final DataParameter<String> VILLAGER_NAME = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<String> TEXTURE = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Integer> GENDER = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> GIRTH = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Float> TALLNESS = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<NBTTagCompound> PLAYER_HISTORY_MAP = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_192734_n);
    public static final DataParameter<Integer> MOVE_STATE = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<String> SPOUSE_NAME = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<com.google.common.base.Optional<UUID>> SPOUSE_UUID = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187203_m);
    public static final DataParameter<Integer> MARRIAGE_STATE = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> IS_PROCREATING = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<NBTTagCompound> PARENTS = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_192734_n);
    public static final DataParameter<Boolean> IS_INFECTED = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> AGE_STATE = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> ACTIVE_CHORE = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> IS_SWINGING = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> HAS_BABY = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> BABY_IS_MALE = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> BABY_AGE = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<com.google.common.base.Optional<UUID>> CHORE_ASSIGNING_PLAYER = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187203_m);
    public static final DataParameter<BlockPos> BED_POS = EntityDataManager.func_187226_a(EntityVillagerMCA.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final Predicate<EntityVillagerMCA> BANDIT_TARGET_SELECTOR = v -> v.getProfessionForge() != ProfessionsMCA.bandit && v.getProfessionForge() != ProfessionsMCA.child;
    private static final Predicate<EntityVillagerMCA> GUARD_TARGET_SELECTOR = v -> v.getProfessionForge() == ProfessionsMCA.bandit;
    public final InventoryMCA inventory;
    public int babyAge = 0;
    public UUID playerToFollowUUID = Constants.ZERO_UUID;
    private BlockPos home = BlockPos.field_177992_a;
    private int startingAge = 0;
    private float swingProgressTicks;

    public EntityVillagerMCA() {
        super(null);
        this.inventory = null;
    }

    public EntityVillagerMCA(World worldIn) {
        super(worldIn);
        this.inventory = new InventoryMCA(this);
    }

    public EntityVillagerMCA(World worldIn, com.google.common.base.Optional<VillagerRegistry.VillagerProfession> profession, com.google.common.base.Optional<EnumGender> gender) {
        this(worldIn);
        if (!worldIn.field_72995_K) {
            EnumGender eGender = gender.isPresent() ? (EnumGender)((Object)gender.get()) : EnumGender.getRandom();
            this.set(GENDER, eGender.getId());
            this.set(VILLAGER_NAME, API.getRandomName(eGender));
            this.setProfession(profession.isPresent() ? (VillagerRegistry.VillagerProfession)profession.get() : ProfessionsMCA.randomProfession());
            this.setVanillaCareer(this.getProfessionForge().getRandomCareer(worldIn.field_73012_v));
            this.set(TEXTURE, API.getRandomSkin(this));
            this.applySpecialAI();
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VILLAGER_NAME, (Object)"");
        this.field_70180_af.func_187214_a(TEXTURE, (Object)"");
        this.field_70180_af.func_187214_a(GENDER, (Object)EnumGender.MALE.getId());
        this.field_70180_af.func_187214_a(GIRTH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(TALLNESS, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PLAYER_HISTORY_MAP, (Object)new NBTTagCompound());
        this.field_70180_af.func_187214_a(MOVE_STATE, (Object)EnumMoveState.MOVE.getId());
        this.field_70180_af.func_187214_a(SPOUSE_NAME, (Object)"");
        this.field_70180_af.func_187214_a(SPOUSE_UUID, (Object)com.google.common.base.Optional.of((Object)Constants.ZERO_UUID));
        this.field_70180_af.func_187214_a(MARRIAGE_STATE, (Object)EnumMarriageState.NOT_MARRIED.getId());
        this.field_70180_af.func_187214_a(IS_PROCREATING, (Object)false);
        this.field_70180_af.func_187214_a(PARENTS, (Object)new NBTTagCompound());
        this.field_70180_af.func_187214_a(IS_INFECTED, (Object)false);
        this.field_70180_af.func_187214_a(AGE_STATE, (Object)EnumAgeState.ADULT.getId());
        this.field_70180_af.func_187214_a(ACTIVE_CHORE, (Object)EnumChore.NONE.getId());
        this.field_70180_af.func_187214_a(IS_SWINGING, (Object)false);
        this.field_70180_af.func_187214_a(HAS_BABY, (Object)false);
        this.field_70180_af.func_187214_a(BABY_IS_MALE, (Object)false);
        this.field_70180_af.func_187214_a(BABY_AGE, (Object)0);
        this.field_70180_af.func_187214_a(CHORE_ASSIGNING_PLAYER, (Object)com.google.common.base.Optional.of((Object)Constants.ZERO_UUID));
        this.field_70180_af.func_187214_a(BED_POS, (Object)BlockPos.field_177992_a);
        this.func_174810_b(false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)MCA.getConfig().villagerMaxHealth);
        if (this.func_110143_aJ() <= (float)MCA.getConfig().villagerMaxHealth) {
            this.func_70606_j(MCA.getConfig().villagerMaxHealth);
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIProspecting(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIHunting(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIChopping(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIHarvesting(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIFishing(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIMoveState(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAgeBaby(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIProcreate(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIVerifyBed(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public <T> T get(DataParameter<T> key) {
        return (T)this.field_70180_af.func_187225_a(key);
    }

    public <T> void set(DataParameter<T> key, T value) {
        this.field_70180_af.func_187227_b(key, value);
    }

    public boolean func_70652_k(@Nonnull Entity entityIn) {
        super.func_70652_k(entityIn);
        return entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.getProfessionForge() == ProfessionsMCA.guard ? 9.0f : 2.0f);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.set(VILLAGER_NAME, nbt.func_74779_i("name"));
        this.set(GENDER, nbt.func_74762_e("gender"));
        this.set(TEXTURE, nbt.func_74779_i("texture"));
        this.set(GIRTH, Float.valueOf(nbt.func_74760_g("girth")));
        this.set(TALLNESS, Float.valueOf(nbt.func_74760_g("tallness")));
        this.set(PLAYER_HISTORY_MAP, nbt.func_74775_l("playerHistoryMap"));
        this.set(MOVE_STATE, nbt.func_74762_e("moveState"));
        this.set(MARRIAGE_STATE, nbt.func_74762_e("marriageState"));
        this.set(SPOUSE_UUID, com.google.common.base.Optional.of((Object)nbt.func_186857_a("spouseUUID")));
        this.set(SPOUSE_NAME, nbt.func_74779_i("spouseName"));
        this.set(IS_PROCREATING, nbt.func_74767_n("isProcreating"));
        this.set(IS_INFECTED, nbt.func_74767_n("infected"));
        this.set(AGE_STATE, nbt.func_74762_e("ageState"));
        this.set(ACTIVE_CHORE, nbt.func_74762_e("activeChore"));
        this.set(CHORE_ASSIGNING_PLAYER, com.google.common.base.Optional.of((Object)nbt.func_186857_a("choreAssigningPlayer")));
        this.set(HAS_BABY, nbt.func_74767_n("hasBaby"));
        this.set(BABY_IS_MALE, nbt.func_74767_n("babyIsMale"));
        this.set(PARENTS, nbt.func_74775_l("parents"));
        this.set(BED_POS, new BlockPos(nbt.func_74762_e("bedX"), nbt.func_74762_e("bedY"), nbt.func_74762_e("bedZ")));
        this.inventory.readInventoryFromNBT(nbt.func_150295_c("inventory", 10));
        this.startingAge = nbt.func_74762_e("startingAge");
        this.func_70873_a(nbt.func_74762_e("Age"));
        this.home = new BlockPos(nbt.func_74769_h("homePositionX"), nbt.func_74769_h("homePositionY"), nbt.func_74769_h("homePositionZ"));
        this.playerToFollowUUID = nbt.func_186857_a("playerToFollowUUID");
        this.babyAge = nbt.func_74762_e("babyAge");
        this.applySpecialAI();
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_186854_a("uuid", this.func_110124_au());
        nbt.func_74778_a("name", this.get(VILLAGER_NAME));
        nbt.func_74778_a("texture", this.get(TEXTURE));
        nbt.func_74768_a("gender", this.get(GENDER).intValue());
        nbt.func_74776_a("girth", this.get(GIRTH).floatValue());
        nbt.func_74776_a("tallness", this.get(TALLNESS).floatValue());
        nbt.func_74782_a("playerHistoryMap", (NBTBase)this.get(PLAYER_HISTORY_MAP));
        nbt.func_74768_a("moveState", this.get(MOVE_STATE).intValue());
        nbt.func_74768_a("marriageState", this.get(MARRIAGE_STATE).intValue());
        nbt.func_74780_a("homePositionX", (double)this.home.func_177958_n());
        nbt.func_74780_a("homePositionY", (double)this.home.func_177956_o());
        nbt.func_74780_a("homePositionZ", (double)this.home.func_177952_p());
        nbt.func_186854_a("playerToFollowUUID", this.playerToFollowUUID);
        nbt.func_186854_a("spouseUUID", (UUID)this.get(SPOUSE_UUID).or((Object)Constants.ZERO_UUID));
        nbt.func_74778_a("spouseName", this.get(SPOUSE_NAME));
        nbt.func_74757_a("isProcreating", this.get(IS_PROCREATING).booleanValue());
        nbt.func_74757_a("infected", this.get(IS_INFECTED).booleanValue());
        nbt.func_74768_a("ageState", this.get(AGE_STATE).intValue());
        nbt.func_74768_a("startingAge", this.startingAge);
        nbt.func_74768_a("activeChore", this.get(ACTIVE_CHORE).intValue());
        nbt.func_186854_a("choreAssigningPlayer", (UUID)this.get(CHORE_ASSIGNING_PLAYER).or((Object)Constants.ZERO_UUID));
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.writeInventoryToNBT());
        nbt.func_74768_a("babyAge", this.babyAge);
        nbt.func_74782_a("parents", (NBTBase)this.get(PARENTS));
        nbt.func_74768_a("bedX", this.get(BED_POS).func_177958_n());
        nbt.func_74768_a("bedY", this.get(BED_POS).func_177956_o());
        nbt.func_74768_a("bedZ", this.get(BED_POS).func_177952_p());
    }

    protected void func_70665_d(@Nonnull DamageSource damageSource, float damageAmount) {
        if (this.getProfessionForge() == ProfessionsMCA.guard) {
            damageAmount = (float)((double)damageAmount * 0.7);
        }
        super.func_70665_d(damageSource, damageAmount);
        if (MCA.getConfig().enableInfection && this.getProfessionForge() != ProfessionsMCA.guard && damageSource.func_76364_f() instanceof EntityZombie && this.func_70681_au().nextFloat() < (float)(MCA.getConfig().infectionChance / 100)) {
            this.set(IS_INFECTED, true);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateSwinging();
        if (this.func_70613_aW()) {
            this.onEachServerUpdate();
        } else {
            this.onEachClientUpdate();
        }
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187543_bD;
    }

    protected SoundEvent func_184615_bR() {
        return this.get(IS_INFECTED) != false ? SoundEvents.field_187930_hd : null;
    }

    public boolean func_184645_a(EntityPlayer player, @Nonnull EnumHand hand) {
        return true;
    }

    public void func_70645_a(@Nonnull DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            if (MCA.getConfig().logVillagerDeaths) {
                String causeName = cause.func_76364_f() == null ? "Unknown" : cause.func_76364_f().func_70005_c_();
                MCA.getLog().info("Villager death: " + this.get(VILLAGER_NAME) + ". Caused by: " + causeName + ". UUID: " + this.func_110124_au().toString());
            }
            this.inventory.dropAllItems();
            if (this.isMarried()) {
                UUID spouseUUID = (UUID)this.get(SPOUSE_UUID).or((Object)Constants.ZERO_UUID);
                com.google.common.base.Optional<EntityVillagerMCA> spouse = Util.getEntityByUUID(this.field_70170_p, spouseUUID, EntityVillagerMCA.class);
                PlayerSaveData playerSaveData = PlayerSaveData.getExisting(this.field_70170_p, spouseUUID);
                if (spouse.isPresent()) {
                    ((EntityVillagerMCA)((Object)spouse.get())).endMarriage();
                } else if (playerSaveData != null) {
                    playerSaveData.endMarriage();
                    EntityPlayer player = this.field_70170_p.func_152378_a(spouseUUID);
                    if (player != null) {
                        player.func_145747_a((ITextComponent)new TextComponentString("\u00a7C" + MCA.getLocalizer().localize("notify.spousedied", this.get(VILLAGER_NAME), cause.func_76364_f().func_70005_c_())));
                    }
                }
            }
            ParentData parents = ParentData.fromNBT(this.get(PARENTS));
            Arrays.stream(parents.getParentEntities(this.field_70170_p)).filter(e -> e instanceof EntityPlayer).forEach(e -> {
                EntityPlayer player = (EntityPlayer)e;
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7C" + MCA.getLocalizer().localize("notify.childdied", this.get(VILLAGER_NAME), cause.func_76364_f().func_70005_c_())));
            });
            SavedVillagers.get(this.field_70170_p).save(this);
        }
    }

    protected void func_175500_n() {
        Entity[] parents = ParentData.fromNBT(this.get(PARENTS)).getParentEntities(this.field_70170_p);
        this.set(AGE_STATE, EnumAgeState.ADULT.getId());
        Arrays.stream(parents).filter(e -> e instanceof EntityPlayer).forEach(e -> {
            PlayerHistory history = this.getPlayerHistoryFor(e.func_110124_au());
            history.setDialogueType(EnumDialogueType.ADULT);
            e.func_145747_a((ITextComponent)new TextComponentString(MCA.getLocalizer().localize("notify.child.grownup", this.get(VILLAGER_NAME))));
        });
        if (this.getProfessionForge() == ProfessionsMCA.child) {
            this.setProfession(ProfessionsMCA.randomProfession());
            this.setVanillaCareer(this.getProfessionForge().getRandomCareer(this.field_70170_p.field_73012_v));
        }
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        String professionName;
        TextComponentTranslation careerName = new TextComponentTranslation("entity.Villager." + this.getVanillaCareer().getName(), new Object[0]);
        EnumAgeState age = EnumAgeState.byId(this.get(AGE_STATE));
        String string = professionName = age != EnumAgeState.ADULT ? age.localizedName() : careerName.func_150260_c();
        String color = this.getProfessionForge() == ProfessionsMCA.bandit ? "\u00a7C" : (this.getProfessionForge() == ProfessionsMCA.guard ? "\u00a7A" : "");
        return new TextComponentString(String.format("%1$s%2$s%3$s (%4$s)", color, MCA.getConfig().villagerChatPrefix, this.get(VILLAGER_NAME), professionName));
    }

    public void func_184609_a(EnumHand hand) {
        this.func_184598_c(EnumHand.MAIN_HAND);
        super.func_184609_a(EnumHand.MAIN_HAND);
        if (!this.get(IS_SWINGING).booleanValue() || this.swingProgressTicks >= 4.0f || this.swingProgressTicks < 0.0f) {
            this.swingProgressTicks = -1.0f;
            this.set(IS_SWINGING, true);
        }
    }

    private void updateSwinging() {
        if (this.get(IS_SWINGING).booleanValue()) {
            this.swingProgressTicks += 1.0f;
            if (this.swingProgressTicks >= 8.0f) {
                this.swingProgressTicks = 0.0f;
                this.set(IS_SWINGING, false);
            }
        } else {
            this.swingProgressTicks = 0.0f;
        }
        this.field_70733_aJ = this.swingProgressTicks / 8.0f;
    }

    @Nonnull
    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        if (slotIn == EntityEquipmentSlot.MAINHAND) {
            VillagerRegistry.VillagerProfession profession = this.getProfessionForge();
            EnumChore chore = EnumChore.byId(this.get(ACTIVE_CHORE));
            if (this.get(HAS_BABY).booleanValue()) {
                return ItemStackCache.get(this.get(BABY_IS_MALE) != false ? ItemsMCA.BABY_BOY : ItemsMCA.BABY_GIRL);
            }
            if (chore != EnumChore.NONE) {
                return this.inventory.getBestItemOfType(chore.getToolType());
            }
            return ProfessionsMCA.getDefaultHeldItem(profession, this.getVanillaCareer());
        }
        return this.inventory.getBestArmorOfType(slotIn);
    }

    public void setStartingAge(int value) {
        this.startingAge = value;
        this.func_70873_a(value);
    }

    public PlayerHistory getPlayerHistoryFor(UUID uuid) {
        if (!this.get(PLAYER_HISTORY_MAP).func_74764_b(uuid.toString())) {
            this.updatePlayerHistoryMap(PlayerHistory.getNew(this, uuid));
        }
        return PlayerHistory.fromNBT(this, uuid, this.get(PLAYER_HISTORY_MAP).func_74775_l(uuid.toString()));
    }

    public void updatePlayerHistoryMap(PlayerHistory history) {
        NBTTagCompound nbt = this.get(PLAYER_HISTORY_MAP);
        nbt.func_74782_a(history.getPlayerUUID().toString(), (NBTBase)history.toNBT());
        this.set(PLAYER_HISTORY_MAP, nbt);
        this.field_70180_af.func_187217_b(PLAYER_HISTORY_MAP);
    }

    public void reset() {
        this.set(PLAYER_HISTORY_MAP, new NBTTagCompound());
        this.field_70180_af.func_187217_b(PLAYER_HISTORY_MAP);
        this.func_70606_j(20.0f);
        this.set(SPOUSE_NAME, "");
        this.set(SPOUSE_UUID, com.google.common.base.Optional.of((Object)Constants.ZERO_UUID));
        this.set(MARRIAGE_STATE, EnumMarriageState.NOT_MARRIED.getId());
        this.set(HAS_BABY, false);
    }

    public VillagerRegistry.VillagerCareer getVanillaCareer() {
        return this.getProfessionForge().getCareer(((Integer)ObfuscationReflectionHelper.getPrivateValue(EntityVillager.class, (Object)((Object)this), (int)13)).intValue());
    }

    public void setVanillaCareer(int careerId) {
        ObfuscationReflectionHelper.setPrivateValue(EntityVillager.class, (Object)((Object)this), (Object)careerId, (int)13);
    }

    private void setSizeForAge() {
        EnumAgeState age = EnumAgeState.byId(this.get(AGE_STATE));
        this.func_70105_a(age.getWidth(), age.getHeight());
        this.func_98055_j(1.0f);
    }

    private void toggleMount(EntityPlayerMP player) {
        if (this.func_184187_bx() != null) {
            this.func_184210_p();
        } else {
            try {
                List horses = this.field_70170_p.func_175644_a(EntityHorse.class, h -> h.func_110257_ck() && !h.func_184207_aI() && (double)h.func_70032_d((Entity)this) < 3.0);
                this.func_184205_a((Entity)horses.stream().min(Comparator.comparingDouble(arg_0 -> ((EntityVillagerMCA)this).func_70032_d(arg_0))).get(), true);
                this.func_70661_as().func_75499_g();
            }
            catch (NoSuchElementException e) {
                this.say((com.google.common.base.Optional<EntityPlayer>)com.google.common.base.Optional.of((Object)player), "interaction.ridehorse.fail.notnearby", new String[0]);
            }
        }
    }

    private void goHome(EntityPlayerMP player) {
        if (this.home.equals((Object)Vec3d.field_186680_a)) {
            this.say((com.google.common.base.Optional<EntityPlayer>)com.google.common.base.Optional.of((Object)player), "interaction.gohome.fail", new String[0]);
        } else {
            this.say((com.google.common.base.Optional<EntityPlayer>)com.google.common.base.Optional.of((Object)player), "interaction.gohome.success", new String[0]);
            if (!this.func_70661_as().func_75484_a(this.func_70661_as().func_75488_a((double)this.home.func_177958_n(), (double)this.home.func_177956_o(), (double)this.home.func_177952_p()), 1.0)) {
                this.func_184595_k(this.home.func_177958_n(), this.home.func_177956_o(), this.home.func_177952_p());
            }
        }
    }

    public void forcePositionAsHome() {
        this.home = this.func_180425_c();
    }

    private void setHome(EntityPlayerMP player) {
        if (this.func_184595_k(this.field_70165_t, this.field_70163_u, this.field_70161_v)) {
            this.say((com.google.common.base.Optional<EntityPlayer>)com.google.common.base.Optional.of((Object)player), "interaction.sethome.success", new String[0]);
            this.home = this.func_180425_c();
            this.func_175449_a(this.home, 32);
            BlockPos bed = Util.getNearestPoint(this.func_190671_u_(), Util.getNearbyBlocks(this.func_190671_u_(), this.field_70170_p, BlockBed.class, 6, 3));
            if (bed != null) {
                this.set(BED_POS, bed);
            }
        } else {
            this.say((com.google.common.base.Optional<EntityPlayer>)com.google.common.base.Optional.of((Object)player), "interaction.sethome.fail", new String[0]);
        }
    }

    public void say(com.google.common.base.Optional<EntityPlayer> player, String phraseId, String ... params) {
        ArrayList<String> paramsList = new ArrayList<String>();
        if (params != null) {
            Collections.addAll(paramsList, params);
        }
        if (player.isPresent()) {
            EntityPlayer thePlayer = (EntityPlayer)player.get();
            paramsList.add(0, thePlayer.func_70005_c_());
            if (this.get(IS_INFECTED).booleanValue()) {
                thePlayer.func_145747_a((ITextComponent)new TextComponentString(this.func_145748_c_().func_150254_d() + ": ???"));
                this.func_184185_a(SoundEvents.field_187899_gZ, 0.5f, this.field_70146_Z.nextFloat() + 0.5f);
            } else {
                String dialogueType = this.getPlayerHistoryFor(((EntityPlayer)player.get()).func_110124_au()).getDialogueType().getId();
                String phrase = MCA.getLocalizer().localize(dialogueType + "." + phraseId, paramsList);
                thePlayer.func_145747_a((ITextComponent)new TextComponentString(String.format("%1$s: %2$s", this.func_145748_c_().func_150254_d(), phrase)));
            }
        } else {
            MCA.getLog().warn((Object)new Throwable("Say called on player that is not present!"));
        }
    }

    public boolean isMarried() {
        return !((UUID)this.get(SPOUSE_UUID).or((Object)Constants.ZERO_UUID)).equals(Constants.ZERO_UUID);
    }

    public boolean isMarriedTo(UUID uuid) {
        return ((UUID)this.get(SPOUSE_UUID).or((Object)Constants.ZERO_UUID)).equals(uuid);
    }

    public void marry(EntityPlayer player) {
        this.set(SPOUSE_UUID, com.google.common.base.Optional.of((Object)player.func_110124_au()));
        this.set(SPOUSE_NAME, player.func_70005_c_());
        this.set(MARRIAGE_STATE, EnumMarriageState.MARRIED.getId());
    }

    private void endMarriage() {
        this.set(SPOUSE_UUID, com.google.common.base.Optional.of((Object)Constants.ZERO_UUID));
        this.set(SPOUSE_NAME, "");
        this.set(MARRIAGE_STATE, EnumMarriageState.NOT_MARRIED.getId());
    }

    private void handleInteraction(EntityPlayerMP player, PlayerHistory history, APIButton button) {
        boolean succeeded;
        float successChance = 0.85f;
        int heartsBoost = button.getConstraints().contains((Object)EnumConstraint.ADULTS) ? 15 : 5;
        String interactionName = button.getIdentifier().replace("gui.button.", "");
        successChance -= button.getConstraints().contains((Object)EnumConstraint.ADULTS) ? 0.25f : 0.0f;
        successChance = (float)((double)successChance + (double)history.getHearts() / 10.0 * (double)0.025f);
        if (MCA.getConfig().enableDiminishingReturns) {
            successChance -= (float)history.getInteractionFatigue() * 0.05f;
        }
        boolean bl = succeeded = this.field_70146_Z.nextFloat() < successChance;
        if (MCA.getConfig().enableDiminishingReturns && succeeded) {
            heartsBoost = (int)((float)heartsBoost - (float)history.getInteractionFatigue() * 0.05f);
        }
        history.changeInteractionFatigue(1);
        history.changeHearts(succeeded ? heartsBoost : heartsBoost * -1);
        String responseId = String.format("%s.%s", interactionName, succeeded ? "success" : "fail");
        this.say((com.google.common.base.Optional<EntityPlayer>)com.google.common.base.Optional.of((Object)player), responseId, new String[0]);
    }

    public void handleButtonClick(EntityPlayerMP player, String guiKey, String buttonId) {
        PlayerHistory history = this.getPlayerHistoryFor(player.func_110124_au());
        Optional<APIButton> button = API.getButtonById(guiKey, buttonId);
        if (!button.isPresent()) {
            MCA.getLog().warn("Button not found for key and ID: " + guiKey + ", " + buttonId);
        } else if (button.get().isInteraction()) {
            this.handleInteraction(player, history, button.get());
        }
        switch (buttonId) {
            case "gui.button.move": {
                this.set(MOVE_STATE, EnumMoveState.MOVE.getId());
                this.playerToFollowUUID = Constants.ZERO_UUID;
                break;
            }
            case "gui.button.stay": {
                this.set(MOVE_STATE, EnumMoveState.STAY.getId());
                break;
            }
            case "gui.button.follow": {
                this.set(MOVE_STATE, EnumMoveState.FOLLOW.getId());
                this.playerToFollowUUID = player.func_110124_au();
                break;
            }
            case "gui.button.ridehorse": {
                this.toggleMount(player);
                break;
            }
            case "gui.button.sethome": {
                this.setHome(player);
                break;
            }
            case "gui.button.gohome": {
                this.goHome(player);
                break;
            }
            case "gui.button.trade": {
                if (MCA.getConfig().allowTrading) {
                    this.func_70932_a_((EntityPlayer)player);
                    player.func_180472_a((IMerchant)this);
                    break;
                }
                player.func_145747_a((ITextComponent)new TextComponentString(MCA.getLocalizer().localize("info.trading.disabled", new String[0])));
                break;
            }
            case "gui.button.inventory": {
                player.openGui((Object)MCA.getInstance(), 3, player.field_70170_p, this.func_145782_y(), 0, 0);
                break;
            }
            case "gui.button.gift": {
                ItemStack stack = player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c);
                int giftValue = API.getGiftValueFromStack(stack);
                if (!this.handleSpecialCaseGift((EntityPlayer)player, stack)) {
                    if (stack.func_77973_b() == Items.field_151153_ao) {
                        this.set(IS_INFECTED, false);
                    } else {
                        history.changeHearts(giftValue);
                        this.say((com.google.common.base.Optional<EntityPlayer>)com.google.common.base.Optional.of((Object)player), API.getResponseForGift(stack), new String[0]);
                    }
                }
                if (giftValue <= 0) break;
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                break;
            }
            case "gui.button.procreate": {
                if (PlayerSaveData.get((EntityPlayer)player).isBabyPresent()) {
                    this.say((com.google.common.base.Optional<EntityPlayer>)com.google.common.base.Optional.of((Object)player), "interaction.procreate.fail.hasbaby", new String[0]);
                    break;
                }
                if (history.getHearts() < 100) {
                    this.say((com.google.common.base.Optional<EntityPlayer>)com.google.common.base.Optional.of((Object)player), "interaction.procreate.fail.lowhearts", new String[0]);
                    break;
                }
                EntityAITasks.EntityAITaskEntry task = this.field_70714_bg.field_75782_a.stream().filter(ai -> ai.field_75733_a instanceof EntityAIProcreate).findFirst().orElse(null);
                if (task == null) break;
                ((EntityAIProcreate)task.field_75733_a).procreateTimer = 60;
                this.set(IS_PROCREATING, true);
                break;
            }
            case "gui.button.infected": {
                this.set(IS_INFECTED, this.get(IS_INFECTED) == false);
                break;
            }
            case "gui.button.texture.randomize": {
                this.set(TEXTURE, API.getRandomSkin(this));
                break;
            }
            case "gui.button.profession.randomize": {
                this.setProfession(ProfessionsMCA.randomProfession());
                this.setVanillaCareer(this.getProfessionForge().getRandomCareer(this.field_70170_p.field_73012_v));
                break;
            }
            case "gui.button.gender": {
                EnumGender gender = EnumGender.byId(this.get(GENDER));
                if (gender == EnumGender.MALE) {
                    this.set(GENDER, EnumGender.FEMALE.getId());
                } else {
                    this.set(GENDER, EnumGender.MALE.getId());
                }
            }
            case "gui.button.texture": {
                this.set(TEXTURE, API.getRandomSkin(this));
                break;
            }
            case "gui.button.random": {
                this.set(VILLAGER_NAME, API.getRandomName(EnumGender.byId(this.get(GENDER))));
                break;
            }
            case "gui.button.profession": {
                RegistryNamespaced registry = (RegistryNamespaced)ObfuscationReflectionHelper.getPrivateValue(VillagerRegistry.class, (Object)VillagerRegistry.instance(), (String[])new String[]{"REGISTRY"});
                this.setProfession(ProfessionsMCA.randomProfession());
                this.setVanillaCareer(this.getProfessionForge().getRandomCareer(this.field_70170_p.field_73012_v));
                this.applySpecialAI();
                break;
            }
            case "gui.button.prospecting": {
                this.startChore(EnumChore.PROSPECT, (EntityPlayer)player);
                break;
            }
            case "gui.button.hunting": {
                this.startChore(EnumChore.HUNT, (EntityPlayer)player);
                break;
            }
            case "gui.button.fishing": {
                this.startChore(EnumChore.FISH, (EntityPlayer)player);
                break;
            }
            case "gui.button.chopping": {
                this.startChore(EnumChore.CHOP, (EntityPlayer)player);
                break;
            }
            case "gui.button.harvesting": {
                this.startChore(EnumChore.HARVEST, (EntityPlayer)player);
                break;
            }
            case "gui.button.stopworking": {
                this.stopChore();
            }
        }
    }

    private boolean handleSpecialCaseGift(EntityPlayer player, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemSpecialCaseGift && !this.func_70631_g_()) {
            boolean decStackSize = ((ItemSpecialCaseGift)item).handle(player, this);
            if (decStackSize) {
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, -1);
            }
            return true;
        }
        if (item == Items.field_151105_aU) {
            com.google.common.base.Optional<Entity> spouse = Util.getEntityByUUID(this.field_70170_p, (UUID)this.get(SPOUSE_UUID).or((Object)Constants.ZERO_UUID));
            if (spouse.isPresent()) {
                EntityVillagerMCA progressor = this.get(GENDER).intValue() == EnumGender.FEMALE.getId() ? this : (EntityVillagerMCA)((Object)spouse.get());
                progressor.set(HAS_BABY, true);
                progressor.set(BABY_IS_MALE, this.field_70146_Z.nextBoolean());
                progressor.func_180489_a(EnumParticleTypes.HEART);
            } else {
                this.say((com.google.common.base.Optional<EntityPlayer>)com.google.common.base.Optional.of((Object)player), "gift.cake.fail", new String[0]);
            }
        } else if (item == Items.field_151153_ao && this.func_70631_g_()) {
            this.func_110195_a(this.startingAge / 4 / 20 * -1);
            return true;
        }
        return false;
    }

    private void onEachClientUpdate() {
        if (this.get(IS_PROCREATING).booleanValue()) {
            this.field_70759_as += 50.0f;
        }
        if (this.field_70173_aa % 20 == 0) {
            this.onEachClientSecond();
        }
    }

    private void onEachClientSecond() {
        this.setSizeForAge();
    }

    private void onEachServerUpdate() {
        EnumAgeState target;
        EnumAgeState current;
        if (this.field_70173_aa % 20 == 0) {
            this.onEachServerSecond();
        }
        if (this.field_70173_aa % 200 == 0 && this.func_110143_aJ() > 0.0f && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70606_j(this.func_110143_aJ() + 1.0f);
        }
        if (this.func_70631_g_() && (current = EnumAgeState.byId(this.get(AGE_STATE))) != (target = EnumAgeState.byCurrentAge(this.startingAge, this.func_70874_b()))) {
            this.set(AGE_STATE, target.getId());
        }
    }

    private void onEachServerSecond() {
        NBTTagCompound memories = this.get(PLAYER_HISTORY_MAP);
        memories.func_150296_c().forEach(key -> PlayerHistory.fromNBT(this, UUID.fromString(key), memories.func_74775_l(key)).update());
        if (this.get(HAS_BABY).booleanValue()) {
            this.set(BABY_AGE, this.get(BABY_AGE) + 1);
            if (this.get(BABY_AGE) >= MCA.getConfig().babyGrowUpTime * 60) {
                EntityVillagerMCA child = new EntityVillagerMCA(this.field_70170_p, (com.google.common.base.Optional<VillagerRegistry.VillagerProfession>)com.google.common.base.Optional.absent(), (com.google.common.base.Optional<EnumGender>)com.google.common.base.Optional.of((Object)((Object)(this.get(BABY_IS_MALE) != false ? EnumGender.MALE : EnumGender.FEMALE))));
                child.set(AGE_STATE, EnumAgeState.BABY.getId());
                child.setStartingAge(MCA.getConfig().childGrowUpTime * 60 * 20 * -1);
                child.func_98054_a(true);
                child.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                child.set(PARENTS, ParentData.create(this.func_110124_au(), (UUID)this.get(SPOUSE_UUID).get(), this.get(VILLAGER_NAME), this.get(SPOUSE_NAME)).toNBT());
                this.field_70170_p.func_72838_d((Entity)child);
                this.set(HAS_BABY, false);
                this.set(BABY_AGE, 0);
            }
        }
    }

    public ResourceLocation getTextureResourceLocation() {
        if (this.get(IS_INFECTED).booleanValue()) {
            return ResourceLocationCache.getResourceLocationFor(String.format("mca:skins/%s/zombievillager.png", this.get(GENDER).intValue() == EnumGender.MALE.getId() ? "male" : "female"));
        }
        return ResourceLocationCache.getResourceLocationFor(this.get(TEXTURE));
    }

    private void applySpecialAI() {
        if (this.getProfessionForge() == ProfessionsMCA.bandit) {
            this.field_70715_bh.field_75782_a.clear();
            this.field_70714_bg.field_75782_a.clear();
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.8, false));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 0.6, false));
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillagerMCA.class, 100, false, false, BANDIT_TARGET_SELECTOR));
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        } else if (this.getProfessionForge() == ProfessionsMCA.guard) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.8, false));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 0.6, false));
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillagerMCA.class, 100, false, false, GUARD_TARGET_SELECTOR));
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, 100, false, false, null));
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVex.class, 100, false, false, null));
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVindicator.class, 100, false, false, null));
        }
    }

    public void func_180489_a(EnumParticleTypes particleType) {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
        } else {
            NetMCA.INSTANCE.sendToAll((IMessage)new NetMCA.SpawnParticles(this.func_110124_au(), particleType));
        }
    }

    public void stopChore() {
        this.set(ACTIVE_CHORE, EnumChore.NONE.getId());
        this.set(CHORE_ASSIGNING_PLAYER, com.google.common.base.Optional.of((Object)Constants.ZERO_UUID));
    }

    public void startChore(EnumChore chore, EntityPlayer player) {
        this.set(ACTIVE_CHORE, chore.getId());
        this.set(CHORE_ASSIGNING_PLAYER, com.google.common.base.Optional.of((Object)player.func_110124_au()));
    }

    public boolean playerIsParent(EntityPlayer player) {
        ParentData data = ParentData.fromNBT(this.get(PARENTS));
        return data.getParent1UUID().equals(player.func_110124_au()) || data.getParent2UUID().equals(player.func_110124_au());
    }

    public BlockPos func_180486_cf() {
        return this.home;
    }

    public void func_110177_bN() {
    }

    public String getCurrentActivity() {
        EnumMoveState moveState = EnumMoveState.byId(this.get(MOVE_STATE));
        if (moveState != EnumMoveState.MOVE) {
            return moveState.getFriendlyName();
        }
        EnumChore chore = EnumChore.byId(this.get(ACTIVE_CHORE));
        if (chore != EnumChore.NONE) {
            return chore.getFriendlyName();
        }
        return null;
    }
}

