/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai;

import java.util.ArrayList;
import java.util.List;
import mca.entity.EntityVillagerMCA;
import mca.entity.ai.AbstractEntityAIChore;
import mca.enums.EnumChore;
import mca.util.Util;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public class EntityAIChopping
extends AbstractEntityAIChore {
    private int chopTicks;
    private BlockPos targetTree;

    public EntityAIChopping(EntityVillagerMCA entityIn) {
        super(entityIn);
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        return EnumChore.byId(this.villager.get(EntityVillagerMCA.ACTIVE_CHORE)) == EnumChore.CHOP;
    }

    @Override
    public void func_75246_d() {
        if (!this.villager.inventory.contains(ItemAxe.class)) {
            this.villager.say(this.getAssigningPlayer(), "chore.chopping.noaxe", new String[0]);
            this.villager.stopChore();
        }
        if (this.targetTree == null) {
            List<BlockPos> nearbyLogs = Util.getNearbyBlocks(this.villager.func_190671_u_(), this.villager.field_70170_p, BlockLog.class, 10, 5);
            ArrayList<BlockPos> nearbyTrees = new ArrayList<BlockPos>();
            nearbyLogs.stream().filter(log -> {
                IBlockState down = this.villager.field_70170_p.func_180495_p(log.func_177977_b());
                List<BlockPos> leaves = Util.getNearbyBlocks(log, this.villager.field_70170_p, BlockLeaves.class, 1, 5);
                return leaves.size() > 0 && (down.func_177230_c() == Blocks.field_150349_c || down.func_177230_c() == Blocks.field_150346_d);
            }).forEach(nearbyTrees::add);
            this.targetTree = Util.getNearestPoint(this.villager.func_190671_u_(), nearbyTrees);
            return;
        }
        double distance = Math.sqrt(this.villager.func_174818_b(this.targetTree));
        if (distance >= 4.0) {
            this.villager.func_70661_as().func_75484_a(this.villager.func_70661_as().func_179680_a(this.targetTree), 0.5);
        } else {
            IBlockState state = this.villager.field_70170_p.func_180495_p(this.targetTree);
            if (state.func_177230_c() instanceof BlockLog) {
                BlockLog log2 = (BlockLog)state.func_177230_c();
                this.villager.func_184609_a(EnumHand.MAIN_HAND);
                ++this.chopTicks;
                if (this.chopTicks >= 80) {
                    this.chopTicks = 0;
                    this.villager.inventory.func_174894_a(new ItemStack((Block)log2, 1));
                    this.villager.func_184586_b(EnumHand.MAIN_HAND).func_77972_a(2, (EntityLivingBase)this.villager);
                    if ((double)this.villager.field_70170_p.field_73012_v.nextFloat() >= 0.9) {
                        this.destroyTree(this.targetTree);
                    }
                }
            } else {
                this.targetTree = null;
            }
        }
    }

    private void destroyTree(BlockPos origin) {
        BlockPos pos = origin;
        while (this.villager.field_70170_p.func_180495_p(pos).func_177230_c() instanceof BlockLog) {
            this.villager.field_70170_p.func_175698_g(pos);
            pos = pos.func_177982_a(0, 1, 0);
        }
    }
}

