/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai;

import java.util.ArrayList;
import java.util.List;
import mca.core.MCA;
import mca.entity.EntityVillagerMCA;
import mca.entity.ai.AbstractEntityAIChore;
import mca.enums.EnumChore;
import mca.util.Util;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class EntityAIHarvesting
extends AbstractEntityAIChore {
    private BlockPos target;

    public EntityAIHarvesting(EntityVillagerMCA villagerIn) {
        super(villagerIn);
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        return EnumChore.byId(this.villager.get(EntityVillagerMCA.ACTIVE_CHORE)) == EnumChore.HARVEST;
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (!this.villager.inventory.contains(ItemHoe.class)) {
            this.villager.say(this.getAssigningPlayer(), "chore.harvesting.nohoe", new String[0]);
            this.villager.stopChore();
        }
        if (this.target == null) {
            List<BlockPos> nearbyCrops = Util.getNearbyBlocks(this.villager.func_190671_u_(), this.villager.field_70170_p, BlockCrops.class, 16, 3);
            ArrayList<BlockPos> harvestable = new ArrayList<BlockPos>();
            for (BlockPos pos : nearbyCrops) {
                IBlockState state = this.villager.field_70170_p.func_180495_p(pos);
                BlockCrops crop = (BlockCrops)state.func_177230_c();
                if (!crop.func_185525_y(state)) continue;
                harvestable.add(pos);
            }
            this.target = Util.getNearestPoint(this.villager.func_190671_u_(), harvestable);
        } else {
            double distanceTo = Math.sqrt(this.villager.func_174818_b(this.target));
            if (distanceTo >= 2.0) {
                this.villager.func_70661_as().func_75484_a(this.villager.func_70661_as().func_179680_a(this.target), 0.5);
            } else {
                IBlockState state = this.villager.field_70170_p.func_180495_p(this.target);
                if (state.func_177230_c() instanceof BlockCrops) {
                    BlockCrops crop = (BlockCrops)state.func_177230_c();
                    NonNullList drops = NonNullList.func_191196_a();
                    crop.getDrops(drops, (IBlockAccess)this.villager.field_70170_p, this.target, state, 0);
                    for (ItemStack stack : drops) {
                        this.villager.inventory.func_174894_a(stack);
                    }
                    this.villager.func_184609_a(EnumHand.MAIN_HAND);
                    this.villager.func_184586_b(EnumHand.MAIN_HAND).func_77972_a(2, (EntityLivingBase)this.villager);
                    try {
                        IProperty property = crop.func_176194_O().func_185920_a("age");
                        this.villager.field_70170_p.func_175656_a(this.target, state.func_177226_a(property, (Comparable)Integer.valueOf(0)));
                    }
                    catch (Exception e) {
                        MCA.getLog().warn("Error resetting crop age at " + this.target.toString() + "! Setting to air.");
                        this.villager.field_70170_p.func_175698_g(this.target);
                    }
                    this.target = null;
                } else {
                    this.target = null;
                }
            }
        }
    }
}

