/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.data;

import java.util.UUID;
import mca.core.Constants;
import mca.entity.EntityVillagerMCA;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ParentData {
    private UUID parent1UUID = Constants.ZERO_UUID;
    private UUID parent2UUID = Constants.ZERO_UUID;
    private String parent1Name = "";
    private String parent2Name = "";

    public static ParentData fromNBT(NBTTagCompound nbt) {
        ParentData data = new ParentData();
        data.parent1UUID = nbt.func_186857_a("parent1UUID");
        data.parent2UUID = nbt.func_186857_a("parent2UUID");
        data.parent1Name = nbt.func_74779_i("parent1Name");
        data.parent2Name = nbt.func_74779_i("parent2Name");
        return data;
    }

    public static ParentData create(UUID parent1UUID, UUID parent2UUID, String parent1Name, String parent2Name) {
        ParentData data = new ParentData();
        data.parent1UUID = parent1UUID;
        data.parent2UUID = parent2UUID;
        data.parent1Name = parent1Name;
        data.parent2Name = parent2Name;
        return data;
    }

    public static ParentData fromVillager(EntityVillagerMCA villager) {
        ParentData data = new ParentData();
        data.parent1Name = villager.get(EntityVillagerMCA.VILLAGER_NAME);
        data.parent1UUID = villager.func_110124_au();
        data.parent2Name = villager.get(EntityVillagerMCA.SPOUSE_NAME);
        data.parent2UUID = (UUID)villager.get(EntityVillagerMCA.SPOUSE_UUID).or((Object)Constants.ZERO_UUID);
        return data;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_186854_a("parent1UUID", this.parent1UUID);
        nbt.func_186854_a("parent2UUID", this.parent2UUID);
        nbt.func_74778_a("parent1Name", this.parent1Name);
        nbt.func_74778_a("parent2Name", this.parent2Name);
        return nbt;
    }

    public ParentData setParents(UUID parent1UUID, String parent1Name, UUID parent2UUID, String parent2Name) {
        this.parent1UUID = parent1UUID;
        this.parent2UUID = parent2UUID;
        this.parent1Name = parent1Name;
        this.parent2Name = parent2Name;
        return this;
    }

    public Entity getParentEntity(World world, UUID uuid) {
        return world.field_72996_f.stream().filter(e -> e.func_110124_au().equals(uuid)).findFirst().orElse(null);
    }

    public Entity[] getParentEntities(World world) {
        return new Entity[]{this.getParentEntity(world, this.getParent1UUID()), this.getParentEntity(world, this.getParent2UUID())};
    }

    public UUID getParent1UUID() {
        return this.parent1UUID;
    }

    public UUID getParent2UUID() {
        return this.parent2UUID;
    }

    public String getParent1Name() {
        return this.parent1Name;
    }

    public String getParent2Name() {
        return this.parent2Name;
    }
}

