/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.data;

import java.util.UUID;
import mca.core.Constants;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumDialogueType;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerHistory {
    private int hearts = 0;
    private int interactionFatigue = 0;
    private boolean giftPresent = false;
    private int greetTimer = 0;
    private EnumDialogueType dialogueType;
    private UUID playerUUID = Constants.ZERO_UUID;
    private EntityVillagerMCA villager;

    private PlayerHistory() {
        this.dialogueType = EnumDialogueType.ADULT;
    }

    public static PlayerHistory getNew(EntityVillagerMCA villager, UUID uuid) {
        PlayerHistory history = new PlayerHistory();
        history.villager = villager;
        history.playerUUID = uuid;
        if (villager.func_70631_g_()) {
            history.setDialogueType(EnumDialogueType.CHILD);
        } else {
            history.setDialogueType(EnumDialogueType.ADULT);
        }
        return history;
    }

    public static PlayerHistory fromNBT(EntityVillagerMCA villager, UUID uuid, NBTTagCompound nbt) {
        PlayerHistory history = new PlayerHistory();
        history.villager = villager;
        history.playerUUID = uuid;
        history.hearts = nbt.func_74762_e("hearts");
        history.interactionFatigue = nbt.func_74762_e("interactionFatigue");
        history.giftPresent = nbt.func_74767_n("giftPresent");
        history.greetTimer = nbt.func_74762_e("greetTimer");
        history.dialogueType = EnumDialogueType.byValue(nbt.func_74779_i("dialogueType"));
        return history;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("hearts", this.hearts);
        nbt.func_74768_a("interactionFatigue", this.interactionFatigue);
        nbt.func_74757_a("giftPresent", this.giftPresent);
        nbt.func_74768_a("greetTimer", this.greetTimer);
        nbt.func_74778_a("dialogueType", this.dialogueType.getId());
        return nbt;
    }

    public void setHearts(int value) {
        this.hearts = value;
        this.villager.updatePlayerHistoryMap(this);
    }

    public void changeHearts(int value) {
        this.hearts += value;
        this.villager.updatePlayerHistoryMap(this);
    }

    public void changeInteractionFatigue(int value) {
        this.interactionFatigue += value;
        this.villager.updatePlayerHistoryMap(this);
    }

    public void update() {
        if (this.villager.field_70173_aa % 6000 == 0) {
            this.changeInteractionFatigue(-1);
        }
    }

    public void setDialogueType(EnumDialogueType type) {
        this.dialogueType = type;
        this.villager.updatePlayerHistoryMap(this);
    }

    public int getHearts() {
        return this.hearts;
    }

    public int getInteractionFatigue() {
        return this.interactionFatigue;
    }

    public boolean isGiftPresent() {
        return this.giftPresent;
    }

    public int getGreetTimer() {
        return this.greetTimer;
    }

    public EnumDialogueType getDialogueType() {
        return this.dialogueType;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }
}

