/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.data;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mca.core.Constants;
import mca.core.MCA;
import mca.enums.EnumMarriageState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class PlayerSaveData
extends WorldSavedData {
    private static final String PREFIX = "MCA-Player-V1-";
    private UUID spouseUUID = Constants.ZERO_UUID;
    private EnumMarriageState marriageState = EnumMarriageState.NOT_MARRIED;
    private String spouseName = "";
    private boolean babyPresent = false;

    public PlayerSaveData(String id) {
        super(id);
    }

    public static PlayerSaveData get(EntityPlayer player) {
        String dataId = PREFIX + player.func_110124_au().toString();
        PlayerSaveData data = (PlayerSaveData)player.field_70170_p.func_72943_a(PlayerSaveData.class, dataId);
        if (data == null) {
            data = new PlayerSaveData(dataId);
            player.field_70170_p.func_72823_a(dataId, (WorldSavedData)data);
        }
        return data;
    }

    public static PlayerSaveData getExisting(World world, UUID uuid) {
        return (PlayerSaveData)world.func_72943_a(PlayerSaveData.class, PREFIX + uuid.toString());
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        nbt.func_186854_a("spouseUUID", this.spouseUUID);
        nbt.func_74768_a("marriageState", this.marriageState.getId());
        nbt.func_74778_a("spouseName", this.spouseName);
        nbt.func_74757_a("babyPresent", this.babyPresent);
        return nbt;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.spouseUUID = nbt.func_186857_a("spouseUUID");
        this.marriageState = EnumMarriageState.byId(nbt.func_74762_e("marriageState"));
        this.spouseName = nbt.func_74779_i("spouseName");
        this.babyPresent = nbt.func_74767_n("babyPresent");
    }

    public boolean isMarriedOrEngaged() {
        return this.marriageState != EnumMarriageState.NOT_MARRIED;
    }

    public void marry(UUID uuid, String name) {
        this.spouseUUID = uuid;
        this.marriageState = EnumMarriageState.MARRIED;
        this.spouseName = name;
        this.func_76185_a();
    }

    public void endMarriage() {
        this.spouseUUID = Constants.ZERO_UUID;
        this.spouseName = "";
        this.marriageState = EnumMarriageState.NOT_MARRIED;
        this.func_76185_a();
    }

    public void setBabyPresent(boolean value) {
        this.babyPresent = value;
        this.func_76185_a();
    }

    public void reset() {
        this.endMarriage();
        this.setBabyPresent(false);
        this.func_76185_a();
    }

    public List<Field> getDataFields() {
        return Arrays.stream(((Object)((Object)this)).getClass().getDeclaredFields()).filter(f -> !Modifier.isFinal(f.getModifiers())).collect(Collectors.toList());
    }

    public void dump(EntityPlayer player) {
        for (Field f : this.getDataFields()) {
            try {
                player.func_145747_a((ITextComponent)new TextComponentString(f.getName() + " = " + f.get((Object)this).toString()));
            }
            catch (Exception e) {
                MCA.getLog().error("Error dumping player data!");
                MCA.getLog().error((Object)e);
            }
        }
    }

    public UUID getSpouseUUID() {
        return this.spouseUUID;
    }

    public EnumMarriageState getMarriageState() {
        return this.marriageState;
    }

    public String getSpouseName() {
        return this.spouseName;
    }

    public boolean isBabyPresent() {
        return this.babyPresent;
    }
}

