/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.inventory;

import java.util.ArrayList;
import javax.annotation.Nullable;
import mca.entity.EntityVillagerMCA;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryMCA
extends InventoryBasic {
    private EntityVillagerMCA villager;

    public InventoryMCA(EntityVillagerMCA villager) {
        super("Villager Inventory", true, 27);
        this.villager = villager;
    }

    public int getFirstSlotContainingItem(Item item) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_77973_b() != item) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(Class clazz) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            Item item = stack.func_77973_b();
            if (item.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    public ItemStack getBestItemOfType(@Nullable Class type) {
        if (type == null) {
            return ItemStack.field_190927_a;
        }
        return this.func_70301_a(this.getBestItemOfTypeSlot(type));
    }

    public ItemStack getBestArmorOfType(EntityEquipmentSlot slot) {
        ItemStack returnStack = ItemStack.field_190927_a;
        ArrayList<ItemStack> armors = new ArrayList<ItemStack>();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ItemArmor)) continue;
            ItemArmor armor = (ItemArmor)stack.func_77973_b();
            if (armor.field_77881_a != slot) continue;
            armors.add(stack);
        }
        int highestMaxDamage = 0;
        for (ItemStack stack : armors) {
            if (stack.func_77958_k() <= highestMaxDamage) continue;
            returnStack = stack;
            highestMaxDamage = stack.func_77958_k();
        }
        return returnStack;
    }

    public int getBestItemOfTypeSlot(Class type) {
        int highestMaxDamage = 0;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stackInInventory = this.func_70301_a(i);
            String itemClassName = stackInInventory.func_77973_b().getClass().getName();
            if (!itemClassName.equals(type.getName()) || highestMaxDamage >= stackInInventory.func_77958_k()) continue;
            highestMaxDamage = stackInInventory.func_77958_k();
            return i;
        }
        return -1;
    }

    public void dropAllItems() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            this.villager.func_70099_a(stack, 1.0f);
        }
    }

    public void readInventoryFromNBT(NBTTagList tagList) {
        int i;
        for (i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
        for (i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbt = tagList.func_150305_b(i);
            int slot = nbt.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, new ItemStack(nbt));
        }
    }

    public NBTTagList writeInventoryToNBT() {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            if (itemstack == ItemStack.field_190927_a) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbt);
            tagList.func_74742_a((NBTBase)nbt);
        }
        return tagList;
    }
}

