/*
 * Decompiled with CFR 0.152.
 */
package mca.enums;

import java.util.Arrays;
import java.util.Optional;
import mca.core.MCA;

public enum EnumAgeState {
    UNASSIGNED(-1, 0.8f, 2.0f, 1.5f),
    BABY(0, 0.3f, 0.5f, 0.4f),
    TODDLER(1, 0.3f, 0.6f, 0.5f),
    CHILD(2, 0.5f, 1.1f, 1.0f),
    TEEN(3, 0.6f, 1.6f, 1.35f),
    ADULT(4, 0.8f, 2.0f, 1.5f);

    int id;
    float width;
    float height;
    float scaleForAge;

    public static EnumAgeState byId(int id) {
        Optional<EnumAgeState> state = Arrays.stream(EnumAgeState.values()).filter(e -> e.id == id).findFirst();
        return state.orElse(UNASSIGNED);
    }

    public static EnumAgeState byCurrentAge(int startingAge, int growingAge) {
        int step = startingAge / 4;
        if (growingAge >= step) {
            return TEEN;
        }
        if (growingAge >= step * 2) {
            return CHILD;
        }
        if (growingAge >= step * 3 && growingAge < step * 2) {
            return TODDLER;
        }
        if (growingAge >= step * 4 && growingAge < step * 3) {
            return BABY;
        }
        return ADULT;
    }

    public String localizedName() {
        return MCA.getLocalizer().localize("enum.agestate." + this.name().toLowerCase(), new String[0]);
    }

    private EnumAgeState(int id, float width, float height, float scaleForAge) {
        this.id = id;
        this.width = width;
        this.height = height;
        this.scaleForAge = scaleForAge;
    }

    public int getId() {
        return this.id;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getScaleForAge() {
        return this.scaleForAge;
    }
}

