/*
 * Decompiled with CFR 0.152.
 */
package mca.items;

import com.google.common.base.Optional;
import java.util.List;
import mca.api.API;
import mca.core.Localizer;
import mca.core.MCA;
import mca.core.minecraft.ProfessionsMCA;
import mca.entity.EntityVillagerMCA;
import mca.entity.data.ParentData;
import mca.entity.data.PlayerSaveData;
import mca.enums.EnumAgeState;
import mca.enums.EnumDialogueType;
import mca.enums.EnumGender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBaby
extends Item {
    private boolean isMale;

    public ItemBaby(boolean isMale) {
        this.isMale = isMale;
        this.func_77625_d(1);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int unknownInt, boolean unknownBoolean) {
        super.func_77663_a(itemStack, world, entity, unknownInt, unknownBoolean);
        if (!world.field_72995_K) {
            if (!itemStack.func_77942_o()) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74778_a("name", "");
                compound.func_74768_a("age", 0);
                compound.func_186854_a("ownerUUID", entity.func_110124_au());
                compound.func_74778_a("ownerName", entity.func_70005_c_());
                compound.func_74757_a("isInfected", false);
                itemStack.func_77982_d(compound);
            } else {
                this.updateBabyGrowth(itemStack);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        BlockPos pos = player.func_180425_c();
        ItemStack stack = player.func_184586_b(hand);
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o() + 1;
        int posZ = pos.func_177952_p();
        if (world.field_72995_K && this.getBabyName(stack).equals("")) {
            player.openGui((Object)MCA.getInstance(), 2, player.field_70170_p, player.func_145782_y(), 0, 0);
        }
        if (!world.field_72995_K && this.isReadyToGrowUp(stack) && !this.getBabyName(stack).equals("")) {
            EntityVillagerMCA child = new EntityVillagerMCA(world, (Optional<VillagerRegistry.VillagerProfession>)Optional.of((Object)ProfessionsMCA.child), (Optional<EnumGender>)Optional.of((Object)((Object)(this.isMale ? EnumGender.MALE : EnumGender.FEMALE))));
            child.set(EntityVillagerMCA.VILLAGER_NAME, this.getBabyName(stack));
            child.set(EntityVillagerMCA.TEXTURE, API.getRandomSkin(child));
            child.set(EntityVillagerMCA.AGE_STATE, EnumAgeState.BABY.getId());
            child.setStartingAge(MCA.getConfig().childGrowUpTime * 60 * 20 * -1);
            child.func_98054_a(true);
            child.func_70107_b(posX, posY, posZ);
            world.func_72838_d((Entity)child);
            PlayerSaveData playerData = PlayerSaveData.get(player);
            child.set(EntityVillagerMCA.PARENTS, ParentData.create(player.func_110124_au(), playerData.getSpouseUUID(), player.func_70005_c_(), playerData.getSpouseName()).toNBT());
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            playerData.setBabyPresent(false);
            child.getPlayerHistoryFor(player.func_110124_au()).setDialogueType(EnumDialogueType.CHILDP);
        }
        return super.func_77659_a(world, player, hand);
    }

    private String getBabyName(ItemStack stack) {
        return stack.func_77978_p().func_74779_i("name");
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (!entityItem.field_70170_p.field_72995_K) {
            this.updateBabyGrowth(entityItem.func_92059_d());
        }
        return super.onEntityItemUpdate(entityItem);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Localizer loc = MCA.getLocalizer();
        if (stack.func_77942_o()) {
            String ownerName;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            NBTTagCompound nbt = stack.func_77978_p();
            String textColor = ((ItemBaby)stack.func_77973_b()).isMale ? "\u00a7B" : "\u00a7D";
            int ageInMinutes = nbt.func_74762_e("age");
            String string = ownerName = nbt.func_186857_a("ownerUUID").equals(player.func_110124_au()) ? MCA.getLocalizer().localize("label.you", new String[0]) : nbt.func_74779_i("ownerName");
            if (this.getBabyName(stack).equals("")) {
                tooltip.add(textColor + loc.localize("gui.label.name", new String[0]) + " " + "\u00a7r" + MCA.getLocalizer().localize("label.unnamed", new String[0]));
            } else {
                tooltip.add(textColor + loc.localize("gui.label.name", new String[0]) + " " + "\u00a7r" + nbt.func_74779_i("name"));
            }
            tooltip.add(textColor + loc.localize("gui.label.age", new String[0]) + " " + "\u00a7r" + ageInMinutes + " " + (ageInMinutes == 1 ? loc.localize("gui.label.minute", new String[0]) : loc.localize("gui.label.minutes", new String[0])));
            tooltip.add(textColor + loc.localize("gui.label.parent", new String[0]) + " " + "\u00a7r" + ownerName);
            if (nbt.func_74767_n("isInfected")) {
                tooltip.add("\u00a7A" + loc.localize("gui.label.infected", new String[0]));
            }
            if (this.isReadyToGrowUp(stack)) {
                tooltip.add("\u00a7A" + loc.localize("gui.label.readytogrow", new String[0]));
            }
            if (nbt.func_74779_i("name").equals(loc.localize("gui.label.unnamed", new String[0]))) {
                tooltip.add("\u00a7E" + loc.localize("gui.label.rightclicktoname", new String[0]));
            }
        }
    }

    private void updateBabyGrowth(ItemStack itemStack) {
        if (itemStack.func_77942_o() && FMLCommonHandler.instance().getMinecraftServerInstance().func_71259_af() % 1200 == 0) {
            int age = itemStack.func_77978_p().func_74762_e("age");
            itemStack.func_77978_p().func_74768_a("age", ++age);
        }
    }

    private boolean isReadyToGrowUp(ItemStack itemStack) {
        return itemStack.func_77978_p().func_74762_e("age") >= MCA.getConfig().babyGrowUpTime;
    }

    public EnumGender getGender() {
        return this.isMale ? EnumGender.MALE : EnumGender.FEMALE;
    }
}

