/*
 * Decompiled with CFR 0.152.
 */
package mca.util;

import com.google.common.base.Optional;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import mca.core.MCA;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.io.IOUtils;

public class Util {
    private static final String RESOURCE_PREFIX = "assets/mca/";

    public static int getSpawnSafeTopLevel(World world, int x, int y, int z) {
        Block block = Blocks.field_150350_a;
        while (block == Blocks.field_150350_a && y > 0) {
            block = world.func_180495_p(new BlockPos(x, --y, z)).func_177230_c();
        }
        return y + 1;
    }

    public static String readResource(String path) {
        String data;
        String location = RESOURCE_PREFIX + path;
        try {
            data = IOUtils.toString((Reader)new InputStreamReader(MCA.class.getClassLoader().getResourceAsStream(location)));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read resource from JAR: " + location);
        }
        return data;
    }

    public static <T> T readResourceAsJSON(String path, Class<T> type) {
        Gson gson = new Gson();
        Object data = gson.fromJson(Util.readResource(path), type);
        return (T)data;
    }

    public static Optional<Entity> getEntityByUUID(World world, UUID uuid) {
        for (Entity entity : world.field_72996_f) {
            if (!entity.func_110124_au().equals(uuid)) continue;
            return Optional.of((Object)entity);
        }
        return Optional.absent();
    }

    public static <T extends Entity> Optional<T> getEntityByUUID(World world, UUID uuid, Class<? extends T> clazz) {
        for (Entity entity : world.field_72996_f) {
            if (!entity.getClass().isAssignableFrom(clazz) || !entity.func_110124_au().equals(uuid)) continue;
            return Optional.of((Object)entity);
        }
        return Optional.absent();
    }

    public static List<BlockPos> getNearbyBlocks(BlockPos origin, World world, @Nullable Class filter, int xzDist, int yDist) {
        ArrayList<BlockPos> pointsList = new ArrayList<BlockPos>();
        for (int x = -xzDist; x <= xzDist; ++x) {
            for (int y = -yDist; y <= yDist; ++y) {
                for (int z = -xzDist; z <= xzDist; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockPos pos = new BlockPos(origin.func_177958_n() + x, origin.func_177956_o() + y, origin.func_177952_p() + z);
                    if (filter != null && filter.isAssignableFrom(world.func_180495_p(pos).func_177230_c().getClass())) {
                        pointsList.add(pos);
                        continue;
                    }
                    if (filter != null) continue;
                    pointsList.add(pos);
                }
            }
        }
        return pointsList;
    }

    public static BlockPos getNearestPoint(BlockPos origin, List<BlockPos> blocks) {
        double closest = 100.0;
        BlockPos returnPoint = null;
        for (BlockPos point : blocks) {
            double distance = origin.func_185332_f(point.func_177958_n(), point.func_177956_o(), point.func_177952_p());
            if (!(distance < closest)) continue;
            closest = distance;
            returnPoint = point;
        }
        return returnPoint;
    }

    public static String httpGet(String url) {
        try {
            String inputLine;
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", "User-Agent");
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            return response.toString();
        }
        catch (IOException ignored) {
            MCA.getLog().error("Failed to GET from: " + url);
            return "";
        }
    }
}

