/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.client;

import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.common.persistent.AbstractPersistentData;
import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_merchants.common.BoundEntityEntry;
import austeretony.oxygen_merchants.common.config.MerchantsConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class BoundEntitiesContainerClient
extends AbstractPersistentData {
    private final Map<Long, BoundEntityEntry> entities = new ConcurrentHashMap<Long, BoundEntityEntry>();
    private final Map<UUID, Long> access = new ConcurrentHashMap<UUID, Long>();

    public int getEntriesAmount() {
        return this.entities.size();
    }

    public Set<Long> getEntriesIds() {
        return this.entities.keySet();
    }

    public Collection<BoundEntityEntry> getEntries() {
        return this.entities.values();
    }

    public boolean entryExist(long bondId) {
        return this.entities.containsKey(bondId);
    }

    public boolean entryExist(UUID entityUUID) {
        return this.access.containsKey(entityUUID);
    }

    public BoundEntityEntry getBoundEntityEntry(long bondId) {
        return this.entities.get(bondId);
    }

    public BoundEntityEntry getBoundEntityEntry(UUID entityUUID) {
        return this.entities.get(this.access.get(entityUUID));
    }

    public UUID getEntityUUIDById(long bondId) {
        return this.entities.get(bondId).getEntityUUID();
    }

    public void addEntry(BoundEntityEntry entry) {
        this.entities.put(entry.getId(), entry);
        this.access.put(entry.getEntityUUID(), entry.getId());
    }

    public void removeEntry(long bondId) {
        if (this.entryExist(bondId)) {
            this.access.remove(this.entities.remove(bondId).getEntityUUID());
        }
    }

    public void removeAccess(UUID entityUUID) {
        this.access.remove(entityUUID);
    }

    public String getDisplayName() {
        return "merchants:bound_entities";
    }

    public String getPath() {
        return OxygenHelperClient.getDataFolder() + "/client/world/merchants/entities.dat";
    }

    public long getSaveDelayMinutes() {
        return MerchantsConfig.DATA_SAVE_DELAY_MINUTES.getIntValue();
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((short)((short)this.entities.size()), (OutputStream)bos);
        for (BoundEntityEntry entry : this.entities.values()) {
            entry.write(bos);
        }
    }

    public void read(BufferedInputStream bis) throws IOException {
        int amount = StreamUtils.readShort((InputStream)bis);
        for (int i = 0; i < amount; ++i) {
            BoundEntityEntry entityEntry = new BoundEntityEntry();
            entityEntry.read(bis);
            this.entities.put(entityEntry.getId(), entityEntry);
            this.access.put(entityEntry.getEntityUUID(), entityEntry.getId());
        }
    }

    public void reset() {
        this.entities.clear();
        this.access.clear();
    }
}

