/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.client;

import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.common.persistent.AbstractPersistentData;
import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_merchants.common.MerchantProfile;
import austeretony.oxygen_merchants.common.config.MerchantsConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MerchantProfilesContainerClient
extends AbstractPersistentData {
    private final Map<Long, MerchantProfile> profiles = new ConcurrentHashMap<Long, MerchantProfile>();

    public int getProfilesAmount() {
        return this.profiles.size();
    }

    public Set<Long> getProfilesIds() {
        return this.profiles.keySet();
    }

    public Collection<MerchantProfile> getProfiles() {
        return this.profiles.values();
    }

    public boolean profileExist(long profileId) {
        return this.profiles.containsKey(profileId);
    }

    public MerchantProfile getProfile(long profileId) {
        return this.profiles.get(profileId);
    }

    public void addProfile(MerchantProfile profile) {
        this.profiles.put(profile.getId(), profile);
    }

    public void removeProfile(long profileId) {
        this.profiles.remove(profileId);
    }

    public String getDisplayName() {
        return "merchants:merchant_profiles";
    }

    public String getPath() {
        return OxygenHelperClient.getDataFolder() + "/client/world/merchants/profiles.dat";
    }

    public long getSaveDelayMinutes() {
        return MerchantsConfig.DATA_SAVE_DELAY_MINUTES.getIntValue();
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((short)((short)this.profiles.size()), (OutputStream)bos);
        for (MerchantProfile profile : this.profiles.values()) {
            profile.write(bos);
        }
    }

    public void read(BufferedInputStream bis) throws IOException {
        int amount = StreamUtils.readShort((InputStream)bis);
        for (int i = 0; i < amount; ++i) {
            MerchantProfile profile = new MerchantProfile();
            profile.read(bis);
            this.profiles.put(profile.getId(), profile);
        }
    }

    public void reset() {
        this.profiles.clear();
    }
}

