/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.client.gui.management;

import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.contextmenu.GUIContextMenu;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.gui.IndexedGUIButton;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButton;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButtonPanel;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIContextMenu;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIContextMenuElement;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIText;
import austeretony.oxygen_core.client.gui.elements.OxygenGUITextField;
import austeretony.oxygen_core.client.gui.elements.OxygenSorterGUIElement;
import austeretony.oxygen_core.client.gui.elements.SectionsGUIDDList;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_merchants.client.MerchantsManagerClient;
import austeretony.oxygen_merchants.client.gui.management.ManagementMenuGUIScreen;
import austeretony.oxygen_merchants.client.gui.management.entities.EntitiesSectionGUIFiller;
import austeretony.oxygen_merchants.client.gui.management.entities.EntityEntryGUIButton;
import austeretony.oxygen_merchants.client.gui.management.entities.callback.EntryCreationGUICallback;
import austeretony.oxygen_merchants.client.gui.management.entities.callback.EntryEditGUICallback;
import austeretony.oxygen_merchants.client.gui.management.entities.callback.RemoveEntryGUICallback;
import austeretony.oxygen_merchants.client.gui.management.entities.callback.VisitEntityGUICallback;
import austeretony.oxygen_merchants.client.gui.management.entities.context.EditBondContextAction;
import austeretony.oxygen_merchants.client.gui.management.entities.context.RemoveBondContextAction;
import austeretony.oxygen_merchants.client.gui.management.entities.context.VisitEntityContextAction;
import austeretony.oxygen_merchants.common.BoundEntityEntry;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;

public class EntitiesManagementGUISection
extends AbstractGUISection {
    private final ManagementMenuGUIScreen screen;
    private OxygenGUIButton createButton;
    private OxygenGUIButtonPanel entitiesPanel;
    private OxygenGUIText entitiesAmountTextLabel;
    private OxygenGUITextField searchField;
    private OxygenSorterGUIElement nameSorterElement;
    private OxygenSorterGUIElement profileSorterElement;
    private AbstractGUICallback entryCreationCallback;
    private AbstractGUICallback entryEditCallback;
    private AbstractGUICallback removeEntryCallback;
    private AbstractGUICallback visitEntityCallback;
    private IndexedGUIButton<Long> currentEntryButton;
    public final Entity pointedEntity;

    public EntitiesManagementGUISection(ManagementMenuGUIScreen screen) {
        super((AbstractGUIScreen)screen);
        this.screen = screen;
        this.pointedEntity = ClientReference.getPointedEntity();
    }

    public void init() {
        this.addElement((GUIBaseElement)new EntitiesSectionGUIFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenGUIText(4, 5, ClientReference.localize((String)"oxygen_merchants.gui.management.title", (Object[])new Object[0]), GUISettings.get().getTitleScale(), GUISettings.get().getEnabledTextColor()));
        this.entitiesAmountTextLabel = new OxygenGUIText(0, 18, "", GUISettings.get().getSubTextScale() - 0.05f, GUISettings.get().getEnabledTextColor());
        this.addElement((GUIBaseElement)this.entitiesAmountTextLabel);
        this.nameSorterElement = new OxygenSorterGUIElement(6, 18, OxygenSorterGUIElement.EnumSorting.DOWN, ClientReference.localize((String)"oxygen.sorting.name", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.nameSorterElement);
        this.nameSorterElement.setClickListener(sorting -> {
            this.profileSorterElement.reset();
            this.sortEntries(sorting == OxygenSorterGUIElement.EnumSorting.DOWN ? 0 : 1);
        });
        this.profileSorterElement = new OxygenSorterGUIElement(12, 18, OxygenSorterGUIElement.EnumSorting.INACTIVE, ClientReference.localize((String)"oxygen_merchants.sorting.profile", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.profileSorterElement);
        this.profileSorterElement.setClickListener(sorting -> {
            this.nameSorterElement.reset();
            this.sortEntries(sorting == OxygenSorterGUIElement.EnumSorting.DOWN ? 2 : 3);
        });
        this.entitiesPanel = new OxygenGUIButtonPanel((AbstractGUIScreen)this.screen, 6, 24, this.getWidth() - 15, 10, 1, 100, 10, GUISettings.get().getPanelTextScale(), true);
        this.addElement((GUIBaseElement)this.entitiesPanel);
        this.entitiesPanel.setClickListener((previous, clicked, mouseX, mouseY, mouseButton) -> {
            if (this.currentEntryButton != clicked) {
                this.currentEntryButton = clicked;
            }
        });
        this.entitiesPanel.initContextMenu((GUIContextMenu)new OxygenGUIContextMenu(GUISettings.get().getContextMenuWidth(), 9, new OxygenGUIContextMenuElement.ContextMenuAction[]{new EditBondContextAction(this), new VisitEntityContextAction(this), new RemoveBondContextAction(this)}));
        this.addElement((GUIBaseElement)new SectionsGUIDDList(this.getWidth() - 4, 5, new AbstractGUISection[]{this, this.screen.getProfilesSection()}));
        this.createButton = (OxygenGUIButton)new OxygenGUIButton(22, 137, 40, 10, ClientReference.localize((String)"oxygen_merchants.gui.management.create", (Object[])new Object[0])).setEnabled(this.pointedEntity != null && this.pointedEntity instanceof EntityLiving);
        this.addElement((GUIBaseElement)this.createButton);
        this.entryCreationCallback = new EntryCreationGUICallback(this.screen, this, 140, 136).enableDefaultBackground();
        this.entryEditCallback = new EntryEditGUICallback(this.screen, this, 140, 136).enableDefaultBackground();
        this.visitEntityCallback = new VisitEntityGUICallback(this.screen, this, 140, 38).enableDefaultBackground();
        this.removeEntryCallback = new RemoveEntryGUICallback(this.screen, this, 140, 38).enableDefaultBackground();
    }

    public static String getProfileName(BoundEntityEntry entry) {
        return MerchantsManagerClient.instance().getMerchantProfilesContainer().getProfile(entry.getMerchantProfileId()).getName();
    }

    private void sortEntries(int mode) {
        ArrayList<BoundEntityEntry> profiles = new ArrayList<BoundEntityEntry>(MerchantsManagerClient.instance().getBoundEntitiesContainer().getEntries());
        if (mode == 0) {
            Collections.sort(profiles, (p1, p2) -> p1.getName().compareTo(p2.getName()));
        } else if (mode == 1) {
            Collections.sort(profiles, (p1, p2) -> p2.getName().compareTo(p1.getName()));
        } else if (mode == 2) {
            Collections.sort(profiles, (p1, p2) -> EntitiesManagementGUISection.getProfileName(p1).compareTo(EntitiesManagementGUISection.getProfileName(p2)));
        } else if (mode == 3) {
            Collections.sort(profiles, (p1, p2) -> EntitiesManagementGUISection.getProfileName(p2).compareTo(EntitiesManagementGUISection.getProfileName(p1)));
        }
        this.entitiesPanel.reset();
        for (BoundEntityEntry entry : profiles) {
            String profileName = entry.getMerchantProfileId() != 0L ? MerchantsManagerClient.instance().getMerchantProfilesContainer().getProfile(entry.getMerchantProfileId()).getName() : ClientReference.localize((String)"oxygen_merchants.gui.management.emptyProfile", (Object[])new Object[0]);
            this.entitiesPanel.addButton((GUIButton)new EntityEntryGUIButton(entry.getId(), entry.getProfession().isEmpty() ? entry.getName() : entry.getName() + ", " + entry.getProfession(), profileName, entry.isDead(), entry.getMerchantProfileId() == 0L));
        }
        this.entitiesAmountTextLabel.setDisplayText(String.valueOf(MerchantsManagerClient.instance().getBoundEntitiesContainer().getEntriesAmount()));
        this.entitiesAmountTextLabel.setX(this.getWidth() - 9 - this.textWidth(this.entitiesAmountTextLabel.getDisplayText(), GUISettings.get().getSubTextScale() - 0.05f));
        int maxRows = MathUtils.clamp((int)profiles.size(), (int)10, (int)MathUtils.greaterOfTwo((int)profiles.size(), (int)100));
        this.entitiesPanel.getScroller().updateRowsAmount(maxRows);
        this.entitiesPanel.getScroller().resetPosition();
        this.entitiesPanel.getScroller().getSlider().reset();
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0 && element == this.createButton) {
            this.entryCreationCallback.open();
        }
    }

    public void entitiesSynchronized() {
        this.sortEntries(0);
    }

    public void entityCreated(BoundEntityEntry entry) {
        this.sortEntries(0);
        this.nameSorterElement.setSorting(OxygenSorterGUIElement.EnumSorting.DOWN);
        this.profileSorterElement.reset();
    }

    public void entityUpdated(BoundEntityEntry entry) {
        this.sortEntries(0);
        this.nameSorterElement.setSorting(OxygenSorterGUIElement.EnumSorting.DOWN);
        this.profileSorterElement.reset();
    }

    public void entityRemoved(BoundEntityEntry entry) {
        this.sortEntries(0);
        this.nameSorterElement.setSorting(OxygenSorterGUIElement.EnumSorting.DOWN);
        this.profileSorterElement.reset();
    }

    public IndexedGUIButton<Long> getCurrentEntryButton() {
        return this.currentEntryButton;
    }

    public void openEntryEditCallback() {
        this.entryEditCallback.open();
    }

    public void openVisitEntityCallback() {
        this.visitEntityCallback.open();
    }

    public void openRemoveEntryCallback() {
        this.removeEntryCallback.open();
    }
}

