/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.client.gui.management;

import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.contextmenu.GUIContextMenu;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.gui.IndexedGUIButton;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButton;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButtonPanel;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIContextMenu;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIContextMenuElement;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIText;
import austeretony.oxygen_core.client.gui.elements.OxygenSorterGUIElement;
import austeretony.oxygen_core.client.gui.elements.SectionsGUIDDList;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_merchants.client.MerchantsManagerClient;
import austeretony.oxygen_merchants.client.gui.management.ManagementMenuGUIScreen;
import austeretony.oxygen_merchants.client.gui.management.ProfileGUIButton;
import austeretony.oxygen_merchants.client.gui.management.profiles.GUICurrency;
import austeretony.oxygen_merchants.client.gui.management.profiles.OfferManagementGUIButton;
import austeretony.oxygen_merchants.client.gui.management.profiles.ProfilesSectionGUIFiller;
import austeretony.oxygen_merchants.client.gui.management.profiles.callback.CurrencyManagementGUICallback;
import austeretony.oxygen_merchants.client.gui.management.profiles.callback.OfferCreationGUICallback;
import austeretony.oxygen_merchants.client.gui.management.profiles.callback.OfferEditingGUICallback;
import austeretony.oxygen_merchants.client.gui.management.profiles.callback.ProfileCreationGUICallback;
import austeretony.oxygen_merchants.client.gui.management.profiles.callback.ProfileNameEditGUICallback;
import austeretony.oxygen_merchants.client.gui.management.profiles.callback.RemoveProfileGUICallback;
import austeretony.oxygen_merchants.client.gui.management.profiles.callback.SaveChangesGUICallback;
import austeretony.oxygen_merchants.client.gui.management.profiles.context.EditOfferContextAction;
import austeretony.oxygen_merchants.client.gui.management.profiles.context.EditProfileCurrencyContextAction;
import austeretony.oxygen_merchants.client.gui.management.profiles.context.EditProfileNameContextAction;
import austeretony.oxygen_merchants.client.gui.management.profiles.context.OfferCreationContextAction;
import austeretony.oxygen_merchants.client.gui.management.profiles.context.RemoveOfferContextAction;
import austeretony.oxygen_merchants.client.gui.management.profiles.context.RemoveProfileContextAction;
import austeretony.oxygen_merchants.client.gui.merchant.MerchantMenuGUIScreen;
import austeretony.oxygen_merchants.common.MerchantOffer;
import austeretony.oxygen_merchants.common.MerchantProfile;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;

public class ProfilesManagementGUISection
extends AbstractGUISection {
    private final ManagementMenuGUIScreen screen;
    private OxygenGUIButton createButton;
    private OxygenGUIButtonPanel profilesPanel;
    private OxygenGUIText profilesAmountTextLabel;
    private OxygenSorterGUIElement profilesNameSorterElement;
    private AbstractGUICallback profileCreationCallback;
    private AbstractGUICallback removeProfileCallback;
    private AbstractGUICallback profileNameEditingCallback;
    private AbstractGUICallback profileCurrencyManagementCallback;
    private AbstractGUICallback offerCreationCallback;
    private AbstractGUICallback offerEditingCallback;
    private AbstractGUICallback saveChangesCallback;
    private OxygenGUIText profileNameTextLabel;
    private OxygenGUIText profileOffersAmountTextLabel;
    private OxygenGUIButton profileSaveChangesButton;
    private OxygenGUIButton profileOpenButton;
    private GUICurrency profileCurrencyElement;
    private OxygenGUIButtonPanel profileOffersPanel;
    private MerchantProfile changesBuffer;
    private IndexedGUIButton<Long> currentProfileButton;
    private OfferManagementGUIButton currentOfferButton;

    public ProfilesManagementGUISection(ManagementMenuGUIScreen screen) {
        super((AbstractGUIScreen)screen);
        this.screen = screen;
    }

    public void init() {
        this.addElement((GUIBaseElement)new ProfilesSectionGUIFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenGUIText(4, 5, ClientReference.localize((String)"oxygen_merchants.gui.management.title", (Object[])new Object[0]), GUISettings.get().getTitleScale(), GUISettings.get().getEnabledTextColor()));
        this.profilesAmountTextLabel = new OxygenGUIText(0, 18, "", GUISettings.get().getSubTextScale() - 0.05f, GUISettings.get().getEnabledTextColor());
        this.addElement((GUIBaseElement)this.profilesAmountTextLabel);
        this.profilesNameSorterElement = new OxygenSorterGUIElement(6, 18, OxygenSorterGUIElement.EnumSorting.DOWN, ClientReference.localize((String)"oxygen_merchants.sorting.profile", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.profilesNameSorterElement);
        this.profilesNameSorterElement.setClickListener(sorting -> this.sortProfiles(sorting == OxygenSorterGUIElement.EnumSorting.DOWN ? 0 : 1));
        this.profilesPanel = new OxygenGUIButtonPanel((AbstractGUIScreen)this.screen, 6, 24, 75, 10, 1, 100, 10, GUISettings.get().getPanelTextScale(), true);
        this.addElement((GUIBaseElement)this.profilesPanel);
        this.profilesPanel.setClickListener((previous, clicked, mouseX, mouseY, mouseButton) -> {
            if (this.currentProfileButton != clicked) {
                if (this.currentProfileButton != null) {
                    this.currentProfileButton.setToggled(false);
                }
                clicked.toggle();
                this.currentProfileButton = clicked;
                this.loadProfileData((Long)clicked.index);
            }
        });
        this.profilesPanel.initContextMenu((GUIContextMenu)new OxygenGUIContextMenu(GUISettings.get().getContextMenuWidth(), 9, new OxygenGUIContextMenuElement.ContextMenuAction[]{new EditProfileNameContextAction(this), new EditProfileCurrencyContextAction(this), new OfferCreationContextAction(this), new RemoveProfileContextAction(this)}));
        this.createButton = new OxygenGUIButton(22, 137, 40, 10, ClientReference.localize((String)"oxygen_merchants.gui.management.create", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.createButton);
        this.profileCreationCallback = new ProfileCreationGUICallback(this.screen, this, 140, 48).enableDefaultBackground();
        this.removeProfileCallback = new RemoveProfileGUICallback(this.screen, this, 140, 38).enableDefaultBackground();
        this.profileNameEditingCallback = new ProfileNameEditGUICallback(this.screen, this, 140, 50).enableDefaultBackground();
        this.profileCurrencyManagementCallback = new CurrencyManagementGUICallback(this.screen, this, 140, 138).enableDefaultBackground();
        this.offerCreationCallback = new OfferCreationGUICallback(this.screen, this, 140, 200);
        this.offerEditingCallback = new OfferEditingGUICallback(this.screen, this, 140, 200);
        this.saveChangesCallback = new SaveChangesGUICallback(this.screen, this, 140, 38).enableDefaultBackground();
        this.initProfileElements();
    }

    private void initProfileElements() {
        this.profileNameTextLabel = (OxygenGUIText)new OxygenGUIText(90, 20, "", GUISettings.get().getTextScale(), GUISettings.get().getEnabledTextColor()).disableFull();
        this.addElement((GUIBaseElement)this.profileNameTextLabel);
        this.profileCurrencyElement = (GUICurrency)new GUICurrency(90, 20).disableFull();
        this.addElement((GUIBaseElement)this.profileCurrencyElement);
        this.profileOffersAmountTextLabel = (OxygenGUIText)new OxygenGUIText(0, 20, "", GUISettings.get().getSubTextScale() - 0.05f, GUISettings.get().getEnabledTextColor()).disableFull();
        this.addElement((GUIBaseElement)this.profileOffersAmountTextLabel);
        this.profileSaveChangesButton = (OxygenGUIButton)new OxygenGUIButton(90, 137, 40, 10, ClientReference.localize((String)"oxygen_merchants.gui.management.saveChangesButton", (Object[])new Object[0])).disableFull();
        this.addElement((GUIBaseElement)this.profileSaveChangesButton);
        this.profileOpenButton = (OxygenGUIButton)new OxygenGUIButton(134, 137, 40, 10, ClientReference.localize((String)"oxygen_merchants.gui.management.openProfileButton", (Object[])new Object[0])).disableFull();
        this.addElement((GUIBaseElement)this.profileOpenButton);
        this.profileOffersPanel = new OxygenGUIButtonPanel((AbstractGUIScreen)this.screen, 90, 30, this.getWidth() - 99, 16, 1, 100, 6, GUISettings.get().getPanelTextScale(), true);
        this.addElement((GUIBaseElement)this.profileOffersPanel);
        this.profileOffersPanel.disableFull();
        this.profileOffersPanel.setClickListener((previous, clicked, mouseX, mouseY, mouseButton) -> {
            if (this.currentOfferButton != clicked) {
                this.currentOfferButton = clicked;
            }
        });
        this.profileOffersPanel.initContextMenu((GUIContextMenu)new OxygenGUIContextMenu(GUISettings.get().getContextMenuWidth(), 9, new OxygenGUIContextMenuElement.ContextMenuAction[]{new EditOfferContextAction(this), new RemoveOfferContextAction(this)}));
        this.addElement((GUIBaseElement)new SectionsGUIDDList(this.getWidth() - 4, 5, new AbstractGUISection[]{this, this.screen.getEntitiesSection()}));
    }

    private void sortProfiles(int mode) {
        ArrayList<MerchantProfile> profiles = new ArrayList<MerchantProfile>(MerchantsManagerClient.instance().getMerchantProfilesContainer().getProfiles());
        if (mode == 0) {
            Collections.sort(profiles, (p1, p2) -> p1.getName().compareTo(p2.getName()));
        } else {
            Collections.sort(profiles, (p1, p2) -> p2.getName().compareTo(p1.getName()));
        }
        this.profilesPanel.reset();
        for (MerchantProfile profile : profiles) {
            this.profilesPanel.addButton((GUIButton)new ProfileGUIButton(profile));
        }
        this.profilesAmountTextLabel.setDisplayText(String.valueOf(MerchantsManagerClient.instance().getMerchantProfilesContainer().getProfilesAmount()));
        this.profilesAmountTextLabel.setX(80 - this.textWidth(this.profilesAmountTextLabel.getDisplayText(), GUISettings.get().getSubTextScale() - 0.05f));
        int maxRows = MathUtils.clamp((int)profiles.size(), (int)10, (int)MathUtils.greaterOfTwo((int)profiles.size(), (int)100));
        this.profilesPanel.getScroller().updateRowsAmount(maxRows);
        this.profilesPanel.getScroller().resetPosition();
        this.profilesPanel.getScroller().getSlider().reset();
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0) {
            if (element == this.createButton) {
                this.profileCreationCallback.open();
            } else if (element == this.profileSaveChangesButton) {
                this.openSaveChangesCallback();
            } else if (element == this.profileOpenButton) {
                ClientReference.displayGuiScreen((GuiScreen)new MerchantMenuGUIScreen(this.changesBuffer.getId()));
            }
        }
    }

    public void loadProfileData(long profileId) {
        this.changesBuffer = MerchantsManagerClient.instance().getMerchantProfilesContainer().getProfile(profileId).copy();
        this.profileNameTextLabel.enableFull();
        if (this.changesBuffer.isUsingCurrency()) {
            this.profileCurrencyElement.setUseCurrency();
        } else {
            this.profileCurrencyElement.setUseItem(this.changesBuffer.getCurrencyStack().getCachedItemStack());
        }
        this.profileCurrencyElement.enable();
        this.profileOffersAmountTextLabel.enableFull();
        this.loadOffers(this.changesBuffer);
        this.profileOffersPanel.enableFull();
        this.profileOffersPanel.getScroller().getSlider().enableFull();
        this.profileSaveChangesButton.enableFull();
        this.profileOpenButton.enableFull();
        this.profileNameTextLabel.setDisplayText(this.changesBuffer.getName());
        this.profileCurrencyElement.setX(this.profileNameTextLabel.getX() + this.textWidth(this.changesBuffer.getName(), GUISettings.get().getTextScale()) + 4);
    }

    private void loadOffers(MerchantProfile profile) {
        ArrayList<MerchantOffer> offers = new ArrayList<MerchantOffer>(profile.getOffers());
        Collections.sort(offers, (o1, o2) -> (int)((o1.offerId - o2.offerId) / 5000L));
        ItemStack currencyStack = profile.isUsingCurrency() ? null : profile.getCurrencyStack().getCachedItemStack();
        this.profileOffersPanel.reset();
        for (MerchantOffer offer : offers) {
            this.profileOffersPanel.addButton((GUIButton)new OfferManagementGUIButton(offer, currencyStack));
        }
        this.profileOffersAmountTextLabel.setDisplayText(String.valueOf(profile.getOffersAmount()));
        this.profileOffersAmountTextLabel.setX(this.getWidth() - 9 - this.textWidth(this.profileOffersAmountTextLabel.getDisplayText(), GUISettings.get().getSubTextScale() - 0.05f));
        int maxRows = MathUtils.clamp((int)profile.getOffersAmount(), (int)6, (int)MathUtils.greaterOfTwo((int)profile.getOffersAmount(), (int)100));
        this.profileOffersPanel.getScroller().updateRowsAmount(maxRows);
        this.profileOffersPanel.getScroller().resetPosition();
        this.profileOffersPanel.getScroller().getSlider().reset();
    }

    public void resetProfileData() {
        this.profileNameTextLabel.disableFull();
        this.profileCurrencyElement.disable();
        this.profileOffersAmountTextLabel.disableFull();
        this.profileOffersPanel.disableFull();
        this.profileOffersPanel.getScroller().getSlider().disableFull();
        this.profileSaveChangesButton.disableFull();
        this.profileOpenButton.disableFull();
    }

    public void profilesSynchronized() {
        this.sortProfiles(0);
    }

    public void profileCreated(MerchantProfile profile) {
        this.sortProfiles(0);
        this.resetProfileData();
        this.profilesNameSorterElement.setSorting(OxygenSorterGUIElement.EnumSorting.DOWN);
    }

    public void profileUpdated(MerchantProfile profile) {
        this.sortProfiles(0);
        this.loadProfileData(profile.getId());
        for (GUIButton button : this.profilesPanel.buttonsBuffer) {
            IndexedGUIButton profileButton = (IndexedGUIButton)button;
            if (((Long)profileButton.index).longValue() != profile.getId()) continue;
            profileButton.toggle();
            this.currentProfileButton = profileButton;
        }
        this.profilesNameSorterElement.setSorting(OxygenSorterGUIElement.EnumSorting.DOWN);
    }

    public void profileRemoved(MerchantProfile profile) {
        this.sortProfiles(0);
        this.resetProfileData();
        this.profilesNameSorterElement.setSorting(OxygenSorterGUIElement.EnumSorting.DOWN);
    }

    public MerchantProfile getCurrentProfileChangesBuffer() {
        return this.changesBuffer;
    }

    public OfferManagementGUIButton getCurrentOfferButton() {
        return this.currentOfferButton;
    }

    public void updateProfileName(String name) {
        this.changesBuffer.setName(name);
        this.profileNameTextLabel.setDisplayText(name);
        this.profileCurrencyElement.setX(this.profileNameTextLabel.getX() + this.textWidth(this.changesBuffer.getName(), GUISettings.get().getTextScale()) + 4);
    }

    public void setProfileUseCurrency() {
        this.changesBuffer.setUseCurrency(true);
        this.profileCurrencyElement.setUseCurrency();
        this.loadOffers(this.changesBuffer);
    }

    public void setProfileUseItem(ItemStack itemStack) {
        this.changesBuffer.setUseCurrency(false);
        this.changesBuffer.setCurrencyStack(ItemStackWrapper.getFromStack((ItemStack)itemStack));
        this.profileCurrencyElement.setUseItem(itemStack);
        this.loadOffers(this.changesBuffer);
    }

    public void addOfferToCurrentProfile(MerchantOffer offer) {
        this.changesBuffer.addOffer(offer);
        this.loadOffers(this.changesBuffer);
    }

    public void removeOfferFromCurrentProfile(long offerId) {
        this.changesBuffer.removeOffer(offerId);
        this.loadOffers(this.changesBuffer);
    }

    public IndexedGUIButton<Long> getCurrentProfileButton() {
        return this.currentProfileButton;
    }

    public void openRemoveProfileCallback() {
        this.removeProfileCallback.open();
    }

    public void openProfileNameEditingCallback() {
        this.profileNameEditingCallback.open();
    }

    public void openProfileCurrencyManagementCallback() {
        this.profileCurrencyManagementCallback.open();
    }

    public void openOfferCreationCallback() {
        this.offerCreationCallback.open();
    }

    public void openOfferEditingCallback() {
        this.offerEditingCallback.open();
    }

    public void openSaveChangesCallback() {
        this.saveChangesCallback.open();
    }
}

