/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.client.gui.management.entities.callback;

import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.gui.IndexedGUIButton;
import austeretony.oxygen_core.client.gui.elements.OxygenCallbackGUIFiller;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButton;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButtonPanel;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIText;
import austeretony.oxygen_core.client.gui.elements.OxygenGUITextField;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_merchants.client.MerchantsManagerClient;
import austeretony.oxygen_merchants.client.gui.management.EntitiesManagementGUISection;
import austeretony.oxygen_merchants.client.gui.management.ManagementMenuGUIScreen;
import austeretony.oxygen_merchants.client.gui.management.ProfileGUIButton;
import austeretony.oxygen_merchants.common.MerchantProfile;
import java.util.ArrayList;
import java.util.Collections;

public class EntryCreationGUICallback
extends AbstractGUICallback {
    private final ManagementMenuGUIScreen screen;
    private final EntitiesManagementGUISection section;
    private OxygenGUITextField nameField;
    private OxygenGUITextField professionField;
    private OxygenGUIButton confirmButton;
    private OxygenGUIButton cancelButton;
    private OxygenGUIButtonPanel profilesPanel;
    private IndexedGUIButton<Long> currentProfile;

    public EntryCreationGUICallback(ManagementMenuGUIScreen screen, EntitiesManagementGUISection section, int width, int height) {
        super((AbstractGUIScreen)screen, (AbstractGUISection)section, width, height);
        this.screen = screen;
        this.section = section;
    }

    public void init() {
        this.addElement((GUIBaseElement)new OxygenCallbackGUIFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenGUIText(4, 5, ClientReference.localize((String)"oxygen_merchants.gui.management.callback.entityCreation", (Object[])new Object[0]), GUISettings.get().getTextScale(), GUISettings.get().getEnabledTextColor()));
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 18, ClientReference.localize((String)"oxygen.gui.name", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColor()));
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 38, ClientReference.localize((String)"oxygen_merchants.gui.management.profession", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColor()));
        this.nameField = new OxygenGUITextField(6, 25, this.getWidth() - 12, 9, 20, "", 3, false, -1L);
        this.addElement((GUIBaseElement)this.nameField);
        this.professionField = new OxygenGUITextField(6, 45, this.getWidth() - 12, 9, 30, "", 3, false, -1L);
        this.addElement((GUIBaseElement)this.professionField);
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 58, ClientReference.localize((String)"oxygen_merchants.gui.management.profile", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColor()));
        this.profilesPanel = new OxygenGUIButtonPanel((AbstractGUIScreen)this.screen, 6, 66, this.getWidth() - 15, 10, 1, MathUtils.clamp((int)MerchantsManagerClient.instance().getMerchantProfilesContainer().getProfilesAmount(), (int)5, (int)100), 5, GUISettings.get().getPanelTextScale(), false);
        this.addElement((GUIBaseElement)this.profilesPanel);
        this.profilesPanel.setClickListener((previous, clicked, mouseX, mouseY, mouseButton) -> {
            if (this.currentProfile != clicked) {
                if (this.currentProfile != null) {
                    this.currentProfile.setToggled(false);
                }
                clicked.toggle();
                this.currentProfile = clicked;
                this.confirmButton.enable();
            }
        });
        this.confirmButton = new OxygenGUIButton(15, this.getHeight() - 12, 40, 10, ClientReference.localize((String)"oxygen.gui.confirmButton", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.confirmButton);
        this.cancelButton = new OxygenGUIButton(this.getWidth() - 55, this.getHeight() - 12, 40, 10, ClientReference.localize((String)"oxygen.gui.cancelButton", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.cancelButton);
    }

    private void loadProfiles() {
        ArrayList<MerchantProfile> profiles = new ArrayList<MerchantProfile>(MerchantsManagerClient.instance().getMerchantProfilesContainer().getProfiles());
        Collections.sort(profiles, (p1, p2) -> p1.getName().compareTo(p2.getName()));
        this.profilesPanel.reset();
        this.profilesPanel.getScroller().resetPosition();
        this.profilesPanel.getScroller().getSlider().reset();
        for (MerchantProfile profile : profiles) {
            this.profilesPanel.addButton((GUIButton)new ProfileGUIButton(profile));
        }
    }

    protected void onOpen() {
        this.nameField.reset();
        this.professionField.reset();
        this.loadProfiles();
        if (this.currentProfile != null) {
            this.currentProfile.setToggled(false);
            this.currentProfile = null;
        }
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0) {
            if (element == this.cancelButton) {
                this.close();
            } else if (element == this.confirmButton && this.currentProfile != null) {
                String name = this.nameField.getTypedText().isEmpty() ? this.section.pointedEntity.func_70005_c_() : this.nameField.getTypedText();
                String profession = this.professionField.getTypedText().isEmpty() ? "" : this.professionField.getTypedText();
                MerchantsManagerClient.instance().getBoundEntitiesManager().createEntrySynced(this.section.pointedEntity, name, profession, (Long)this.currentProfile.index);
                this.close();
            }
        }
    }
}

