/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.client.gui.management.profiles.callback;

import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.gui.elements.OxygenCallbackGUIFiller;
import austeretony.oxygen_core.client.gui.elements.OxygenCheckBoxGUIButton;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButton;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButtonPanel;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIText;
import austeretony.oxygen_core.client.gui.elements.OxygenGUITextField;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_merchants.client.gui.management.ManagementMenuGUIScreen;
import austeretony.oxygen_merchants.client.gui.management.ProfilesManagementGUISection;
import austeretony.oxygen_merchants.client.gui.management.profiles.InventoryItemGUIButton;
import austeretony.oxygen_merchants.common.MerchantOffer;
import net.minecraft.item.ItemStack;

public class OfferEditingGUICallback
extends AbstractGUICallback {
    private final ManagementMenuGUIScreen screen;
    private final ProfilesManagementGUISection section;
    private OxygenGUIButton confirmButton;
    private OxygenGUIButton cancelButton;
    private OxygenGUIButtonPanel itemsPanel;
    private OxygenGUITextField amountField;
    private OxygenGUITextField buyCostField;
    private OxygenGUITextField sellingCostField;
    private OxygenCheckBoxGUIButton enableSellingButton;
    private OxygenCheckBoxGUIButton sellingOnlyButton;
    private InventoryItemGUIButton currentButton;

    public OfferEditingGUICallback(ManagementMenuGUIScreen screen, ProfilesManagementGUISection section, int width, int height) {
        super((AbstractGUIScreen)screen, (AbstractGUISection)section, width, height);
        this.screen = screen;
        this.section = section;
    }

    public void init() {
        this.addElement((GUIBaseElement)new OxygenCallbackGUIFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenGUIText(4, 5, ClientReference.localize((String)"oxygen_merchants.gui.management.callback.editOffer", (Object[])new Object[0]), GUISettings.get().getTextScale(), GUISettings.get().getEnabledTextColor()));
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 105, ClientReference.localize((String)"oxygen_merchants.gui.management.amount", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColor()));
        this.amountField = new OxygenGUITextField(6, 112, 45, 9, 20, "", 3, true, Integer.MAX_VALUE);
        this.addElement((GUIBaseElement)this.amountField);
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 126, ClientReference.localize((String)"oxygen_merchants.gui.management.cost", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColor()));
        this.buyCostField = new OxygenGUITextField(6, 132, 45, 9, 20, "", 3, true, Integer.MAX_VALUE);
        this.addElement((GUIBaseElement)this.buyCostField);
        this.enableSellingButton = new OxygenCheckBoxGUIButton(6, 146);
        this.addElement((GUIBaseElement)this.enableSellingButton);
        this.addElement((GUIBaseElement)new OxygenGUIText(14, 147, ClientReference.localize((String)"oxygen_merchants.gui.management.enableSelling", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColor()));
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 157, ClientReference.localize((String)"oxygen_merchants.gui.management.cost", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColor()));
        this.sellingCostField = new OxygenGUITextField(6, 163, 45, 9, 20, "", 3, true, Integer.MAX_VALUE);
        this.addElement((GUIBaseElement)this.sellingCostField);
        this.sellingOnlyButton = new OxygenCheckBoxGUIButton(6, 177);
        this.addElement((GUIBaseElement)this.sellingOnlyButton);
        this.addElement((GUIBaseElement)new OxygenGUIText(14, 178, ClientReference.localize((String)"oxygen_merchants.gui.management.sellingOnly", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColor()));
        this.itemsPanel = new OxygenGUIButtonPanel((AbstractGUIScreen)this.screen, 6, 17, this.getWidth() - 12, 16, 1, 36, 5, GUISettings.get().getPanelTextScale(), false);
        this.addElement((GUIBaseElement)this.itemsPanel);
        this.itemsPanel.setClickListener((previous, clicked, mouseX, mouseY, mouseButton) -> {
            if (this.currentButton != clicked) {
                if (this.currentButton != null) {
                    this.currentButton.setToggled(false);
                }
                clicked.toggle();
                this.currentButton = clicked;
                this.confirmButton.enable();
            }
        });
        this.loadItems();
        this.confirmButton = new OxygenGUIButton(15, this.getHeight() - 12, 40, 10, ClientReference.localize((String)"oxygen.gui.confirmButton", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.confirmButton);
        this.cancelButton = new OxygenGUIButton(this.getWidth() - 55, this.getHeight() - 12, 40, 10, ClientReference.localize((String)"oxygen.gui.cancelButton", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.cancelButton);
    }

    protected void onOpen() {
        if (this.currentButton != null) {
            this.currentButton.setToggled(false);
            this.currentButton = null;
        }
        this.amountField.setText("1");
        this.buyCostField.setText("0");
        this.enableSellingButton.setToggled(false);
        this.sellingCostField.setText("0");
        this.sellingCostField.disable();
        this.sellingOnlyButton.setToggled(false);
        this.sellingOnlyButton.disable();
    }

    private void loadItems() {
        this.itemsPanel.reset();
        this.itemsPanel.getScroller().resetPosition();
        for (ItemStackWrapper wrapper : this.screen.inventoryContent) {
            this.itemsPanel.addButton((GUIButton)new InventoryItemGUIButton(wrapper.getCachedItemStack()));
        }
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0) {
            if (element == this.cancelButton) {
                this.close();
            } else if (element == this.confirmButton) {
                MerchantOffer offer = new MerchantOffer((Long)this.section.getCurrentOfferButton().index, ItemStackWrapper.getFromStack((ItemStack)this.currentButton.getItemStack()));
                offer.setAmount((int)this.amountField.getTypedNumber());
                offer.setBuyCost(this.buyCostField.getTypedNumber());
                offer.setSellingEnabled(this.enableSellingButton.isToggled());
                offer.setSellingOnly(this.sellingOnlyButton.isToggled());
                offer.setSellingCost(this.sellingCostField.getTypedNumber());
                this.section.addOfferToCurrentProfile(offer);
                this.close();
            } else if (element == this.enableSellingButton) {
                if (this.enableSellingButton.isToggled()) {
                    this.sellingCostField.enable();
                    this.sellingOnlyButton.enable();
                } else {
                    this.sellingCostField.disable();
                    this.sellingOnlyButton.disable();
                    this.sellingOnlyButton.setToggled(false);
                }
            }
        }
    }
}

