/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.client.gui.management.profiles.callback;

import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.gui.elements.OxygenCallbackGUIFiller;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButton;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIText;
import austeretony.oxygen_core.client.gui.elements.OxygenGUITextField;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_merchants.client.MerchantsManagerClient;
import austeretony.oxygen_merchants.client.gui.management.ManagementMenuGUIScreen;
import austeretony.oxygen_merchants.client.gui.management.ProfilesManagementGUISection;

public class ProfileCreationGUICallback
extends AbstractGUICallback {
    private final ManagementMenuGUIScreen screen;
    private final ProfilesManagementGUISection section;
    private OxygenGUITextField nameField;
    private OxygenGUIButton confirmButton;
    private OxygenGUIButton cancelButton;

    public ProfileCreationGUICallback(ManagementMenuGUIScreen screen, ProfilesManagementGUISection section, int width, int height) {
        super((AbstractGUIScreen)screen, (AbstractGUISection)section, width, height);
        this.screen = screen;
        this.section = section;
    }

    public void init() {
        this.addElement((GUIBaseElement)new OxygenCallbackGUIFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenGUIText(4, 5, ClientReference.localize((String)"oxygen_merchants.gui.management.callback.profileCreation", (Object[])new Object[0]), GUISettings.get().getTextScale(), GUISettings.get().getEnabledTextColor()));
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 18, ClientReference.localize((String)"oxygen_merchants.gui.management.callback.profileCreation.request", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColor()));
        this.nameField = new OxygenGUITextField(6, 25, this.getWidth() - 12, 9, 20, "", 3, false, -1L);
        this.addElement((GUIBaseElement)this.nameField);
        this.confirmButton = new OxygenGUIButton(15, this.getHeight() - 12, 40, 10, ClientReference.localize((String)"oxygen.gui.confirmButton", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.confirmButton);
        this.cancelButton = new OxygenGUIButton(this.getWidth() - 55, this.getHeight() - 12, 40, 10, ClientReference.localize((String)"oxygen.gui.cancelButton", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.cancelButton);
    }

    protected void onClose() {
        this.nameField.reset();
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0) {
            if (element == this.cancelButton) {
                this.close();
            } else if (element == this.confirmButton) {
                String name = this.nameField.getTypedText().isEmpty() ? ClientReference.localize((String)"oxygen_merchants.gui.management.profileGenericName", (Object[])new Object[0]) + " #" + String.valueOf(MerchantsManagerClient.instance().getMerchantProfilesContainer().getProfilesAmount() + 1) : this.nameField.getTypedText();
                MerchantsManagerClient.instance().getMerchantProfilesManager().createProfileSynced(name);
                this.close();
            }
        }
    }
}

