/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.client.gui.merchant;

import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.screen.text.GUITextField;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.api.WatcherHelperClient;
import austeretony.oxygen_core.client.gui.elements.CurrencyItemValueGUIElement;
import austeretony.oxygen_core.client.gui.elements.InventoryLoadGUIElement;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButtonPanel;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIText;
import austeretony.oxygen_core.client.gui.elements.OxygenGUITextField;
import austeretony.oxygen_core.client.gui.elements.SectionsGUIDDList;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.inventory.InventoryHelper;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_merchants.client.MerchantsManagerClient;
import austeretony.oxygen_merchants.client.gui.merchant.MerchantBackgroundGUIFiller;
import austeretony.oxygen_merchants.client.gui.merchant.MerchantMenuGUIScreen;
import austeretony.oxygen_merchants.client.gui.merchant.OfferGUIButton;
import austeretony.oxygen_merchants.common.MerchantOffer;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class BuyGUISection
extends AbstractGUISection {
    private final MerchantMenuGUIScreen screen;
    private OxygenGUITextField searchField;
    private OxygenGUIButtonPanel offersPanel;
    private CurrencyItemValueGUIElement balanceElement;
    private InventoryLoadGUIElement inventoryLoadElement;

    public BuyGUISection(MerchantMenuGUIScreen screen) {
        super((AbstractGUIScreen)screen);
        this.screen = screen;
    }

    public void init() {
        this.addElement((GUIBaseElement)new MerchantBackgroundGUIFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenGUIText(4, 5, this.screen.merchantProfile.getName(), GUISettings.get().getTitleScale(), GUISettings.get().getEnabledTextColor()));
        this.offersPanel = new OxygenGUIButtonPanel((AbstractGUIScreen)this.screen, 6, 27, this.getWidth() - 15, 16, 1, MathUtils.clamp((int)this.getBuyOffersAmount(), (int)9, (int)100), 9, GUISettings.get().getPanelTextScale(), true);
        this.addElement((GUIBaseElement)this.offersPanel);
        this.searchField = new OxygenGUITextField(6, 17, 65, 8, 24, "...", 3, false, -1L);
        this.addElement((GUIBaseElement)this.searchField);
        this.offersPanel.initSearchField((GUITextField)this.searchField);
        this.offersPanel.setClickListener((previous, clicked, mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0 && clicked.isAvailable()) {
                MerchantsManagerClient.instance().getMenuManager().performBuySynced(this.screen.merchantProfile.getId(), (Long)clicked.index);
            }
        });
        this.addElement((GUIBaseElement)new SectionsGUIDDList(this.getWidth() - 4, 5, new AbstractGUISection[]{this, this.screen.getSellingSection()}));
        this.balanceElement = new CurrencyItemValueGUIElement(this.getWidth() - 10, this.getHeight() - 10);
        this.addElement((GUIBaseElement)this.balanceElement);
        if (!this.screen.merchantProfile.isUsingCurrency()) {
            this.balanceElement.setItemStack(this.screen.merchantProfile.getCurrencyStack().getCachedItemStack());
        }
        this.updateBalance();
        this.inventoryLoadElement = new InventoryLoadGUIElement(4, this.getHeight() - 9, EnumGUIAlignment.RIGHT);
        this.addElement((GUIBaseElement)this.inventoryLoadElement);
        this.inventoryLoadElement.updateLoad();
        this.loadOffers();
    }

    private int getBuyOffersAmount() {
        return (int)this.screen.merchantProfile.getOffers().stream().filter(offer -> !offer.isSellingOnly()).count();
    }

    private void updateBalance() {
        long balance = 0L;
        balance = this.screen.merchantProfile.isUsingCurrency() ? WatcherHelperClient.getLong((int)0) : (long)InventoryHelper.getEqualStackAmount((EntityPlayer)this.mc.field_71439_g, (ItemStackWrapper)this.screen.merchantProfile.getCurrencyStack());
        this.balanceElement.setValue(balance);
        this.balanceElement.setRed(balance == 0L);
    }

    private void loadOffers() {
        ArrayList<MerchantOffer> offers = new ArrayList<MerchantOffer>(this.screen.merchantProfile.getOffers());
        Collections.sort(offers, (o1, o2) -> (int)((o1.offerId - o2.offerId) / 5000L));
        ItemStack currencyItemStack = null;
        if (!this.screen.merchantProfile.isUsingCurrency()) {
            currencyItemStack = this.screen.merchantProfile.getCurrencyStack().getItemStack();
        }
        for (MerchantOffer offer : offers) {
            if (offer.isSellingOnly()) continue;
            this.offersPanel.addButton((GUIButton)new OfferGUIButton(offer, offer.getBuyCost(), this.screen.getEqualStackAmount(offer.getOfferedStack()), currencyItemStack).setAvailable(!this.inventoryLoadElement.isOverloaded() && offer.getBuyCost() <= this.balanceElement.getValue()));
        }
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
    }

    public void bought(MerchantOffer offer, long balance) {
        this.mc.field_71439_g.func_184185_a(OxygenSoundEffects.SELL.soundEvent, 0.5f, 1.0f);
        this.balanceElement.setValue(balance);
        this.balanceElement.setRed(balance == 0L);
        if (!this.screen.merchantProfile.isUsingCurrency()) {
            InventoryHelper.removeEqualStack((EntityPlayer)this.mc.field_71439_g, (ItemStackWrapper)this.screen.merchantProfile.getCurrencyStack(), (int)((int)offer.getBuyCost()));
        }
        InventoryHelper.addItemStack((EntityPlayer)this.mc.field_71439_g, (ItemStack)offer.getOfferedStack().getCachedItemStack(), (int)offer.getAmount());
        this.inventoryLoadElement.updateLoad();
        this.screen.updateInventoryContent();
        this.updateOffers();
    }

    private void updateOffers() {
        for (GUIButton button : this.offersPanel.buttonsBuffer) {
            OfferGUIButton offerButton = (OfferGUIButton)button;
            MerchantOffer offer = this.screen.merchantProfile.getOffer((Long)offerButton.index);
            offerButton.setAvailable(!this.inventoryLoadElement.isOverloaded() && offer.getBuyCost() <= this.balanceElement.getValue());
            if ((Long)offerButton.index != offer.offerId) continue;
            offerButton.setPlayerStock(this.screen.getEqualStackAmount(offer.getOfferedStack()));
        }
    }

    public void sold(MerchantOffer offer, long balance) {
        this.mc.field_71439_g.func_184185_a(OxygenSoundEffects.SELL.soundEvent, 0.5f, 1.0f);
        this.balanceElement.setValue(balance);
        this.balanceElement.setRed(balance == 0L);
        if (!this.screen.merchantProfile.isUsingCurrency()) {
            InventoryHelper.addItemStack((EntityPlayer)this.mc.field_71439_g, (ItemStack)this.screen.merchantProfile.getCurrencyStack().getCachedItemStack(), (int)((int)offer.getSellingCost()));
        }
        InventoryHelper.removeEqualStack((EntityPlayer)this.mc.field_71439_g, (ItemStackWrapper)offer.getOfferedStack(), (int)offer.getAmount());
        this.inventoryLoadElement.updateLoad();
        this.screen.updateInventoryContent();
        this.updateOffers();
    }

    public CurrencyItemValueGUIElement getBalanceElement() {
        return this.balanceElement;
    }

    public InventoryLoadGUIElement getInventoryLoadElement() {
        return this.inventoryLoadElement;
    }
}

