/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.client.gui.merchant;

import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.screen.core.GUIWorkspace;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_merchants.client.MerchantsManagerClient;
import austeretony.oxygen_merchants.client.gui.merchant.BuyGUISection;
import austeretony.oxygen_merchants.client.gui.merchant.SellingGUISection;
import austeretony.oxygen_merchants.common.MerchantOffer;
import austeretony.oxygen_merchants.common.MerchantProfile;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class MerchantMenuGUIScreen
extends AbstractGUIScreen {
    public final MerchantProfile merchantProfile;
    protected BuyGUISection buySection;
    protected SellingGUISection sellingSection;
    public final Map<ItemStackWrapper, Integer> inventoryContent = new LinkedHashMap<ItemStackWrapper, Integer>();

    public MerchantMenuGUIScreen(long profileId) {
        this.merchantProfile = MerchantsManagerClient.instance().getMerchantProfilesContainer().getProfile(profileId);
        this.updateInventoryContent();
    }

    protected GUIWorkspace initWorkspace() {
        return new GUIWorkspace((AbstractGUIScreen)this, 173, 195).setAlignment(EnumGUIAlignment.RIGHT, -10, 0);
    }

    protected void initSections() {
        this.buySection = (BuyGUISection)((AbstractGUISection)new BuyGUISection(this).setDisplayText(ClientReference.localize((String)"oxygen_merchants.gui.merchant.buy", (Object[])new Object[0]))).enable();
        this.getWorkspace().initSection((AbstractGUISection)this.buySection);
        this.sellingSection = (SellingGUISection)((AbstractGUISection)new SellingGUISection(this).setDisplayText(ClientReference.localize((String)"oxygen_merchants.gui.merchant.selling", (Object[])new Object[0]))).enable();
        this.getWorkspace().initSection((AbstractGUISection)this.sellingSection);
    }

    protected AbstractGUISection getDefaultSection() {
        return this.buySection;
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element) {
    }

    protected boolean doesGUIPauseGame() {
        return false;
    }

    public void bought(MerchantOffer offer, long balance) {
        this.buySection.bought(offer, balance);
        this.sellingSection.bought(offer, balance);
    }

    public void sold(MerchantOffer offer, long balance) {
        this.buySection.sold(offer, balance);
        this.sellingSection.sold(offer, balance);
    }

    public BuyGUISection getBuySection() {
        return this.buySection;
    }

    public SellingGUISection getSellingSection() {
        return this.sellingSection;
    }

    public void updateInventoryContent() {
        this.inventoryContent.clear();
        for (ItemStack itemStack : ClientReference.getClientPlayer().field_71071_by.field_70462_a) {
            if (itemStack.func_190926_b()) continue;
            ItemStackWrapper wrapper = ItemStackWrapper.getFromStack((ItemStack)itemStack);
            if (!this.inventoryContent.containsKey(wrapper)) {
                this.inventoryContent.put(wrapper, itemStack.func_190916_E());
                continue;
            }
            int amount = this.inventoryContent.get(wrapper);
            this.inventoryContent.put(wrapper, amount += itemStack.func_190916_E());
        }
    }

    public int getEqualStackAmount(ItemStackWrapper stackWrapper) {
        int amount = 0;
        for (ItemStackWrapper wrapper : this.inventoryContent.keySet()) {
            if (!wrapper.isEquals(stackWrapper)) continue;
            amount += this.inventoryContent.get(wrapper).intValue();
        }
        return amount;
    }
}

