/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.client.gui.merchant;

import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.screen.text.GUITextField;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.gui.elements.CurrencyItemValueGUIElement;
import austeretony.oxygen_core.client.gui.elements.InventoryLoadGUIElement;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButtonPanel;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIText;
import austeretony.oxygen_core.client.gui.elements.OxygenGUITextField;
import austeretony.oxygen_core.client.gui.elements.SectionsGUIDDList;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_merchants.client.MerchantsManagerClient;
import austeretony.oxygen_merchants.client.gui.merchant.MerchantBackgroundGUIFiller;
import austeretony.oxygen_merchants.client.gui.merchant.MerchantMenuGUIScreen;
import austeretony.oxygen_merchants.client.gui.merchant.OfferGUIButton;
import austeretony.oxygen_merchants.common.MerchantOffer;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.item.ItemStack;

public class SellingGUISection
extends AbstractGUISection {
    private final MerchantMenuGUIScreen screen;
    private OxygenGUITextField searchField;
    private OxygenGUIButtonPanel offersPanel;
    private CurrencyItemValueGUIElement balanceElement;
    private InventoryLoadGUIElement inventoryLoadElement;

    public SellingGUISection(MerchantMenuGUIScreen screen) {
        super((AbstractGUIScreen)screen);
        this.screen = screen;
    }

    public void init() {
        this.addElement((GUIBaseElement)new MerchantBackgroundGUIFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenGUIText(4, 5, this.screen.merchantProfile.getName(), GUISettings.get().getTitleScale(), GUISettings.get().getEnabledTextColor()));
        this.offersPanel = new OxygenGUIButtonPanel((AbstractGUIScreen)this.screen, 6, 27, this.getWidth() - 15, 16, 1, MathUtils.clamp((int)this.getSellingOffersAmount(), (int)9, (int)100), 9, GUISettings.get().getPanelTextScale(), true);
        this.addElement((GUIBaseElement)this.offersPanel);
        this.searchField = new OxygenGUITextField(6, 17, 65, 8, 24, "...", 3, false, -1L);
        this.addElement((GUIBaseElement)this.searchField);
        this.offersPanel.initSearchField((GUITextField)this.searchField);
        this.offersPanel.setClickListener((previous, clicked, mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0 && clicked.isAvailable()) {
                MerchantsManagerClient.instance().getMenuManager().performSellingSynced(this.screen.merchantProfile.getId(), (Long)clicked.index);
            }
        });
        this.addElement((GUIBaseElement)new SectionsGUIDDList(this.getWidth() - 4, 5, new AbstractGUISection[]{this, this.screen.getBuySection()}));
        this.balanceElement = new CurrencyItemValueGUIElement(this.getWidth() - 10, this.getHeight() - 10);
        this.addElement((GUIBaseElement)this.balanceElement);
        if (!this.screen.merchantProfile.isUsingCurrency()) {
            this.balanceElement.setItemStack(this.screen.merchantProfile.getCurrencyStack().getItemStack());
        }
        this.balanceElement.setValue(this.screen.getBuySection().getBalanceElement().getValue());
        this.balanceElement.setRed(this.balanceElement.getValue() == 0L);
        this.inventoryLoadElement = new InventoryLoadGUIElement(4, this.getHeight() - 9, EnumGUIAlignment.RIGHT);
        this.addElement((GUIBaseElement)this.inventoryLoadElement);
        this.inventoryLoadElement.setLoad(this.screen.getBuySection().getInventoryLoadElement().getLoad());
        this.loadOffers();
    }

    private int getSellingOffersAmount() {
        return (int)this.screen.merchantProfile.getOffers().stream().filter(offer -> offer.isSellingEnabled()).count();
    }

    private void loadOffers() {
        ArrayList<MerchantOffer> offers = new ArrayList<MerchantOffer>(this.screen.merchantProfile.getOffers());
        Collections.sort(offers, (o1, o2) -> (int)((o1.offerId - o2.offerId) / 5000L));
        ItemStack currencyItemStack = null;
        if (!this.screen.merchantProfile.isUsingCurrency()) {
            currencyItemStack = this.screen.merchantProfile.getCurrencyStack().getItemStack();
        }
        for (MerchantOffer offer : offers) {
            if (!offer.isSellingEnabled()) continue;
            int stock = this.screen.getEqualStackAmount(offer.getOfferedStack());
            this.offersPanel.addButton((GUIButton)new OfferGUIButton(offer, offer.getSellingCost(), stock, currencyItemStack).setAvailable((this.screen.merchantProfile.isUsingCurrency() || !this.inventoryLoadElement.isOverloaded()) && stock >= offer.getAmount()));
        }
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
    }

    public void bought(MerchantOffer offer, long balance) {
        this.balanceElement.setValue(balance);
        this.balanceElement.setRed(balance == 0L);
        this.inventoryLoadElement.setLoad(this.screen.getBuySection().getInventoryLoadElement().getLoad());
        this.updateOffers();
    }

    private void updateOffers() {
        for (GUIButton button : this.offersPanel.buttonsBuffer) {
            OfferGUIButton offerButton = (OfferGUIButton)button;
            MerchantOffer offer = this.screen.merchantProfile.getOffer((Long)offerButton.index);
            int stock = this.screen.getEqualStackAmount(offer.getOfferedStack());
            offerButton.setAvailable((this.screen.merchantProfile.isUsingCurrency() || !this.inventoryLoadElement.isOverloaded()) && stock >= offer.getAmount());
            offerButton.setPlayerStock(stock);
        }
    }

    public void sold(MerchantOffer offer, long balance) {
        this.balanceElement.setValue(balance);
        this.balanceElement.setRed(balance == 0L);
        this.inventoryLoadElement.setLoad(this.screen.getBuySection().getInventoryLoadElement().getLoad());
        this.updateOffers();
    }
}

