/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.common;

import austeretony.oxygen_core.common.persistent.PersistentEntry;
import austeretony.oxygen_core.common.sync.SynchronizedData;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.common.util.StreamUtils;
import io.netty.buffer.ByteBuf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class BoundEntityEntry
implements PersistentEntry,
SynchronizedData {
    public static final int MAX_NAME_LENGTH = 20;
    public static final int MAX_PROFESSION_LENGTH = 30;
    private long bondId;
    private long profileId;
    private UUID entityUUID;
    private int dimId;
    private int xPos;
    private int yPos;
    private int zPos;
    private String name;
    private String profession;
    private boolean dead;

    public BoundEntityEntry() {
    }

    public BoundEntityEntry(UUID entityUUID, int dimId, int xPos, int yPos, int zPos) {
        this.entityUUID = entityUUID;
        this.dimId = dimId;
        this.xPos = xPos;
        this.yPos = yPos;
        this.zPos = zPos;
    }

    public long getId() {
        return this.bondId;
    }

    public void setId(long bondId) {
        this.bondId = bondId;
    }

    public UUID getEntityUUID() {
        return this.entityUUID;
    }

    public int getDimension() {
        return this.dimId;
    }

    public int getXPos() {
        return this.xPos;
    }

    public int getYPos() {
        return this.yPos;
    }

    public int getZPos() {
        return this.zPos;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String str) {
        this.name = str;
    }

    public String getProfession() {
        return this.profession;
    }

    public void setProfession(String str) {
        this.profession = str;
    }

    public long getMerchantProfileId() {
        return this.profileId;
    }

    public void setMerchantProfileId(long value) {
        this.profileId = value;
    }

    public boolean isDead() {
        return this.dead;
    }

    public void markDead() {
        this.dead = true;
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((UUID)this.entityUUID, (OutputStream)bos);
        StreamUtils.write((int)this.dimId, (OutputStream)bos);
        StreamUtils.write((int)this.xPos, (OutputStream)bos);
        StreamUtils.write((int)this.yPos, (OutputStream)bos);
        StreamUtils.write((int)this.zPos, (OutputStream)bos);
        StreamUtils.write((long)this.bondId, (OutputStream)bos);
        StreamUtils.write((String)this.name, (OutputStream)bos);
        StreamUtils.write((String)this.profession, (OutputStream)bos);
        StreamUtils.write((long)this.profileId, (OutputStream)bos);
        StreamUtils.write((boolean)this.dead, (OutputStream)bos);
    }

    public void read(BufferedInputStream bis) throws IOException {
        this.entityUUID = StreamUtils.readUUID((InputStream)bis);
        this.dimId = StreamUtils.readInt((InputStream)bis);
        this.xPos = StreamUtils.readInt((InputStream)bis);
        this.yPos = StreamUtils.readInt((InputStream)bis);
        this.zPos = StreamUtils.readInt((InputStream)bis);
        this.bondId = StreamUtils.readLong((InputStream)bis);
        this.name = StreamUtils.readString((InputStream)bis);
        this.profession = StreamUtils.readString((InputStream)bis);
        this.profileId = StreamUtils.readLong((InputStream)bis);
        this.dead = StreamUtils.readBoolean((InputStream)bis);
    }

    public void write(ByteBuf buffer) {
        ByteBufUtils.writeUUID((UUID)this.entityUUID, (ByteBuf)buffer);
        buffer.writeLong(this.bondId);
        ByteBufUtils.writeString((String)this.name, (ByteBuf)buffer);
        ByteBufUtils.writeString((String)this.profession, (ByteBuf)buffer);
        buffer.writeLong(this.profileId);
        buffer.writeBoolean(this.dead);
    }

    public void read(ByteBuf buffer) {
        this.entityUUID = ByteBufUtils.readUUID((ByteBuf)buffer);
        this.bondId = buffer.readLong();
        this.name = ByteBufUtils.readString((ByteBuf)buffer);
        this.profession = ByteBufUtils.readString((ByteBuf)buffer);
        this.profileId = buffer.readLong();
        this.dead = buffer.readBoolean();
    }

    public BoundEntityEntry copy() {
        BoundEntityEntry entry = new BoundEntityEntry(this.entityUUID, this.dimId, this.xPos, this.yPos, this.zPos);
        entry.bondId = this.bondId;
        entry.name = this.name;
        entry.profession = this.profession;
        entry.profileId = this.profileId;
        entry.dead = this.dead;
        return entry;
    }
}

