/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.common;

import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_core.common.util.StreamUtils;
import io.netty.buffer.ByteBuf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MerchantOffer {
    public final long offerId;
    private ItemStackWrapper offeredStack;
    private int amount;
    private long buyCost;
    private long sellingCost;
    private boolean sellingEnabled;
    private boolean sellingOnly;

    public MerchantOffer(long offerId, ItemStackWrapper offeredStack) {
        this.offerId = offerId;
        this.offeredStack = offeredStack;
    }

    public void setItemStack(ItemStackWrapper offeredStack) {
        this.offeredStack = offeredStack;
    }

    public ItemStackWrapper getOfferedStack() {
        return this.offeredStack;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean isSellingEnabled() {
        return this.sellingEnabled;
    }

    public void setSellingEnabled(boolean flag) {
        this.sellingEnabled = flag;
    }

    public boolean isSellingOnly() {
        return this.sellingOnly;
    }

    public void setSellingOnly(boolean flag) {
        this.sellingOnly = flag;
    }

    public long getBuyCost() {
        return this.buyCost;
    }

    public void setBuyCost(long value) {
        this.buyCost = MathUtils.clamp((long)value, (long)0L, (long)Long.MAX_VALUE);
    }

    public long getSellingCost() {
        return this.sellingCost;
    }

    public void setSellingCost(long value) {
        this.sellingCost = MathUtils.clamp((long)value, (long)0L, (long)Long.MAX_VALUE);
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((long)this.offerId, (OutputStream)bos);
        this.offeredStack.write(bos);
        StreamUtils.write((short)((short)this.amount), (OutputStream)bos);
        StreamUtils.write((boolean)this.sellingEnabled, (OutputStream)bos);
        StreamUtils.write((boolean)this.sellingOnly, (OutputStream)bos);
        StreamUtils.write((long)this.buyCost, (OutputStream)bos);
        StreamUtils.write((long)this.sellingCost, (OutputStream)bos);
    }

    public static MerchantOffer read(BufferedInputStream bis) throws IOException {
        MerchantOffer offer = new MerchantOffer(StreamUtils.readLong((InputStream)bis), ItemStackWrapper.read((BufferedInputStream)bis));
        offer.amount = StreamUtils.readShort((InputStream)bis);
        offer.sellingEnabled = StreamUtils.readBoolean((InputStream)bis);
        offer.sellingOnly = StreamUtils.readBoolean((InputStream)bis);
        offer.buyCost = StreamUtils.readLong((InputStream)bis);
        offer.sellingCost = StreamUtils.readLong((InputStream)bis);
        return offer;
    }

    public void write(ByteBuf buffer) {
        buffer.writeLong(this.offerId);
        this.offeredStack.write(buffer);
        buffer.writeShort((int)((short)this.amount));
        buffer.writeBoolean(this.sellingEnabled);
        buffer.writeBoolean(this.sellingOnly);
        buffer.writeLong(this.buyCost);
        buffer.writeLong(this.sellingCost);
    }

    public static MerchantOffer read(ByteBuf buffer) {
        MerchantOffer offer = new MerchantOffer(buffer.readLong(), ItemStackWrapper.read((ByteBuf)buffer));
        offer.amount = buffer.readShort();
        offer.sellingEnabled = buffer.readBoolean();
        offer.sellingOnly = buffer.readBoolean();
        offer.buyCost = buffer.readLong();
        offer.sellingCost = buffer.readLong();
        return offer;
    }

    public MerchantOffer copy() {
        MerchantOffer offer = new MerchantOffer(this.offerId, this.offeredStack.copy());
        offer.amount = this.amount;
        offer.sellingEnabled = this.sellingEnabled;
        offer.sellingOnly = this.sellingOnly;
        offer.buyCost = this.buyCost;
        offer.sellingCost = this.sellingCost;
        return offer;
    }
}

