/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_merchants.common.BoundEntityEntry;
import austeretony.oxygen_merchants.common.EnumAction;
import austeretony.oxygen_merchants.common.config.MerchantsConfig;
import austeretony.oxygen_merchants.common.main.EnumMerchantsStatusMessage;
import austeretony.oxygen_merchants.common.main.MerchantsMain;
import austeretony.oxygen_merchants.common.network.client.CPEntityAction;
import austeretony.oxygen_merchants.server.MerchantsManagerServer;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class BoundEntitiesManagerServer {
    private final MerchantsManagerServer manager;

    protected BoundEntitiesManagerServer(MerchantsManagerServer manager) {
        this.manager = manager;
    }

    public void merchantProfileEdited(long oldProfileId, long newProfileId) {
        HashSet<BoundEntityEntry> cache = new HashSet<BoundEntityEntry>();
        for (BoundEntityEntry entry : this.manager.getBoundEntitiesContainer().getEntries()) {
            if (entry.getMerchantProfileId() != oldProfileId) continue;
            cache.add(entry);
        }
        for (BoundEntityEntry entry : cache) {
            this.manager.getBoundEntitiesContainer().removeEntry(entry.getId());
            BoundEntityEntry copy = entry.copy();
            copy.setMerchantProfileId(newProfileId);
            copy.setId(this.manager.getBoundEntitiesContainer().createId(entry.getId()));
            this.manager.getBoundEntitiesContainer().addEntry(copy);
        }
        if (!cache.isEmpty()) {
            this.manager.getBoundEntitiesContainer().setChanged(true);
        }
    }

    public void merchantProfileRemoved(long profileId) {
        HashSet<BoundEntityEntry> cache = new HashSet<BoundEntityEntry>();
        for (BoundEntityEntry entry : this.manager.getBoundEntitiesContainer().getEntries()) {
            if (entry.getMerchantProfileId() != profileId) continue;
            cache.add(entry);
        }
        for (BoundEntityEntry entry : cache) {
            this.manager.getBoundEntitiesContainer().removeEntry(entry.getId());
            BoundEntityEntry copy = entry.copy();
            copy.setMerchantProfileId(0L);
            copy.setId(this.manager.getBoundEntitiesContainer().createId(entry.getId()));
            this.manager.getBoundEntitiesContainer().addEntry(copy);
        }
        if (!cache.isEmpty()) {
            this.manager.getBoundEntitiesContainer().setChanged(true);
        }
    }

    public void informPlayer(EntityPlayerMP playerMP, EnumMerchantsStatusMessage status) {
        OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)4, (int)status.ordinal());
    }

    public void createEntry(EntityPlayerMP playerMP, int entityId, String name, String profession, long profileId) {
        Entity pointed;
        if (CommonReference.isPlayerOpped((EntityPlayer)playerMP) && MerchantsConfig.ALLOW_INGAME_MANAGEMENT.getBooleanValue() && (pointed = playerMP.field_70170_p.func_73045_a(entityId)) != null && pointed instanceof EntityLiving && !this.manager.getBoundEntitiesContainer().entryExist(CommonReference.getPersistentUUID((Entity)pointed))) {
            BoundEntityEntry entry = new BoundEntityEntry(CommonReference.getPersistentUUID((Entity)pointed), pointed.field_71093_bK, (int)pointed.field_70165_t, (int)pointed.field_70163_u, (int)pointed.field_70161_v);
            entry.setId(System.currentTimeMillis());
            entry.setName(name);
            entry.setProfession(profession);
            entry.setMerchantProfileId(profileId);
            this.manager.getBoundEntitiesContainer().addEntry(entry);
            ((EntityLiving)pointed).func_110163_bv();
            OxygenMain.network().sendTo((Packet)new CPEntityAction(EnumAction.CREATED, entry), playerMP);
            this.informPlayer(playerMP, EnumMerchantsStatusMessage.ENTITY_CREATED);
            this.manager.getBoundEntitiesContainer().setChanged(true);
            MerchantsMain.LOGGER.info("Bond creration - SERVER. Entity id: {}, uuid: {}.", (Object)pointed.func_145782_y(), (Object)pointed.getPersistentID());
        }
    }

    public void editEntry(EntityPlayerMP playerMP, long oldBondId, String name, String profession, long profileId) {
        if (CommonReference.isPlayerOpped((EntityPlayer)playerMP) && MerchantsConfig.ALLOW_INGAME_MANAGEMENT.getBooleanValue() && this.manager.getBoundEntitiesContainer().entryExist(oldBondId)) {
            BoundEntityEntry entry = this.manager.getBoundEntitiesContainer().getBoundEntityEntry(oldBondId);
            this.manager.getBoundEntitiesContainer().removeEntry(oldBondId);
            entry.setId(oldBondId + 1L);
            entry.setName(name);
            entry.setProfession(profession);
            entry.setMerchantProfileId(profileId);
            this.manager.getBoundEntitiesContainer().addEntry(entry);
            OxygenMain.network().sendTo((Packet)new CPEntityAction(EnumAction.UPDATED, entry), playerMP);
            this.informPlayer(playerMP, EnumMerchantsStatusMessage.ENTITY_UPDATED);
            this.manager.getBoundEntitiesContainer().setChanged(true);
        }
    }

    public void visitEntity(EntityPlayerMP playerMP, long bondId) {
        if (CommonReference.isPlayerOpped((EntityPlayer)playerMP) && this.manager.getBoundEntitiesContainer().entryExist(bondId)) {
            BoundEntityEntry entry = this.manager.getBoundEntitiesContainer().getBoundEntityEntry(bondId);
            CommonReference.delegateToServerThread(() -> CommonReference.teleportPlayer((EntityPlayerMP)playerMP, (int)entry.getDimension(), (double)entry.getXPos(), (double)entry.getYPos(), (double)entry.getZPos()));
        }
    }

    public void removeEntry(EntityPlayerMP playerMP, long bondId) {
        if (CommonReference.isPlayerOpped((EntityPlayer)playerMP) && MerchantsConfig.ALLOW_INGAME_MANAGEMENT.getBooleanValue() && this.manager.getBoundEntitiesContainer().entryExist(bondId)) {
            BoundEntityEntry entry = this.manager.getBoundEntitiesContainer().getBoundEntityEntry(bondId);
            this.manager.getBoundEntitiesContainer().removeEntry(bondId);
            OxygenMain.network().sendTo((Packet)new CPEntityAction(EnumAction.REMOVED, entry), playerMP);
            this.informPlayer(playerMP, EnumMerchantsStatusMessage.ENTITY_REMOVED);
            this.manager.getBoundEntitiesContainer().setChanged(true);
        }
    }

    public void entityLivingDied(UUID entityUUID) {
        if (this.manager.getBoundEntitiesContainer().entryExist(entityUUID)) {
            BoundEntityEntry entry = this.manager.getBoundEntitiesContainer().getBoundEntityEntry(entityUUID);
            long oldBondId = entry.getId();
            this.manager.getBoundEntitiesContainer().removeEntry(oldBondId);
            entry.setId(oldBondId + 1L);
            entry.markDead();
            this.manager.getBoundEntitiesContainer().addEntry(entry);
            this.manager.getBoundEntitiesContainer().setChanged(true);
        }
    }
}

