/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.server;

import austeretony.oxygen_core.common.persistent.PersistentData;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_merchants.server.BoundEntitiesContainerServer;
import austeretony.oxygen_merchants.server.BoundEntitiesManagerServer;
import austeretony.oxygen_merchants.server.MerchantProfilesContainerServer;
import austeretony.oxygen_merchants.server.MerchantProfilesManagerServer;
import austeretony.oxygen_merchants.server.PlayersManagerServer;
import net.minecraft.entity.player.EntityPlayerMP;

public class MerchantsManagerServer {
    private static MerchantsManagerServer instance;
    private final MerchantProfilesContainerServer profilesContainer = new MerchantProfilesContainerServer();
    private final BoundEntitiesContainerServer entitiesContainer = new BoundEntitiesContainerServer();
    private final MerchantProfilesManagerServer profilesManager = new MerchantProfilesManagerServer(this);
    private final BoundEntitiesManagerServer entitiesManager = new BoundEntitiesManagerServer(this);
    private final PlayersManagerServer playersManager = new PlayersManagerServer(this);

    private MerchantsManagerServer() {
    }

    private void registerPersistentData() {
        OxygenHelperServer.registerPersistentData((PersistentData)this.profilesContainer);
        OxygenHelperServer.registerPersistentData((PersistentData)this.entitiesContainer);
    }

    public static void create() {
        if (instance == null) {
            instance = new MerchantsManagerServer();
            instance.registerPersistentData();
        }
    }

    public static MerchantsManagerServer instance() {
        return instance;
    }

    public MerchantProfilesContainerServer getMerchantProfilesContainer() {
        return this.profilesContainer;
    }

    public BoundEntitiesContainerServer getBoundEntitiesContainer() {
        return this.entitiesContainer;
    }

    public MerchantProfilesManagerServer getMerchantProfilesManager() {
        return this.profilesManager;
    }

    public BoundEntitiesManagerServer getBoundEntitiesManager() {
        return this.entitiesManager;
    }

    public PlayersManagerServer getPlayersManager() {
        return this.playersManager;
    }

    public void onPlayerLoaded(EntityPlayerMP playerMP) {
        this.playersManager.onPlayerLoaded(playerMP);
    }

    public void onPlayerUnloaded(EntityPlayerMP playerMP) {
        this.playersManager.onPlayerUnloaded(playerMP);
    }

    public void worldLoaded() {
        OxygenHelperServer.loadPersistentDataAsync((PersistentData)this.profilesContainer);
        OxygenHelperServer.loadPersistentDataAsync((PersistentData)this.entitiesContainer);
    }
}

