/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.currency.CurrencyHelperServer;
import austeretony.oxygen_core.common.inventory.InventoryHelper;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.server.api.WatcherHelperServer;
import austeretony.oxygen_merchants.common.EnumMerchantOperation;
import austeretony.oxygen_merchants.common.MerchantOffer;
import austeretony.oxygen_merchants.common.MerchantProfile;
import austeretony.oxygen_merchants.common.network.client.CPMerchantAction;
import austeretony.oxygen_merchants.server.MerchantsManagerServer;
import austeretony.oxygen_merchants.server.QueuedMerchantOperation;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;

public class OperationsProcessor {
    private final UUID playerUUID;
    private final Queue<QueuedMerchantOperation> operations = new ConcurrentLinkedQueue<QueuedMerchantOperation>();

    public OperationsProcessor(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    public void addOperation(EnumMerchantOperation operation, long profileId, long offerId) {
        this.operations.offer(new QueuedMerchantOperation(operation, profileId, offerId));
    }

    public void process() {
        MerchantProfile profile = null;
        boolean save = false;
        while (!this.operations.isEmpty()) {
            QueuedMerchantOperation operation = this.operations.poll();
            if (profile == null) {
                if (!MerchantsManagerServer.instance().getMerchantProfilesContainer().profileExist(operation.profileId)) break;
                profile = MerchantsManagerServer.instance().getMerchantProfilesContainer().getProfile(operation.profileId);
            }
            if (profile == null || !profile.offerExist(operation.offerId)) continue;
            EntityPlayerMP playerMP = CommonReference.playerByUUID((UUID)this.playerUUID);
            MerchantOffer offer = profile.getOffer(operation.offerId);
            switch (operation.operation) {
                case BUY: {
                    if (offer.isSellingOnly()) break;
                    save = this.buy(playerMP, profile, offer);
                    break;
                }
                case SELLING: {
                    if (!offer.isSellingEnabled()) break;
                    save = this.sell(playerMP, profile, offer);
                }
            }
        }
        if (save) {
            CurrencyHelperServer.save((UUID)this.playerUUID);
            WatcherHelperServer.setValue((UUID)this.playerUUID, (int)0, (long)CurrencyHelperServer.getCurrency((UUID)this.playerUUID));
        }
    }

    private boolean buy(EntityPlayerMP playerMP, MerchantProfile profile, MerchantOffer offer) {
        long balance;
        boolean save = false;
        if (!InventoryHelper.haveEnoughSpace((EntityPlayer)playerMP, (int)offer.getAmount(), (int)offer.getOfferedStack().getCachedItemStack().func_77976_d())) {
            return false;
        }
        if (profile.isUsingCurrency()) {
            if (!CurrencyHelperServer.enoughCurrency((UUID)this.playerUUID, (long)offer.getBuyCost())) {
                return false;
            }
            CurrencyHelperServer.removeCurrency((UUID)this.playerUUID, (long)offer.getBuyCost());
            save = true;
            balance = CurrencyHelperServer.getCurrency((UUID)this.playerUUID);
        } else {
            balance = InventoryHelper.getEqualStackAmount((EntityPlayer)playerMP, (ItemStackWrapper)profile.getCurrencyStack());
            if (balance < offer.getBuyCost()) {
                return false;
            }
            CommonReference.delegateToServerThread(() -> InventoryHelper.removeEqualStack((EntityPlayer)playerMP, (ItemStackWrapper)profile.getCurrencyStack(), (int)((int)offer.getBuyCost())));
            balance -= offer.getBuyCost();
        }
        CommonReference.delegateToServerThread(() -> InventoryHelper.addItemStack((EntityPlayer)playerMP, (ItemStack)offer.getOfferedStack().getItemStack(), (int)offer.getAmount()));
        this.notifyPlayer(playerMP, EnumMerchantOperation.BUY, offer, balance);
        return save;
    }

    private boolean sell(EntityPlayerMP playerMP, MerchantProfile profile, MerchantOffer offer) {
        long balance;
        boolean save = false;
        if (!profile.isUsingCurrency() && !InventoryHelper.haveEnoughSpace((EntityPlayer)playerMP, (int)((int)offer.getSellingCost()), (int)offer.getOfferedStack().getCachedItemStack().func_77976_d())) {
            return false;
        }
        if (InventoryHelper.getEqualStackAmount((EntityPlayer)playerMP, (ItemStackWrapper)offer.getOfferedStack()) < offer.getAmount()) {
            return false;
        }
        if (profile.isUsingCurrency()) {
            CurrencyHelperServer.addCurrency((UUID)this.playerUUID, (long)offer.getSellingCost());
            save = true;
            balance = CurrencyHelperServer.getCurrency((UUID)this.playerUUID);
        } else {
            balance = InventoryHelper.getEqualStackAmount((EntityPlayer)playerMP, (ItemStackWrapper)profile.getCurrencyStack());
            CommonReference.delegateToServerThread(() -> InventoryHelper.addItemStack((EntityPlayer)playerMP, (ItemStack)profile.getCurrencyStack().getItemStack(), (int)((int)offer.getSellingCost())));
            balance += offer.getSellingCost();
        }
        CommonReference.delegateToServerThread(() -> InventoryHelper.removeEqualStack((EntityPlayer)playerMP, (ItemStackWrapper)offer.getOfferedStack(), (int)offer.getAmount()));
        this.notifyPlayer(playerMP, EnumMerchantOperation.SELLING, offer, balance);
        return save;
    }

    public void notifyPlayer(EntityPlayerMP playerMP, EnumMerchantOperation operation, MerchantOffer offer, long balance) {
        OxygenMain.network().sendTo((Packet)new CPMerchantAction(operation, offer, balance), playerMP);
    }
}

